/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base;

import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.medialist.MediaListRef;
import org.watermedia.videolan4j.player.base.BaseApi;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.list.ControlsApi;
import org.watermedia.videolan4j.player.list.EventApi;
import org.watermedia.videolan4j.player.list.ListApi;
import org.watermedia.videolan4j.player.list.MediaListPlayer;
import org.watermedia.videolan4j.player.list.StatusApi;

public final class SubitemApi
extends BaseApi {
    private final MediaListPlayer mediaListPlayer;

    SubitemApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
        this.mediaListPlayer = new MediaListPlayer(this.libvlcInstance);
        this.mediaListPlayer.mediaPlayer().setMediaPlayer(mediaPlayer);
    }

    public ControlsApi controls() {
        return this.mediaListPlayer.controls();
    }

    public EventApi events() {
        return this.mediaListPlayer.events();
    }

    public ListApi list() {
        return this.mediaListPlayer.list();
    }

    public StatusApi status() {
        return this.mediaListPlayer.status();
    }

    void changeMedia(libvlc_media_t media) {
        this.mediaListPlayer.controls().stop();
        MediaListRef mediaListRef = new MediaListRef(this.libvlcInstance, LibVlc.libvlc_media_subitems(media));
        try {
            this.mediaListPlayer.list().setMediaList(mediaListRef);
        }
        finally {
            mediaListRef.release();
        }
    }

    @Override
    protected void release() {
        this.mediaListPlayer.release();
    }
}

