/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.discovery;

import com.sun.jna.NativeLibrary;
import com.sun.jna.StringArray;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.lib.LibVlcEssential;
import org.watermedia.videolan4j.discovery.DiscoveryEnv;
import org.watermedia.videolan4j.discovery.providers.IProvider;
import org.watermedia.videolan4j.tools.IOTools;

public final class NativeDiscovery {
    public static final Marker IT = MarkerManager.getMarker((String)"NativeDiscovery");
    private static final ServiceLoader<IProvider> PROVIDERS = ServiceLoader.load(IProvider.class);
    private static Map<String, Reference<NativeLibrary>> jnaLibraries;
    private static Map<String, List<String>> jnaSearchPaths;
    private static boolean discovered;
    private static boolean attempted;
    private static String discoveredPath;

    public static boolean discovered() {
        return discovered;
    }

    public static String discoveryPath() {
        return discoveredPath;
    }

    public static synchronized boolean start() {
        if (discovered) {
            return true;
        }
        if (attempted) {
            return false;
        }
        DiscoveryEnv env = DiscoveryEnv.get();
        if (env == null) {
            VideoLan4J.LOGGER.info(IT, "Unsupported environment '{}'", (Object)DiscoveryEnv.osName());
            attempted = true;
            return false;
        }
        block0: for (IProvider provider : NativeDiscovery.getProviders()) {
            VideoLan4J.LOGGER.info(IT, "Searching using '{}'", (Object)provider.name());
            for (String d : provider.directories()) {
                String directory = NativeDiscovery.start$searchPath(env, d);
                if (directory == null) continue;
                if (NativeDiscovery.setSearchPath(env, directory)) {
                    if (NativeDiscovery.testInstance()) {
                        discoveredPath = directory;
                        discovered = true;
                        VideoLan4J.LOGGER.info(IT, "Founded VLC {} in '{}' using '{}'", (Object)VideoLan4J.getVideoLanVersion(), (Object)directory, (Object)provider.name());
                        return true;
                    }
                    VideoLan4J.LOGGER.error(IT, "Failed to load VLC in '{}' using '{}'", (Object)directory, (Object)provider.name());
                    if (!NativeDiscovery.testCleanup()) continue block0;
                    continue;
                }
                VideoLan4J.LOGGER.error(IT, "Failed to set search path for VLC in '{}' using '{}'", (Object)directory, (Object)provider.name());
                if (!NativeDiscovery.testCleanup()) continue block0;
            }
        }
        attempted = true;
        return false;
    }

    private static String start$searchPath(DiscoveryEnv env, String directory) {
        File rootDirectory = new File(directory);
        File[] rootFiles = IOTools.getFixedFile(rootDirectory.toPath()).listFiles();
        if (rootFiles == null) {
            VideoLan4J.LOGGER.debug(IT, "Cannot search on path '{}', {}", (Object)directory, (Object)new DebugDirectory(rootDirectory));
            return null;
        }
        VideoLan4J.LOGGER.info(IT, "Searching on '{}'", (Object)rootDirectory.toString());
        Pattern[] patterns = env.binaryPatterns();
        HashSet<String> matches = new HashSet<String>(patterns.length);
        for (File child : rootFiles) {
            if (child.isDirectory()) {
                String r;
                if (!child.getName().toLowerCase().contains("vlc") || (r = NativeDiscovery.start$searchPath(env, child.getAbsolutePath())) == null) continue;
                return r;
            }
            for (Pattern pattern : patterns) {
                Matcher matcher = pattern.matcher(child.getName());
                if (!matcher.matches()) continue;
                matches.add(pattern.pattern());
                if (matches.size() != patterns.length) continue;
                return directory;
            }
        }
        matches.clear();
        return null;
    }

    private static boolean setSearchPath(DiscoveryEnv env, String path) {
        String pluginPath;
        NativeLibrary.addSearchPath((String)VideoLan4J.LIBVLC_NAME, (String)path);
        if (env == DiscoveryEnv.MACOS) {
            NativeLibrary.addSearchPath((String)VideoLan4J.LIBVLCCORE_NAME, (String)path);
            NativeLibrary.getInstance((String)VideoLan4J.LIBVLCCORE_NAME);
        }
        if ((pluginPath = System.getenv("VLC_PLUGIN_PATH")) == null || pluginPath.isEmpty()) {
            return NativeDiscovery.setPluginPath(env, path);
        }
        return true;
    }

    private static boolean setPluginPath(DiscoveryEnv env, String path) {
        File f = new File(path);
        for (String pluginsPath : env.pluginPaths()) {
            Path p = f.toPath().resolve(pluginsPath);
            if (!p.toFile().exists()) continue;
            return env.setEnvironmentVar("VLC_PLUGIN_PATH", p.toString());
        }
        VideoLan4J.LOGGER.error(IT, "Plugins path doesn't exist");
        return false;
    }

    private static boolean testInstance() {
        try {
            libvlc_instance_t instance = LibVlcEssential.libvlc_new(0, new StringArray(new String[0]));
            if (instance == null) {
                return false;
            }
            LibVlcEssential.libvlc_release(instance);
            if (VideoLan4J.getVideoLanVersion().inRange(VideoLan4J.LIBVLC_MIN_VERSION, VideoLan4J.LIBVLC_MAX_VERSION)) {
                return true;
            }
        }
        catch (Error e) {
            VideoLan4J.LOGGER.error(IT, "Failed to attempt create VLC instance", (Throwable)e);
        }
        return false;
    }

    private static boolean testCleanup() {
        try {
            if (jnaSearchPaths == null) {
                Field searchPaths = NativeLibrary.class.getDeclaredField("searchPaths");
                searchPaths.setAccessible(true);
                jnaSearchPaths = (Map)searchPaths.get(null);
            }
            if (jnaLibraries == null) {
                Field libraries = NativeLibrary.class.getDeclaredField("libraries");
                libraries.setAccessible(true);
                jnaLibraries = (Map)libraries.get(null);
            }
            Reference<NativeLibrary> rm1 = jnaLibraries.remove(VideoLan4J.LIBVLC_NAME);
            Reference<NativeLibrary> rm2 = jnaLibraries.remove(VideoLan4J.LIBVLCCORE_NAME);
            List<String> rm3 = jnaSearchPaths.remove(VideoLan4J.LIBVLC_NAME);
            List<String> rm4 = jnaSearchPaths.remove(VideoLan4J.LIBVLCCORE_NAME);
            return true;
        }
        catch (Exception e) {
            VideoLan4J.LOGGER.error(IT, "Failed to clean JNA search paths, search must be stopped!", (Throwable)e);
            return false;
        }
    }

    private static List<IProvider> getProviders() {
        Iterator<IProvider> i = PROVIDERS.iterator();
        ArrayList<IProvider> result = new ArrayList<IProvider>();
        while (i.hasNext()) {
            IProvider e = i.next();
            if (!e.supported()) continue;
            result.add(e);
        }
        result.sort(Comparator.comparing(IProvider::priority));
        return result;
    }

    static {
        discovered = false;
        attempted = false;
    }

    private static final class DebugDirectory {
        private final String path;
        private final boolean exists;
        private final boolean directory;
        private final boolean readable;
        private final boolean executable;
        private final boolean hidden;

        public DebugDirectory(File file) {
            this.path = file.toPath().toString();
            this.exists = file.exists();
            this.directory = file.isDirectory();
            this.readable = file.canRead();
            this.executable = file.canExecute();
            this.hidden = file.isHidden();
        }

        public String toString() {
            return "DebugDirectory{path='" + this.path + '\'' + ", exists=" + this.exists + ", directory=" + this.directory + ", readable=" + this.readable + ", executable=" + this.executable + ", hidden=" + this.hidden + '}';
        }
    }
}

