/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.watermedia.shaded.kiulian.downloader.Config;
import org.watermedia.shaded.kiulian.downloader.YoutubeException;
import org.watermedia.shaded.kiulian.downloader.cipher.Cipher;
import org.watermedia.shaded.kiulian.downloader.cipher.CipherFactory;
import org.watermedia.shaded.kiulian.downloader.cipher.CipherFunction;
import org.watermedia.shaded.kiulian.downloader.downloader.Downloader;
import org.watermedia.shaded.kiulian.downloader.downloader.YoutubeCallback;
import org.watermedia.shaded.kiulian.downloader.downloader.client.Client;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestChannelUploads;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSearchContinuation;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSearchResult;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSearchable;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSubtitlesInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestWebpage;
import org.watermedia.shaded.kiulian.downloader.downloader.response.Response;
import org.watermedia.shaded.kiulian.downloader.downloader.response.ResponseImpl;
import org.watermedia.shaded.kiulian.downloader.extractor.Extractor;
import org.watermedia.shaded.kiulian.downloader.model.playlist.PlaylistDetails;
import org.watermedia.shaded.kiulian.downloader.model.playlist.PlaylistInfo;
import org.watermedia.shaded.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import org.watermedia.shaded.kiulian.downloader.model.search.ContinuatedSearchResult;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchContinuation;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResult;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultChannelDetails;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultElement;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultItem;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultPlaylistDetails;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultShelf;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultVideoDetails;
import org.watermedia.shaded.kiulian.downloader.model.search.query.QueryAutoCorrection;
import org.watermedia.shaded.kiulian.downloader.model.search.query.QueryElement;
import org.watermedia.shaded.kiulian.downloader.model.search.query.QueryElementType;
import org.watermedia.shaded.kiulian.downloader.model.search.query.QueryRefinementList;
import org.watermedia.shaded.kiulian.downloader.model.search.query.QuerySuggestion;
import org.watermedia.shaded.kiulian.downloader.model.subtitles.SubtitlesInfo;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoDetails;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoInfo;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.AudioFormat;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.Format;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.Itag;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.VideoFormat;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import org.watermedia.shaded.kiulian.downloader.parser.Parser;

public class ParserImpl
implements Parser {
    private static final String ANDROID_APIKEY = "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
    private static final String BASE_API_URL = "https://www.youtube.com/youtubei/v1";
    private final Config config;
    private final Downloader downloader;
    private final Extractor extractor;
    private final DelegatedCipherFactory cipherFactory;

    public ParserImpl(Config config, Downloader downloader, Extractor extractor, CipherFactory cipherFactory) {
        this.config = config;
        this.downloader = downloader;
        this.extractor = extractor;
        this.cipherFactory = new DelegatedCipherFactory(cipherFactory);
    }

    @Override
    public Response<VideoInfo> parseVideo(RequestVideoInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<VideoInfo> result = executorService.submit(() -> this.parseVideo(request.getVideoId(), request.getCallback(), request.getClient()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            VideoInfo result = this.parseVideo(request.getVideoId(), request.getCallback(), request.getClient());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private VideoInfo parseVideo(String videoId, YoutubeCallback<VideoInfo> callback, Client client) throws YoutubeException {
        VideoInfo videoInfo = this.parseVideoAndroid(videoId, callback, client);
        if (videoInfo == null) {
            videoInfo = this.parseVideoWeb(videoId, callback);
        }
        if (callback != null) {
            callback.onFinished(videoInfo);
        }
        return videoInfo;
    }

    private VideoInfo parseVideoAndroid(String videoId, YoutubeCallback<VideoInfo> callback, Client client) throws YoutubeException {
        JSONObject playerResponse;
        String url = "https://www.youtube.com/youtubei/v1/player?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
        RequestWebpage request = (RequestWebpage)new RequestWebpage(url, "POST", client.getBody().fluentPut("videoId", videoId).toJSONString()).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            return null;
        }
        try {
            playerResponse = JSONObject.parseObject(response.data());
        }
        catch (Exception ignore) {
            return null;
        }
        VideoDetails videoDetails = this.parseVideoDetails(videoId, playerResponse);
        if (videoDetails.isDownloadable()) {
            List<Format> formats;
            JSONObject context = playerResponse.getJSONObject("responseContext");
            String clientVersion = this.extractor.extractClientVersionFromContext(context);
            try {
                formats = this.parseFormats(playerResponse, null, clientVersion);
            }
            catch (YoutubeException.InvalidJsUrlException e) {
                JSONObject playerConfig = this.downloadPlayerConfig(videoId, callback);
                try {
                    String jsUrl = this.extractor.extractJsUrlFromConfig(playerConfig, videoId);
                    formats = this.parseFormats(playerResponse, jsUrl, clientVersion);
                }
                catch (YoutubeException ex) {
                    if (callback != null) {
                        callback.onError(ex);
                    }
                    throw ex;
                }
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            List<SubtitlesInfo> subtitlesInfo = this.parseCaptions(playerResponse);
            return new VideoInfo(videoDetails, formats, subtitlesInfo);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private JSONObject downloadPlayerConfig(String videoId, YoutubeCallback<VideoInfo> callback) throws YoutubeException {
        JSONObject playerConfig;
        String htmlUrl = "https://www.youtube.com/watch?v=" + videoId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(htmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", htmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            playerConfig = this.extractor.extractPlayerConfigFromHtml(html);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return playerConfig;
    }

    private VideoInfo parseVideoWeb(String videoId, YoutubeCallback<VideoInfo> callback) throws YoutubeException {
        JSONObject playerConfig = this.downloadPlayerConfig(videoId, callback);
        JSONObject args = playerConfig.getJSONObject("args");
        JSONObject playerResponse = args.getJSONObject("player_response");
        if (!playerResponse.containsKey("streamingData") && !playerResponse.containsKey("videoDetails")) {
            YoutubeException.BadPageException e = new YoutubeException.BadPageException("streamingData and videoDetails not found");
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        VideoDetails videoDetails = this.parseVideoDetails(videoId, playerResponse);
        if (videoDetails.isDownloadable()) {
            List<Format> formats;
            String jsUrl;
            try {
                jsUrl = this.extractor.extractJsUrlFromConfig(playerConfig, videoId);
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            JSONObject context = playerConfig.getJSONObject("args").getJSONObject("player_response").getJSONObject("responseContext");
            String clientVersion = this.extractor.extractClientVersionFromContext(context);
            try {
                formats = this.parseFormats(playerResponse, jsUrl, clientVersion);
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            List<SubtitlesInfo> subtitlesInfo = this.parseCaptions(playerResponse);
            return new VideoInfo(videoDetails, formats, subtitlesInfo);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private VideoDetails parseVideoDetails(String videoId, JSONObject playerResponse) {
        if (!playerResponse.containsKey("videoDetails")) {
            return new VideoDetails(videoId);
        }
        JSONObject videoDetails = playerResponse.getJSONObject("videoDetails");
        String liveHLSUrl = null;
        if (videoDetails.getBooleanValue("isLive") && playerResponse.containsKey("streamingData")) {
            liveHLSUrl = playerResponse.getJSONObject("streamingData").getString("hlsManifestUrl");
        }
        return new VideoDetails(videoDetails, liveHLSUrl);
    }

    private List<Format> parseFormats(JSONObject playerResponse, String jsUrl, String clientVersion) throws YoutubeException {
        if (!playerResponse.containsKey("streamingData")) {
            throw new YoutubeException.BadPageException("streamingData not found");
        }
        JSONObject streamingData = playerResponse.getJSONObject("streamingData");
        JSONArray jsonFormats = new JSONArray();
        if (streamingData.containsKey("formats")) {
            jsonFormats.addAll((Collection<?>)streamingData.getJSONArray("formats"));
        }
        JSONArray jsonAdaptiveFormats = new JSONArray();
        if (streamingData.containsKey("adaptiveFormats")) {
            jsonAdaptiveFormats.addAll((Collection<?>)streamingData.getJSONArray("adaptiveFormats"));
        }
        ArrayList<Format> formats = new ArrayList<Format>(jsonFormats.size() + jsonAdaptiveFormats.size());
        this.populateFormats(formats, jsonFormats, jsUrl, false, clientVersion);
        this.populateFormats(formats, jsonAdaptiveFormats, jsUrl, true, clientVersion);
        return formats;
    }

    private void populateFormats(List<Format> formats, JSONArray jsonFormats, String jsUrl, boolean isAdaptive, String clientVersion) throws YoutubeException.CipherException {
        for (int i = 0; i < jsonFormats.size(); ++i) {
            Itag itag;
            JSONObject json = jsonFormats.getJSONObject(i);
            if ("FORMAT_STREAM_TYPE_OTF".equals(json.getString("type"))) continue;
            int itagValue = json.getIntValue("itag");
            try {
                itag = Itag.valueOf("i" + itagValue);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error parsing format: unknown itag " + itagValue);
                continue;
            }
            try {
                Format format = this.parseFormat(json, jsUrl, itag, isAdaptive, clientVersion);
                formats.add(format);
                continue;
            }
            catch (YoutubeException.CipherException e) {
                throw e;
            }
            catch (YoutubeException e) {
                System.err.println("Error " + e.getMessage() + " parsing format: " + json);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Format parseFormat(JSONObject json, String jsUrl, Itag itag, boolean isAdaptive, String clientVersion) throws YoutubeException {
        boolean hasAudio;
        if (json.containsKey("signatureCipher")) {
            String[] cipherData;
            JSONObject jsonCipher = new JSONObject();
            for (String s : cipherData = json.getString("signatureCipher").replace("\\u0026", "&").split("&")) {
                String[] keyValue = s.split("=");
                jsonCipher.put(keyValue[0], (Object)keyValue[1]);
            }
            if (!jsonCipher.containsKey("url")) {
                throw new YoutubeException.BadPageException("Could not found url in cipher data");
            }
            String urlWithSig = jsonCipher.getString("url");
            try {
                urlWithSig = URLDecoder.decode(urlWithSig, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (!urlWithSig.contains("signature") && (jsonCipher.containsKey("s") || !urlWithSig.contains("&sig=") && !urlWithSig.contains("&lsig="))) {
                if (jsUrl != null || this.cipherFactory.getLastCipher() != null) {
                    String s = jsonCipher.getString("s");
                    try {
                        s = URLDecoder.decode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    Cipher cipher = this.cipherFactory.createCipher(jsUrl);
                    String signature = cipher.getSignature(s);
                    String decipheredUrl = urlWithSig + "&sig=" + signature;
                    json.put("url", (Object)decipheredUrl);
                } else {
                    throw new YoutubeException.InvalidJsUrlException("deciphering is required but no js url");
                }
            }
        }
        boolean hasVideo = itag.isVideo() || json.containsKey("size") || json.containsKey("width");
        boolean bl = hasAudio = itag.isAudio() || json.containsKey("audioQuality");
        if (hasVideo && hasAudio) {
            return new VideoWithAudioFormat(json, isAdaptive, clientVersion);
        }
        if (hasVideo) {
            return new VideoFormat(json, isAdaptive, clientVersion);
        }
        return new AudioFormat(json, isAdaptive, clientVersion);
    }

    private List<SubtitlesInfo> parseCaptions(JSONObject playerResponse) {
        if (!playerResponse.containsKey("captions")) {
            return Collections.emptyList();
        }
        JSONObject captions = playerResponse.getJSONObject("captions");
        JSONObject playerCaptionsTracklistRenderer = captions.getJSONObject("playerCaptionsTracklistRenderer");
        if (playerCaptionsTracklistRenderer == null || playerCaptionsTracklistRenderer.isEmpty()) {
            return Collections.emptyList();
        }
        JSONArray captionsArray = playerCaptionsTracklistRenderer.getJSONArray("captionTracks");
        if (captionsArray == null || captionsArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (int i = 0; i < captionsArray.size(); ++i) {
            JSONObject subtitleInfo = captionsArray.getJSONObject(i);
            String language = subtitleInfo.getString("languageCode");
            String url = subtitleInfo.getString("baseUrl");
            String vssId = subtitleInfo.getString("vssId");
            if (language == null || url == null || vssId == null) continue;
            boolean isAutoGenerated = vssId.startsWith("a.");
            subtitlesInfo.add(new SubtitlesInfo(url, language, isAutoGenerated, true));
        }
        return subtitlesInfo;
    }

    @Override
    public Response<PlaylistInfo> parsePlaylist(RequestPlaylistInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> result = executorService.submit(() -> this.parsePlaylist(request.getPlaylistId(), request.getCallback(), request.getClient()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            PlaylistInfo result = this.parsePlaylist(request.getPlaylistId(), request.getCallback(), request.getClient());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private PlaylistInfo parsePlaylist(String playlistId, YoutubeCallback<PlaylistInfo> callback, Client client) throws YoutubeException {
        List<PlaylistVideoDetails> videos;
        JSONObject initialData;
        String htmlUrl = "https://www.youtube.com/playlist?list=" + playlistId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(htmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", htmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            initialData = this.extractor.extractInitialDataFromHtml(html);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        if (!initialData.containsKey("metadata")) {
            throw new YoutubeException.BadPageException("Invalid initial data json");
        }
        PlaylistDetails playlistDetails = this.parsePlaylistDetails(playlistId, initialData);
        try {
            videos = this.parsePlaylistVideos(initialData, playlistDetails.videoCount(), client);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return new PlaylistInfo(playlistDetails, videos);
    }

    private PlaylistDetails parsePlaylistDetails(String playlistId, JSONObject initialData) {
        String title = initialData.getJSONObject("metadata").getJSONObject("playlistMetadataRenderer").getString("title");
        JSONArray sideBarItems = initialData.getJSONObject("sidebar").getJSONObject("playlistSidebarRenderer").getJSONArray("items");
        String author = null;
        try {
            author = sideBarItems.getJSONObject(1).getJSONObject("playlistSidebarSecondaryInfoRenderer").getJSONObject("videoOwner").getJSONObject("videoOwnerRenderer").getJSONObject("title").getJSONArray("runs").getJSONObject(0).getString("text");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONArray stats = sideBarItems.getJSONObject(0).getJSONObject("playlistSidebarPrimaryInfoRenderer").getJSONArray("stats");
        int videoCount = this.extractor.extractIntegerFromText(stats.getJSONObject(0).getJSONArray("runs").getJSONObject(0).getString("text"));
        long viewCount = this.extractor.extractLongFromText(stats.getJSONObject(1).getString("simpleText"));
        return new PlaylistDetails(playlistId, title, author, videoCount, viewCount);
    }

    private List<PlaylistVideoDetails> parsePlaylistVideos(JSONObject initialData, int videoCount, Client client) throws YoutubeException {
        JSONObject content;
        try {
            content = initialData.getJSONObject("contents").getJSONObject("twoColumnBrowseResultsRenderer").getJSONArray("tabs").getJSONObject(0).getJSONObject("tabRenderer").getJSONObject("content").getJSONObject("sectionListRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("itemSectionRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("playlistVideoListRenderer");
        }
        catch (NullPointerException e) {
            throw new YoutubeException.BadPageException("Playlist initial data not found");
        }
        AbstractList videos = videoCount > 0 ? new ArrayList(videoCount) : new LinkedList();
        this.populatePlaylist(content, videos, client);
        return videos;
    }

    private void populatePlaylist(JSONObject content, List<PlaylistVideoDetails> videos, Client client) throws YoutubeException {
        JSONArray contents;
        if (content.containsKey("contents")) {
            contents = content.getJSONArray("contents");
        } else if (content.containsKey("continuationItems")) {
            contents = content.getJSONArray("continuationItems");
        } else {
            if (content.containsKey("continuations")) {
                JSONObject nextContinuationData = content.getJSONArray("continuations").getJSONObject(0).getJSONObject("nextContinuationData");
                String continuation = nextContinuationData.getString("continuation");
                String ctp = nextContinuationData.getString("clickTrackingParams");
                this.loadPlaylistContinuation(continuation, ctp, videos, client);
                return;
            }
            return;
        }
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject contentsItem = contents.getJSONObject(i);
            if (contentsItem.containsKey("playlistVideoRenderer")) {
                videos.add(new PlaylistVideoDetails(contentsItem.getJSONObject("playlistVideoRenderer")));
                continue;
            }
            if (!contentsItem.containsKey("continuationItemRenderer")) continue;
            JSONObject continuationEndpoint = contentsItem.getJSONObject("continuationItemRenderer").getJSONObject("continuationEndpoint");
            String continuation = continuationEndpoint.getJSONObject("continuationCommand").getString("token");
            String ctp = continuationEndpoint.getString("clickTrackingParams");
            this.loadPlaylistContinuation(continuation, ctp, videos, client);
        }
    }

    private void loadPlaylistContinuation(String continuation, String ctp, List<PlaylistVideoDetails> videos, Client client) throws YoutubeException {
        String url = "https://www.youtube.com/youtubei/v1/browse?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
        JSONObject body = client.getBody().fluentPut("continuation", continuation).fluentPut("clickTracking", new JSONObject().fluentPut("clickTrackingParams", ctp));
        RequestWebpage request = (RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(url, "POST", body.toJSONString()).header("X-YouTube-Client-Name", "1")).header("X-YouTube-Client-Version", client.getVersion())).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
        }
        String html = response.data();
        try {
            JSONObject jsonResponse = JSON.parseObject(html);
            JSONObject content = jsonResponse.containsKey("continuationContents") ? jsonResponse.getJSONObject("continuationContents").getJSONObject("playlistVideoListContinuation") : jsonResponse.getJSONArray("onResponseReceivedActions").getJSONObject(0).getJSONObject("appendContinuationItemsAction");
            this.populatePlaylist(content, videos, client);
        }
        catch (YoutubeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YoutubeException.BadPageException("Could not parse playlist continuation json");
        }
    }

    @Override
    public Response<PlaylistInfo> parseChannelsUploads(RequestChannelUploads request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> result = executorService.submit(() -> this.parseChannelsUploads(request.getChannelId(), request.getCallback(), request.getClient()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            PlaylistInfo result = this.parseChannelsUploads(request.getChannelId(), request.getCallback(), request.getClient());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private PlaylistInfo parseChannelsUploads(String channelId, YoutubeCallback<PlaylistInfo> callback, Client client) throws YoutubeException {
        String playlistId = null;
        if (channelId.length() == 24 && channelId.startsWith("UC")) {
            playlistId = "UU" + channelId.substring(2);
        } else {
            String channelLink = "https://www.youtube.com/c/" + channelId + "/videos?view=57";
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(channelLink));
            if (!response.ok()) {
                YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", channelLink, response.error().getMessage()));
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            String html = response.data();
            Scanner scan = new Scanner(html);
            scan.useDelimiter("list=");
            while (scan.hasNext()) {
                String pId = scan.next();
                if (!pId.startsWith("UU")) continue;
                playlistId = pId.substring(0, 24);
                break;
            }
        }
        if (playlistId == null) {
            YoutubeException.BadPageException e = new YoutubeException.BadPageException("Upload Playlist not found");
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return this.parsePlaylist(playlistId, callback, client);
    }

    @Override
    public Response<List<SubtitlesInfo>> parseSubtitlesInfo(RequestSubtitlesInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<List> result = executorService.submit(() -> this.parseSubtitlesInfo(request.getVideoId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            List<SubtitlesInfo> result = this.parseSubtitlesInfo(request.getVideoId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private List<SubtitlesInfo> parseSubtitlesInfo(String videoId, YoutubeCallback<List<SubtitlesInfo>> callback) throws YoutubeException {
        List<String> languages;
        String xmlUrl = "https://video.google.com/timedtext?hl=en&type=list&v=" + videoId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(xmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", xmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String xml = response.data();
        try {
            languages = this.extractor.extractSubtitlesLanguagesFromXml(xml);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (String language : languages) {
            String url = String.format("https://www.youtube.com/api/timedtext?lang=%s&v=%s", language, videoId);
            subtitlesInfo.add(new SubtitlesInfo(url, language, false));
        }
        return subtitlesInfo;
    }

    @Override
    public Response<SearchResult> parseSearchResult(RequestSearchResult request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<SearchResult> result = executorService.submit(() -> this.parseSearchResult(request.query(), request.encodeParameters(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            SearchResult result = this.parseSearchResult(request.query(), request.encodeParameters(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    @Override
    public Response<SearchResult> parseSearchContinuation(RequestSearchContinuation request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<SearchResult> result = executorService.submit(() -> this.parseSearchContinuation(request.continuation(), request.getCallback(), request.getClient()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            SearchResult result = this.parseSearchContinuation(request.continuation(), request.getCallback(), request.getClient());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    @Override
    public Response<SearchResult> parseSearcheable(RequestSearchable request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<SearchResult> result = executorService.submit(() -> this.parseSearchable(request.searchPath(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            SearchResult result = this.parseSearchable(request.searchPath(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private SearchResult parseSearchResult(String query, String parameters, YoutubeCallback<SearchResult> callback) throws YoutubeException {
        String searchQuery;
        try {
            searchQuery = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            searchQuery = query;
            e.printStackTrace();
        }
        String url = "https://www.youtube.com/results?search_query=" + searchQuery;
        if (parameters != null) {
            url = url + "&sp=" + parameters;
        }
        try {
            return this.parseHtmlSearchResult(url);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
    }

    private SearchResult parseSearchable(String searchPath, YoutubeCallback<SearchResult> callback) throws YoutubeException {
        String url = "https://www.youtube.com" + searchPath;
        try {
            return this.parseHtmlSearchResult(url);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
    }

    private SearchResult parseHtmlSearchResult(String url) throws YoutubeException {
        JSONArray rootContents;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(url));
        if (!response.ok()) {
            throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
        }
        String html = response.data();
        JSONObject initialData = this.extractor.extractInitialDataFromHtml(html);
        try {
            rootContents = initialData.getJSONObject("contents").getJSONObject("twoColumnSearchResultsRenderer").getJSONObject("primaryContents").getJSONObject("sectionListRenderer").getJSONArray("contents");
        }
        catch (NullPointerException e) {
            throw new YoutubeException.BadPageException("Search result root contents not found");
        }
        long estimatedCount = this.extractor.extractLongFromText(initialData.getString("estimatedResults"));
        String clientVersion = this.extractor.extractClientVersionFromContext(initialData.getJSONObject("responseContext"));
        SearchContinuation continuation = this.getSearchContinuation(rootContents, clientVersion);
        return this.parseSearchResult(estimatedCount, rootContents, continuation);
    }

    private SearchResult parseSearchContinuation(SearchContinuation continuation, YoutubeCallback<SearchResult> callback, Client client) throws YoutubeException {
        JSONArray rootContents;
        JSONObject jsonResponse;
        String url = "https://www.youtube.com/youtubei/v1/search?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8&prettyPrint=false";
        JSONObject body = client.getBody().fluentPut("continuation", continuation.token()).fluentPut("clickTracking", new JSONObject().fluentPut("clickTrackingParams", continuation.clickTrackingParameters()));
        RequestWebpage request = (RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(url, "POST", body.toJSONString()).header("X-YouTube-Client-Name", "1")).header("X-YouTube-Client-Version", continuation.clientVersion())).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            jsonResponse = JSON.parseObject(html);
            if (!jsonResponse.containsKey("onResponseReceivedCommands")) {
                throw new YoutubeException.BadPageException("Could not find continuation data");
            }
            rootContents = jsonResponse.getJSONArray("onResponseReceivedCommands").getJSONObject(0).getJSONObject("appendContinuationItemsAction").getJSONArray("continuationItems");
        }
        catch (YoutubeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YoutubeException.BadPageException("Could not parse search continuation json");
        }
        long estimatedResults = this.extractor.extractLongFromText(jsonResponse.getString("estimatedResults"));
        SearchContinuation nextContinuation = this.getSearchContinuation(rootContents, continuation.clientVersion());
        return this.parseSearchResult(estimatedResults, rootContents, nextContinuation);
    }

    private SearchContinuation getSearchContinuation(JSONArray rootContents, String clientVersion) {
        if (rootContents.size() > 1 && rootContents.getJSONObject(1).containsKey("continuationItemRenderer")) {
            JSONObject endPoint = rootContents.getJSONObject(1).getJSONObject("continuationItemRenderer").getJSONObject("continuationEndpoint");
            String token = endPoint.getJSONObject("continuationCommand").getString("token");
            String ctp = endPoint.getString("clickTrackingParams");
            return new SearchContinuation(token, clientVersion, ctp);
        }
        return null;
    }

    private SearchResult parseSearchResult(long estimatedResults, JSONArray rootContents, SearchContinuation continuation) throws YoutubeException.BadPageException {
        JSONArray contents;
        try {
            contents = rootContents.getJSONObject(0).getJSONObject("itemSectionRenderer").getJSONArray("contents");
        }
        catch (NullPointerException e) {
            throw new YoutubeException.BadPageException("Search result contents not found");
        }
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>(contents.size());
        HashMap<QueryElementType, QueryElement> queryElements = new HashMap<QueryElementType, QueryElement>();
        for (int i = 0; i < contents.size(); ++i) {
            SearchResultElement element = ParserImpl.parseSearchResultElement(contents.getJSONObject(i));
            if (element == null) continue;
            if (element instanceof SearchResultItem) {
                items.add((SearchResultItem)element);
                continue;
            }
            QueryElement queryElement = (QueryElement)element;
            queryElements.put(queryElement.type(), queryElement);
        }
        if (continuation == null) {
            return new SearchResult(estimatedResults, items, queryElements);
        }
        return new ContinuatedSearchResult(estimatedResults, items, queryElements, continuation);
    }

    private static SearchResultElement parseSearchResultElement(JSONObject jsonItem) {
        String rendererKey = jsonItem.keySet().iterator().next();
        JSONObject jsonRenderer = jsonItem.getJSONObject(rendererKey);
        switch (rendererKey) {
            case "videoRenderer": {
                return new SearchResultVideoDetails(jsonRenderer, false);
            }
            case "movieRenderer": {
                return new SearchResultVideoDetails(jsonRenderer, true);
            }
            case "playlistRenderer": {
                return new SearchResultPlaylistDetails(jsonRenderer);
            }
            case "channelRenderer": {
                return new SearchResultChannelDetails(jsonRenderer);
            }
            case "shelfRenderer": {
                return new SearchResultShelf(jsonRenderer);
            }
            case "showingResultsForRenderer": {
                return new QueryAutoCorrection(jsonRenderer);
            }
            case "didYouMeanRenderer": {
                return new QuerySuggestion(jsonRenderer);
            }
            case "horizontalCardListRenderer": {
                return new QueryRefinementList(jsonRenderer);
            }
        }
        System.out.println("Unknown search result element type " + rendererKey);
        System.out.println(jsonItem);
        return null;
    }

    private static class DelegatedCipherFactory
    implements CipherFactory {
        Cipher lastCipher;
        final CipherFactory factory;

        DelegatedCipherFactory(CipherFactory factory) {
            this.factory = factory;
        }

        @Override
        public Cipher createCipher(String jsUrl) throws YoutubeException {
            if (jsUrl == null) {
                return this.lastCipher;
            }
            this.lastCipher = this.factory.createCipher(jsUrl);
            return this.lastCipher;
        }

        @Override
        public void addInitialFunctionPattern(int priority, String regex) {
            this.factory.addInitialFunctionPattern(priority, regex);
        }

        @Override
        public void addFunctionEquivalent(String regex, CipherFunction function) {
            this.factory.addFunctionEquivalent(regex, function);
        }

        Cipher getLastCipher() {
            return this.lastCipher;
        }

        void invalidateLastCipher() {
            this.lastCipher = null;
        }
    }
}

