/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.model.videos.formats;

import com.alibaba.fastjson.JSONObject;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.Format;
import org.watermedia.shaded.kiulian.downloader.model.videos.quality.VideoQuality;

public class VideoFormat
extends Format {
    private final int fps;
    private final String qualityLabel;
    private final Integer width;
    private final Integer height;
    private final VideoQuality videoQuality;

    public VideoFormat(JSONObject json, boolean isAdaptive, String clientVersion) {
        super(json, isAdaptive, clientVersion);
        this.fps = json.getInteger("fps");
        this.qualityLabel = json.getString("qualityLabel");
        if (json.containsKey("size")) {
            String[] split = json.getString("size").split("x");
            this.width = Integer.parseInt(split[0]);
            this.height = Integer.parseInt(split[1]);
        } else {
            this.width = json.getInteger("width");
            this.height = json.getInteger("height");
        }
        VideoQuality videoQuality = null;
        if (json.containsKey("quality")) {
            try {
                videoQuality = VideoQuality.valueOf(json.getString("quality"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.videoQuality = videoQuality;
    }

    @Override
    public String type() {
        return "video";
    }

    public int fps() {
        return this.fps;
    }

    public VideoQuality videoQuality() {
        return this.videoQuality != null ? this.videoQuality : this.itag.videoQuality();
    }

    public String qualityLabel() {
        return this.qualityLabel;
    }

    public Integer width() {
        return this.width;
    }

    public Integer height() {
        return this.height;
    }
}

