/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.downloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.watermedia.shaded.kiulian.downloader.Config;
import org.watermedia.shaded.kiulian.downloader.YoutubeException;
import org.watermedia.shaded.kiulian.downloader.downloader.Downloader;
import org.watermedia.shaded.kiulian.downloader.downloader.YoutubeCallback;
import org.watermedia.shaded.kiulian.downloader.downloader.YoutubeProgressCallback;
import org.watermedia.shaded.kiulian.downloader.downloader.request.Request;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoFileDownload;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoStreamDownload;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestWebpage;
import org.watermedia.shaded.kiulian.downloader.downloader.response.ResponseImpl;
import org.watermedia.shaded.kiulian.downloader.model.Utils;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.Format;

public class DownloaderImpl
implements Downloader {
    private static final int BUFFER_SIZE = 4096;
    private static final int PART_LENGTH = 0x200000;
    private final Config config;

    public DownloaderImpl(Config config) {
        this.config = config;
    }

    public ResponseImpl<String> downloadWebpage(RequestWebpage request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<String> result = executorService.submit(() -> this.download(request));
            return ResponseImpl.fromFuture(result);
        }
        try {
            String result = this.download(request);
            return ResponseImpl.from(result);
        }
        catch (IOException | YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String download(RequestWebpage request) throws IOException, YoutubeException {
        IOException exception;
        String downloadUrl = request.getDownloadUrl();
        Map<String, String> headers = request.getHeaders();
        YoutubeCallback callback = request.getCallback();
        int maxRetries = request.getMaxRetries() != null ? request.getMaxRetries().intValue() : this.config.getMaxRetries();
        Proxy proxy = request.getProxy();
        StringBuilder result = new StringBuilder();
        do {
            try {
                int responseCode;
                HttpURLConnection urlConnection = this.openConnection(downloadUrl, headers, proxy, this.config.isCompressionEnabled());
                urlConnection.setRequestMethod(request.getMethod());
                if (request.getBody() != null) {
                    urlConnection.setDoOutput(true);
                    try (OutputStreamWriter outputWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                        outputWriter.write(request.getBody());
                        outputWriter.flush();
                    }
                }
                if ((responseCode = urlConnection.getResponseCode()) != 200) {
                    YoutubeException.DownloadException e = new YoutubeException.DownloadException("Failed to download: HTTP " + responseCode);
                    if (callback != null) {
                        callback.onError(e);
                    }
                    throw e;
                }
                int contentLength = urlConnection.getContentLength();
                if (contentLength == 0) {
                    YoutubeException.DownloadException e = new YoutubeException.DownloadException("Failed to download: Response is empty");
                    if (callback != null) {
                        callback.onError(e);
                    }
                    throw e;
                }
                BufferedReader br = null;
                try {
                    String inputLine;
                    InputStream in = urlConnection.getInputStream();
                    if (this.config.isCompressionEnabled() && "gzip".equals(urlConnection.getHeaderField("content-encoding"))) {
                        in = new GZIPInputStream(in);
                    }
                    br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    while ((inputLine = br.readLine()) != null) {
                        result.append(inputLine).append('\n');
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeSilently(br);
                    throw throwable;
                }
                Utils.closeSilently(br);
                exception = null;
            }
            catch (IOException e) {
                exception = e;
                --maxRetries;
            }
        } while (exception != null && maxRetries > 0);
        if (exception != null) {
            if (callback != null) {
                callback.onError(exception);
            }
            throw exception;
        }
        String resultString = result.toString();
        if (callback != null) {
            callback.onFinished(resultString);
        }
        return resultString;
    }

    public ResponseImpl<File> downloadVideoAsFile(RequestVideoFileDownload request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<File> result = executorService.submit(() -> this.download(request));
            return ResponseImpl.fromFuture(result);
        }
        try {
            File result = this.download(request);
            return ResponseImpl.from(result);
        }
        catch (IOException e) {
            return ResponseImpl.error(e);
        }
    }

    public ResponseImpl<Void> downloadVideoAsStream(RequestVideoStreamDownload request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<Void> result = executorService.submit(() -> this.download(request));
            return ResponseImpl.fromFuture(result);
        }
        try {
            this.download(request);
            return ResponseImpl.from(null);
        }
        catch (IOException e) {
            return ResponseImpl.error(e);
        }
    }

    private File download(RequestVideoFileDownload request) throws IOException {
        Format format = request.getFormat();
        File outputFile = request.getOutputFile();
        YoutubeCallback callback = request.getCallback();
        FileOutputStream os = new FileOutputStream(outputFile);
        this.download(request, format, os);
        if (callback != null) {
            callback.onFinished(outputFile);
        }
        return outputFile;
    }

    private Void download(RequestVideoStreamDownload request) throws IOException {
        Format format = request.getFormat();
        YoutubeCallback callback = request.getCallback();
        OutputStream os = request.getOutputStream();
        this.download(request, format, os);
        if (callback != null) {
            callback.onFinished(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(Request<?, ?> request, Format format, OutputStream os) throws IOException {
        IOException exception;
        Map<String, String> headers = request.getHeaders();
        YoutubeCallback<?> callback = request.getCallback();
        int maxRetries = request.getMaxRetries() != null ? request.getMaxRetries().intValue() : this.config.getMaxRetries();
        Proxy proxy = request.getProxy();
        do {
            try {
                if (format.isAdaptive() && format.contentLength() != null) {
                    this.downloadByPart(format, os, headers, proxy, callback);
                } else {
                    this.downloadStraight(format, os, headers, proxy, callback);
                }
                exception = null;
            }
            catch (IOException e) {
                exception = e;
            }
            finally {
                Utils.closeSilently(os);
            }
        } while (exception != null && maxRetries > 0);
        if (exception != null) {
            if (callback != null) {
                callback.onError(exception);
            }
            throw exception;
        }
    }

    private void downloadStraight(Format format, OutputStream os, Map<String, String> headers, Proxy proxy, YoutubeCallback<?> callback) throws IOException {
        HttpURLConnection urlConnection = this.openConnection(format.url(), headers, proxy, false);
        int responseCode = urlConnection.getResponseCode();
        if (responseCode != 200) {
            throw new RuntimeException("Failed to download: HTTP " + responseCode);
        }
        int contentLength = urlConnection.getContentLength();
        InputStream is = urlConnection.getInputStream();
        byte[] buffer = new byte[4096];
        if (callback == null) {
            DownloaderImpl.copyAndCloseInput(is, os, buffer);
        } else {
            DownloaderImpl.copyAndCloseInput(is, os, buffer, 0L, contentLength, callback);
        }
    }

    private void downloadByPart(Format format, OutputStream os, Map<String, String> headers, Proxy proxy, YoutubeCallback<?> listener) throws IOException {
        long done = 0L;
        int partNumber = 0;
        String pathPrefix = "&cver=" + format.clientVersion() + "&range=";
        long contentLength = format.contentLength();
        byte[] buffer = new byte[4096];
        while (done < contentLength) {
            String partUrl;
            HttpURLConnection urlConnection;
            int responseCode;
            long toRead = 0x200000L;
            if (done + toRead > contentLength) {
                toRead = (int)(contentLength - done);
            }
            if ((responseCode = (urlConnection = this.openConnection(partUrl = format.url() + pathPrefix + done + "-" + (done + toRead - 1L) + "&rn=" + ++partNumber, headers, proxy, false)).getResponseCode()) != 200) {
                throw new RuntimeException("Failed to download: HTTP " + responseCode);
            }
            InputStream is = urlConnection.getInputStream();
            if (listener == null) {
                done += DownloaderImpl.copyAndCloseInput(is, os, buffer);
                continue;
            }
            done += DownloaderImpl.copyAndCloseInput(is, os, buffer, done, contentLength, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream is, OutputStream os, byte[] buffer, long offset, long totalLength, YoutubeCallback<?> listener) throws IOException {
        long done = 0L;
        try {
            long lastProgress;
            int read = 0;
            long l = lastProgress = offset == 0L ? 0L : offset * 100L / totalLength;
            while ((read = is.read(buffer)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException();
                }
                os.write(buffer, 0, read);
                long progress = (offset + (done += (long)read)) * 100L / totalLength;
                if (progress <= lastProgress) continue;
                if (listener instanceof YoutubeProgressCallback) {
                    ((YoutubeProgressCallback)listener).onDownloading((int)progress);
                }
                lastProgress = progress;
            }
        }
        finally {
            Utils.closeSilently(is);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        long done = 0L;
        try {
            int count = 0;
            while ((count = is.read(buffer)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException();
                }
                os.write(buffer, 0, count);
                done += (long)count;
            }
        }
        finally {
            Utils.closeSilently(is);
        }
        return done;
    }

    private HttpURLConnection openConnection(String httpUrl, Map<String, String> headers, Proxy proxy, boolean acceptCompression) throws IOException {
        URL url = new URL(httpUrl);
        HttpURLConnection urlConnection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection());
        for (Map.Entry<String, String> entry : this.config.getHeaders().entrySet()) {
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (acceptCompression) {
            urlConnection.setRequestProperty("Accept-Encoding", "gzip");
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return urlConnection;
    }
}

