/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.loaders;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import jdk.internal.loader.ClassLoaders;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import org.watermedia.WaterMedia;
import org.watermedia.core.exceptions.IllegalEnvironmentException;
import org.watermedia.core.exceptions.IllegalTLauncherException;
import org.watermedia.core.tools.Tool;
import org.watermedia.loaders.ILoader;

@Mod(value="watermedia")
public class NeoForgeLoader
implements ILoader {
    private static final Path tmpPath = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");

    public NeoForgeLoader() {
        try {
            if (this.tlcheck()) {
                throw new IllegalTLauncherException();
            }
            if (!this.clientSide()) {
                throw new IllegalEnvironmentException();
            }
            WaterMedia.prepare(this).start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed starting WATERMeDIA for " + this.name() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "NeoForge";
    }

    @Override
    public Path tempDir() {
        return tmpPath;
    }

    @Override
    public Path processDir() {
        return FMLLoader.getGamePath();
    }

    @Override
    public boolean tlcheck() {
        boolean isT = Tool.t();
        try {
            Class<?> launcher;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            if (!isT) {
                launcher = Class.forName("cpw.mods.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
            if (!isT) {
                launcher = Class.forName("cpw.mods.bootstraplauncher.BootstrapLauncher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
            try {
                if (!isT) {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    isT = Tool.t();
                    Thread.currentThread().setContextClassLoader(current);
                }
                if (!isT) {
                    Thread.currentThread().setContextClassLoader(ClassLoaders.appClassLoader());
                    isT = Tool.t();
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
            catch (Throwable launcher2) {
                // empty catch block
            }
            if (!isT) {
                Collection<StackTraceElement[]> traceElements = Thread.getAllStackTraces().values();
                block4: for (StackTraceElement[] elements : traceElements) {
                    for (StackTraceElement e : elements) {
                        if (!e.getClassName().startsWith("org.tlauncher")) continue;
                        isT = true;
                        continue block4;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isT;
    }

    @Override
    public boolean clientSide() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public boolean developerMode() {
        return FMLLoader.isProduction();
    }
}

