/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.core.tools;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class ArgTool
implements Supplier<String>,
BooleanSupplier,
IntSupplier,
DoubleSupplier {
    private final String key;
    private final String value;
    private String override;

    public ArgTool(String key) {
        this.key = key;
        this.value = System.getProperty(key);
    }

    public void override(String override) {
        this.override = override;
    }

    public String getKey() {
        return this.key;
    }

    public String argument() {
        return this.key;
    }

    @Override
    public String get() {
        return this.determinate();
    }

    public String value() {
        return this.determinate();
    }

    @Override
    public boolean getAsBoolean() {
        return Boolean.parseBoolean(this.determinate());
    }

    @Override
    public int getAsInt() {
        return Integer.parseInt(this.determinate());
    }

    @Override
    public double getAsDouble() {
        return Double.parseDouble(this.determinate());
    }

    public String toString() {
        return "D" + this.key + "=" + this.determinate();
    }

    private String determinate() {
        return this.override != null ? this.override : this.value;
    }
}

