/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.WaterMedia;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.network.patchs.twitch.StreamQuality;
import org.watermedia.shaded.kiulian.downloader.YoutubeDownloader;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.response.Response;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoDetails;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoInfo;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.AudioFormat;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.VideoFormat;

public class YoutubePatch
extends AbstractPatch {
    private static final YoutubeDownloader DOWNLOADER = new YoutubeDownloader();
    private static final Pattern PATTERN = Pattern.compile("(?:youtu\\.be/|youtube\\.com/(?:embed/|v/|shorts/|feeds/api/videos/|watch\\?v=|watch\\?.+&v=))([^/?&#]+)");

    @Override
    public String platform() {
        return "Youtube";
    }

    @Override
    public boolean isValid(URI uri) {
        return uri.getHost() != null && PATTERN.matcher(uri.toString()).find();
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality preferQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, preferQuality);
        Matcher matcher = PATTERN.matcher(uri.toString());
        if (matcher.find()) {
            try {
                String videoId = matcher.group(1);
                RequestVideoInfo request = new RequestVideoInfo(videoId);
                Response<VideoInfo> response = DOWNLOADER.getVideoInfo(request);
                VideoInfo videoInfo = response.data();
                if (videoInfo == null) {
                    throw new RuntimeException("Cannot fetch video info", response.error());
                }
                VideoDetails videoDetails = videoInfo.details();
                if (videoDetails.isLive()) {
                    String ytLivePlaylist = this.fetchLivePlaylist(videoDetails.liveUrl());
                    if (ytLivePlaylist != null) {
                        return new AbstractPatch.Result(new URI(StreamQuality.parse(ytLivePlaylist).get(0).getUrl()), true, true);
                    }
                } else if (WaterMedia.YES_SLAVISM.getAsBoolean()) {
                    VideoFormat bestVideo = videoInfo.bestVideoFormat();
                    AudioFormat bestAudio = videoInfo.bestAudioFormat();
                    if (bestVideo != null) {
                        return new AbstractPatch.Result(new URI(bestVideo.url()), true, false).setAudioTrack(new URI(bestAudio.url()));
                    }
                    if (bestAudio != null) {
                        return new AbstractPatch.Result(new URI(bestAudio.url()), true, false);
                    }
                } else {
                    VideoFormat bestAll = videoInfo.bestVideoWithAudioFormat();
                    if (bestAll != null) {
                        return new AbstractPatch.Result(new URI(bestAll.url()), true, false);
                    }
                    VideoFormat bestVideo = videoInfo.bestVideoFormat();
                    if (bestVideo != null) {
                        return new AbstractPatch.Result(new URI(bestVideo.url()), true, false);
                    }
                    AudioFormat bestAudio = videoInfo.bestAudioFormat();
                    if (bestAudio != null) {
                        return new AbstractPatch.Result(new URI(bestAudio.url()), true, false);
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new AbstractPatch.FixingURLException(uri.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private String fetchLivePlaylist(String url) throws IOException {
        int length;
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            return null;
        }
        InputStream inputStream = conn.getInputStream();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

