/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import me.srrapero720.waterframes.WFRegistry;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.entity.BigTvTile;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

@MethodsReturnNonnullByDefault
public class BigTvBlock
extends DisplayBlock {
    @Override
    public DirectionProperty getFacing() {
        return BlockStateProperties.f_61374_;
    }

    @Override
    public PermissionNode<Boolean> getPermissionNode() {
        return WFRegistry.PERM_DISPLAYS_INTERACT_TV;
    }

    public static AlignedBox box(Direction direction, Direction attachedFace, boolean renderMode) {
        float renderMargin;
        Facing facing = Facing.get((Direction)direction.m_122424_());
        AlignedBox box = new AlignedBox();
        float f = renderMargin = renderMode ? 1.0f : 0.0f;
        if (facing.positive) {
            box.setMax(facing.axis, 0.25f);
            box.setMin(facing.axis, 0.125f);
        } else {
            box.setMax(facing.axis, 0.875f);
            box.setMin(facing.axis, 0.75f);
        }
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        if (direction == attachedFace) {
            box.setMin(two, renderMargin / 16.0f);
            box.setMax(two, 1.875f - renderMargin / 16.0f);
        } else {
            box.setMin(two, (2.0f + renderMargin) / 16.0f);
            box.setMax(two, 2.0f - renderMargin / 16.0f);
        }
        box.setMin(one, (-14.0f + renderMargin) / 16.0f);
        box.setMax(one, (30.0f - renderMargin) / 16.0f);
        return box;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BigTvBlock.box((Direction)state.m_61143_((Property)this.getFacing()), (Direction)state.m_61143_((Property)ATTACHED_FACE), false).voxelShape();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction current = context.m_8125_();
        Player player = context.m_43723_();
        return (BlockState)super.m_5573_(context).m_61124_((Property)this.getFacing(), (Comparable)(player != null && player.m_6047_() ? current : current.m_122424_()));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BigTvTile(pos, state);
    }
}

