/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import java.util.function.Supplier;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.rendering.DisplayRenderer;
import me.srrapero720.waterframes.client.rendering.TextureWrapper;
import me.srrapero720.waterframes.common.block.BigTvBlock;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.FrameBlock;
import me.srrapero720.waterframes.common.block.ProjectorBlock;
import me.srrapero720.waterframes.common.block.TVBoxBlock;
import me.srrapero720.waterframes.common.block.TvBlock;
import me.srrapero720.waterframes.common.block.entity.BigTvTile;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.block.entity.FrameTile;
import me.srrapero720.waterframes.common.block.entity.ProjectorTile;
import me.srrapero720.waterframes.common.block.entity.TVBoxTile;
import me.srrapero720.waterframes.common.block.entity.TvTile;
import me.srrapero720.waterframes.common.commands.WaterFramesCommand;
import me.srrapero720.waterframes.common.item.RemoteControl;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.DataSyncPacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import me.srrapero720.waterframes.common.network.packets.VolumeRangePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.watermedia.WaterMedia;
import org.watermedia.api.image.ImageAPI;

@Mod.EventBusSubscriber(modid="waterframes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WFRegistry {
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"waterframes");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waterframes");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"waterframes");
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"waterframes");
    public static final RegistryObject<DisplayBlock> FRAME = BLOCKS.register("frame", FrameBlock::new);
    public static final RegistryObject<DisplayBlock> PROJECTOR = BLOCKS.register("projector", ProjectorBlock::new);
    public static final RegistryObject<DisplayBlock> TV = BLOCKS.register("tv", TvBlock::new);
    public static final RegistryObject<DisplayBlock> BIG_TV = BLOCKS.register("big_tv", BigTvBlock::new);
    public static final RegistryObject<DisplayBlock> TV_BOX = BLOCKS.register("tv_box", TVBoxBlock::new);
    public static final RegistryObject<Item> REMOTE_ITEM = ITEMS.register("remote", () -> new RemoteControl(WFRegistry.remoteProp()));
    public static final RegistryObject<Item> FRAME_ITEM = ITEMS.register("frame", () -> new BlockItem((Block)FRAME.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> PROJECTOR_ITEM = ITEMS.register("projector", () -> new BlockItem((Block)PROJECTOR.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> TV_ITEM = ITEMS.register("tv", () -> new BlockItem((Block)TV.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> BIG_TV_ITEM = ITEMS.register("big_tv", () -> new BlockItem((Block)BIG_TV.get(), WFRegistry.prop()));
    public static final RegistryObject<Item> TV_BOX_ITEM = ITEMS.register("tv_box", () -> new BlockItem((Block)TV_BOX.get(), WFRegistry.prop()));
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_FRAME = WFRegistry.tile("frame", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)FrameTile::new), FRAME);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_PROJECTOR = WFRegistry.tile("projector", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)ProjectorTile::new), PROJECTOR);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_TV = WFRegistry.tile("tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)TvTile::new), TV);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_BIG_TV = WFRegistry.tile("big_tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)BigTvTile::new), BIG_TV);
    public static final RegistryObject<BlockEntityType<DisplayTile>> TILE_TV_BOX = WFRegistry.tile("tv_box", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)TVBoxTile::new), TV_BOX);
    public static final RegistryObject<CreativeModeTab> WATERTAB = TABS.register("tab", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).m_257737_(() -> new ItemStack((ItemLike)FRAME.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.waterframes")).m_257652_());
    public static final PermissionNode<Boolean> PERM_DISPLAYS_EDIT = WFRegistry.permission("waterframes.displays.save", false, "Save changes on displays", "Allows saving whitelisted URLs");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT = WFRegistry.permission("waterframes.displays.interact", true, "Interact with displays", "Allows interact (open) the Gui of all displays");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT_FRAME = WFRegistry.permission("waterframes.displays.interact.frame", true, "Interact with frame display", "Allows interact (open) the Gui of frame display");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT_PROJECTOR = WFRegistry.permission("waterframes.displays.interact.projector", true, "Interact with frame display", "Allows interact (open) the Gui of projector display");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT_TV = WFRegistry.permission("waterframes.displays.interact.tv", true, "Interact with frame display", "Allows interact (open) the Gui of tv display");
    public static final PermissionNode<Boolean> PERM_REMOTE_INTERACT = WFRegistry.permission("waterframes.remote.interact", true, "Interact with remotes", "Allows interact (open) the Gui of remotes");
    public static final PermissionNode<Boolean> PERM_REMOTE_BIND = WFRegistry.permission("waterframes.remote.bind", true, "Bind remotes to displays", "Allows bind displays on remotes");
    public static final PermissionNode<Boolean> PERM_WHITELIST_BYPASS = WFRegistry.permission("waterframes.whitelist.bypass", false, "Bypass whitelisted URLS", "Allows to bypass whitelisted URLS");

    private static PermissionNode<Boolean> permission(String node, boolean def, String title, String desc) {
        return new PermissionNode("waterframes", node, PermissionTypes.BOOLEAN, (player, uuid, context) -> def, new PermissionDynamicContextKey[0]).setInformation((Component)Component.m_237113_((String)title), (Component)Component.m_237113_((String)desc));
    }

    public static boolean getPermBoolean(UUID player, PermissionNode<Boolean> node) {
        return (Boolean)PermissionAPI.getOfflinePermission((UUID)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    private static RegistryObject<BlockEntityType<DisplayTile>> tile(String name, BlockEntityType.BlockEntitySupplier<DisplayTile> creator, Supplier<DisplayBlock> block) {
        return TILES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)creator, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }

    private static Item.Properties remoteProp() {
        return new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE).setNoRepair().m_41486_();
    }

    private static Item.Properties prop() {
        return new Item.Properties().m_41487_(16).m_41497_(Rarity.RARE);
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TILES.register(bus);
        TABS.register(bus);
    }

    @SubscribeEvent
    public static void registerPermissions(PermissionGatherEvent.Nodes e) {
        e.addNodes(new PermissionNode[]{PERM_DISPLAYS_EDIT, PERM_DISPLAYS_INTERACT, PERM_DISPLAYS_INTERACT_FRAME, PERM_DISPLAYS_INTERACT_PROJECTOR, PERM_DISPLAYS_INTERACT_TV, PERM_REMOTE_BIND, PERM_REMOTE_INTERACT, PERM_WHITELIST_BYPASS});
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        WaterFramesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerCommands(RegisterClientCommandsEvent event) {
        WaterFramesCommand.registerClient((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerConnects(PlayerEvent.PlayerLoggedInEvent event) {
        String playername = event.getEntity().m_36316_().getName();
        if (playername.equals("Belupe_")) {
            event.getEntity().m_20194_().execute(() -> {
                throw new UnsupportedOperationException("Belupe_ is not allowed to use this mod");
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerTexture(ResourceLocation location, AbstractTexture texture) {
        Minecraft.m_91087_().m_91097_().m_118495_(location, texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void unregisterTexture(ResourceLocation location) {
        Minecraft.m_91087_().m_91097_().m_118513_(location);
    }

    public static class UnsupportedModException
    extends UnsupportedOperationException {
        private static final String MSG_REASON = "\u00c2\u00a7fMod \u00c2\u00a76'%s' \u00c2\u00a7fis not compatible with \u00c2\u00a7e'%s' \u00c2\u00a7fbecause \u00c2\u00a7c%s \u00c2\u00a7fplease remove it";

        public UnsupportedModException(String modid, String reason) {
            super(String.format(MSG_REASON, modid, "WATERFrAMES", reason));
        }
    }

    @Mod.EventBusSubscriber(modid="waterframes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onCreativeTabsLoading(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == WATERTAB.getKey()) {
                event.accept(REMOTE_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(FRAME_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(PROJECTOR_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(TV_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(BIG_TV_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(TV_BOX_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            DisplayNetwork.NET.registerType(DataSyncPacket.class, DataSyncPacket::new);
            DisplayNetwork.NET.registerType(ActivePacket.class, ActivePacket::new);
            DisplayNetwork.NET.registerType(LoopPacket.class, LoopPacket::new);
            DisplayNetwork.NET.registerType(MutePacket.class, MutePacket::new);
            DisplayNetwork.NET.registerType(PausePacket.class, PausePacket::new);
            DisplayNetwork.NET.registerType(TimePacket.class, TimePacket::new);
            DisplayNetwork.NET.registerType(VolumePacket.class, VolumePacket::new);
            DisplayNetwork.NET.registerType(VolumeRangePacket.class, VolumeRangePacket::new);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void init(FMLClientSetupEvent e) {
            WaterFrames.LOGGER.info(WaterMedia.IT, "Running WATERFrAMES v{}", (Object)ModList.get().getModFileById("waterframes").versionString());
            if (WaterFrames.isInstalled("mr_stellarity", "stellarity") && !WFConfig.isDevMode()) {
                throw new UnsupportedModException("mr_stellarity (Stellarity)", "breaks picture rendering, overwrites Minecraft core shaders and isn't possible work around that");
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerOtherStuff(FMLClientSetupEvent e) {
            WFRegistry.registerTexture(WaterFrames.LOADING_ANIMATION, new TextureWrapper.Renderer(ImageAPI.loadingGif((String)"waterframes")));
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerTileRenderer(EntityRenderersEvent.RegisterRenderers e) {
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_FRAME.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_PROJECTOR.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_TV.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_BIG_TV.get()), DisplayRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TILE_TV_BOX.get()), DisplayRenderer::new);
        }
    }
}

