/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.watercollector.entity;

import com.leclowndu93150.watercollector.config.ModConfigCommon;
import com.leclowndu93150.watercollector.entity.ModBlockEntities;
import com.leclowndu93150.watercollector.network.ModMessages;
import com.leclowndu93150.watercollector.network.packets.FluidStackSyncS2CPacket;
import java.util.Random;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WatercollectorBlockEntity
extends BlockEntity {
    private static final RandomGenerator sharedRandom = new Random();
    private static Fluid fluidOutput = null;
    private static long lastCycleTime = -1L;
    private static int cycleCounter = 0;
    private static boolean resetCycle = false;
    private CompoundTag updateTag;
    private final FluidTank fluidTankHandler = this.createFluidTank();
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();

    public WatercollectorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.WATERCOLLECTOR_ENTITY.get(), pWorldPosition, pBlockState);
        this.updateTag = this.getPersistentData();
    }

    public static void verifyConfig(Logger logger) {
        if (fluidOutput == null) {
            String fluidResourceRaw = "minecraft:water";
            ResourceLocation desiredFluid = new ResourceLocation("minecraft:water");
            if (ForgeRegistries.FLUIDS.containsKey(desiredFluid)) {
                fluidOutput = (Fluid)ForgeRegistries.FLUIDS.getValue(desiredFluid);
            } else {
                logger.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)"minecraft:water", (Object)"minecraft:water");
                fluidOutput = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("minecraft:water"));
            }
        }
    }

    private FluidTank createFluidTank() {
        return new FluidTank((Integer)ModConfigCommon.COLLECTOR_CAPACITY.get(), fluid -> fluid.getFluid().m_6212_(fluidOutput)){

            protected void onContentsChanged() {
                WatercollectorBlockEntity.this.m_6596_();
                assert (WatercollectorBlockEntity.this.f_58857_ != null);
                if (!WatercollectorBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToClients(new FluidStackSyncS2CPacket(this.fluid, WatercollectorBlockEntity.this.f_58858_));
                }
            }
        };
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public FluidStack getFluidStack() {
        if (!this.fluidTankHandler.isEmpty()) {
            return this.fluidTankHandler.getFluid();
        }
        return new FluidStack(fluidOutput, 1);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidHandler = LazyOptional.of(() -> this.fluidTankHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        this.fluidTankHandler.writeToNBT(nbt);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidTankHandler.readFromNBT(nbt);
        if (!this.fluidTankHandler.getFluid().getFluid().m_6212_(fluidOutput)) {
            FluidStack changedFluidStack = new FluidStack(fluidOutput, this.fluidTankHandler.getFluid().getAmount());
            this.fluidTankHandler.setFluid(changedFluidStack);
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, WatercollectorBlockEntity pBlockEntity) {
        if (pLevel.m_5776_()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pPos.m_121945_(direction);
            BlockEntity blockEntity = pLevel.m_7702_(offsetPos);
            if (blockEntity == null) continue;
            LazyOptional FluidTank2 = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_());
            FluidTank2.ifPresent(tank -> {
                if (tank.getTankCapacity(0) != tank.getFluidInTank(0).getAmount() && pBlockEntity.fluidTankHandler.getFluidAmount() >= (Integer)ModConfigCommon.COLLECTOR_MB_PER_CYCLE.get() && tank.isFluidValid(0, new FluidStack((Fluid)Fluids.f_76193_, ((Integer)ModConfigCommon.COLLECTOR_MB_PER_CYCLE.get()).intValue())) && (tank.getFluidInTank(0).equals((Object)new FluidStack((Fluid)Fluids.f_76193_, 1)) || tank.getFluidInTank(0).isEmpty())) {
                    tank.fill(new FluidStack((Fluid)Fluids.f_76193_, ((Integer)ModConfigCommon.COLLECTOR_MB_PER_CYCLE.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
                    pBlockEntity.fluidTankHandler.drain(((Integer)ModConfigCommon.COLLECTOR_MB_PER_CYCLE.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
        long timeNow = pLevel.m_46468_();
        if (timeNow != lastCycleTime) {
            lastCycleTime = timeNow;
            if (resetCycle) {
                resetCycle = false;
                cycleCounter = 0;
            }
            ++cycleCounter;
        }
        if (cycleCounter >= (Integer)ModConfigCommon.COLLECTOR_TICKS_PER_CYCLE.get()) {
            resetCycle = true;
            float amountMultiMin = ((Float)ModConfigCommon.COLLECTOR_MB_MULTI_MIN.get()).floatValue();
            int amount = (Integer)ModConfigCommon.COLLECTOR_MB_PER_CYCLE.get();
            if (amountMultiMin < 1.0f) {
                float randomMultiplier = amountMultiMin + sharedRandom.nextFloat() * (((Float)ModConfigCommon.COLLECTOR_MB_MULTI_MAX.get()).floatValue() - amountMultiMin);
                amount = Math.round((float)((Integer)ModConfigCommon.COLLECTOR_MB_PER_CYCLE.get()).intValue() * randomMultiplier);
            }
            pBlockEntity.fluidTankHandler.fill(new FluidStack(fluidOutput, amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidTankHandler;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidTankHandler.setFluid(fluidStack);
    }

    public boolean consumeWaterBottle() {
        int consumption = (Integer)ModConfigCommon.COLLECTOR_BOTTLE_MB_CONSUMPTION.get();
        if (consumption > this.fluidTankHandler.getFluidAmount()) {
            return false;
        }
        this.fluidTankHandler.drain(consumption, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

