/*
 * Decompiled with CFR 0.152.
 */
package trofers.loot;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import trofers.platform.PlatformServices;

public abstract class AbstractLootModifier {
    public final LootItemCondition[] conditions;
    private final Predicate<LootContext> combinedConditions;

    protected static <T extends AbstractLootModifier> Products.P1<RecordCodecBuilder.Mu<T>, LootItemCondition[]> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)PlatformServices.platformHelper.getLootConditionsCodec().fieldOf("conditions").forGetter(modifier -> modifier.conditions));
    }

    protected AbstractLootModifier(LootItemCondition[] conditionsIn) {
        this.conditions = conditionsIn;
        this.combinedConditions = LootItemConditions.m_81834_((Predicate[])conditionsIn);
    }

    public final ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return this.combinedConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    protected abstract ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> var1, LootContext var2);

    public abstract Codec<? extends AbstractLootModifier> codec();
}

