/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.compat.mekanism;

import chiefarug.mods.systeams.Systeams;
import chiefarug.mods.systeams.SysteamsRegistry;
import cofh.lib.common.fluid.FluidStorageCoFH;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.common.registries.MekanismGases;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SysteamsMekanismCompat {
    public static void activateMechanisedManifold(IEventBus bus) {
        bus.addListener(event -> {
            LiquidToGasHandler.fluidConversions.put((Object)Fluids.f_76191_, (Object)MekanismAPI.EMPTY_GAS);
            LiquidToGasHandler.fluidConversions.put((Object)SysteamsRegistry.Fluids.STEAM.getStill(), (Object)((Gas)MekanismGases.STEAM.get()));
        });
    }

    public static LazyOptional<IGasHandler> wrapLiquidCapability(LazyOptional<IFluidHandler> fluidHandler) {
        if (fluidHandler.isPresent()) {
            LazyOptional lazyOp = LazyOptional.of(() -> new LiquidToGasHandler((IFluidHandler)fluidHandler.resolve().get()));
            fluidHandler.addListener(f -> lazyOp.invalidate());
            return lazyOp;
        }
        return LazyOptional.empty();
    }

    static class LiquidToGasHandler
    implements IGasHandler {
        public static final BiMap<Fluid, Gas> fluidConversions = HashBiMap.create();
        private final IFluidHandler fluidHandler;

        public LiquidToGasHandler(IFluidHandler fluidHandler) {
            this.fluidHandler = fluidHandler;
        }

        public static FluidStack gasToFluid(GasStack gas) {
            if (gas.isEmpty()) {
                return FluidStack.EMPTY;
            }
            Fluid fluid = (Fluid)fluidConversions.inverse().get((Object)gas.getType());
            if (fluid == null) {
                return FluidStack.EMPTY;
            }
            if (gas.getAmount() > Integer.MAX_VALUE) {
                Systeams.LGGR.error("Systeams converted a massive amount of gas {} to fluid {}. {}mb has been voided!", new Object[]{gas.getTypeRegistryName(), ForgeRegistries.FLUIDS.getKey((Object)fluid), gas.getAmount() - Integer.MAX_VALUE});
            }
            return new FluidStack(fluid, (int)gas.getAmount());
        }

        public static Pair<FluidStack, Long> gasToFluidWithOverflow(GasStack gas) {
            if (gas.isEmpty()) {
                return Pair.of((Object)FluidStack.EMPTY, (Object)0L);
            }
            Fluid fluid = (Fluid)fluidConversions.inverse().get((Object)gas.getType());
            if (fluid == null) {
                return Pair.of((Object)FluidStack.EMPTY, (Object)gas.getAmount());
            }
            if (gas.getAmount() > Integer.MAX_VALUE) {
                return Pair.of((Object)new FluidStack(fluid, (int)gas.getAmount()), (Object)(gas.getAmount() - Integer.MAX_VALUE));
            }
            return Pair.of((Object)new FluidStack(fluid, (int)gas.getAmount()), (Object)0L);
        }

        public static GasStack fluidToGas(FluidStack fluid) {
            if (fluid.isEmpty()) {
                return GasStack.EMPTY;
            }
            Gas gas = (Gas)fluidConversions.get((Object)fluid.getFluid());
            if (gas == null) {
                return GasStack.EMPTY;
            }
            return gas.getStack((long)fluid.getAmount());
        }

        public int getTanks() {
            return this.fluidHandler.getTanks();
        }

        @NotNull
        public GasStack getChemicalInTank(int tank) {
            return LiquidToGasHandler.fluidToGas(this.fluidHandler.getFluidInTank(tank));
        }

        public void setChemicalInTank(int tank, @NotNull GasStack gas) {
            IFluidHandler iFluidHandler = this.fluidHandler;
            if (iFluidHandler instanceof FluidStorageCoFH) {
                FluidStorageCoFH storage = (FluidStorageCoFH)iFluidHandler;
                storage.setFluidStack(LiquidToGasHandler.gasToFluid(gas));
            } else {
                this.fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                this.fluidHandler.fill(LiquidToGasHandler.gasToFluid(gas), IFluidHandler.FluidAction.EXECUTE);
            }
        }

        public long getTankCapacity(int tank) {
            return this.fluidHandler.getTankCapacity(tank);
        }

        public boolean isValid(int tank, @NotNull GasStack stack) {
            return this.fluidHandler.isFluidValid(tank, LiquidToGasHandler.gasToFluid(stack));
        }

        @NotNull
        public GasStack insertChemical(int tank, @NotNull GasStack stack, Action action) {
            Pair<FluidStack, Long> fluid = LiquidToGasHandler.gasToFluidWithOverflow(stack);
            int amountFilled = this.fluidHandler.fill((FluidStack)fluid.getFirst(), action.toFluidAction());
            if ((Long)fluid.getSecond() == 0L && amountFilled == ((FluidStack)fluid.getFirst()).getAmount()) {
                return GasStack.EMPTY;
            }
            stack = stack.copy();
            stack.setAmount((Long)fluid.getSecond() + (long)(((FluidStack)fluid.getFirst()).getAmount() - amountFilled));
            return stack;
        }

        @NotNull
        public GasStack extractChemical(int tank, long amount, Action action) {
            return LiquidToGasHandler.fluidToGas(this.fluidHandler.drain((int)amount, action.toFluidAction()));
        }
    }
}

