/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.ConversionKitItem;
import chiefarug.mods.systeams.SysteamsConfig;
import chiefarug.mods.systeams.SysteamsRegistry;
import chiefarug.mods.systeams.compat.mekanism.SysteamsMekanismCompat;
import chiefarug.mods.systeams.compat.pneumaticcraft.SysteamsPNCRCompat;
import chiefarug.mods.systeams.compat.thermal_extra.SysteamsThermalExtraCompat;
import cofh.core.client.event.CoreClientEvents;
import cofh.core.util.helpers.AugmentDataHelper;
import com.mojang.logging.LogUtils;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="systeams")
@Mod.EventBusSubscriber(modid="systeams")
public class Systeams {
    public static final Logger LGGR = LogUtils.getLogger();
    public static final String MODID = "systeams";
    public static final ResourceLocation MODRL = new ResourceLocation("systeams", "systeams");
    public static final String PNCR = "pneumaticcraft";
    public static final String MEKANISM = "mekanism";
    public static final String EXTRA = "thermal_extra";
    public static final Capability<IAirHandlerMachine> AIR_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAirHandlerMachine>(){});
    public static final Capability<IGasHandler> GAS_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGasHandler>(){});
    private static boolean first = true;

    public Systeams() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SysteamsRegistry.init(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SysteamsConfig.spec, "systeams-server.toml");
        bus.addListener(event -> event.enqueueWork(ConversionKitItem::fillDynamoMap));
        bus.addListener(event -> event.enqueueWork(() -> CoreClientEvents.addNamespace((String)MODID)));
        ModList mods = ModList.get();
        if (mods.isLoaded(PNCR)) {
            SysteamsPNCRCompat.unfoldPressurizedManifold(bus);
        }
        if (mods.isLoaded(MEKANISM)) {
            SysteamsMekanismCompat.activateMechanisedManifold(bus);
        }
        if (mods.isLoaded(EXTRA)) {
            SysteamsThermalExtraCompat.initializeExtraThermalization(bus);
        }
    }

    @Nullable
    @Contract(value="null,null -> null;!null,_ -> new;_,!null -> new")
    public static CompoundTag mergeTags(@Nullable CompoundTag first, @Nullable CompoundTag second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second.m_6426_();
        }
        if (second == null) {
            return first.m_6426_();
        }
        return first.m_6426_().m_128391_(second);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void loginLogger(PlayerEvent.PlayerLoggedInEvent _e) {
        if (first) {
            LGGR.info("Welcome aboard Captain. All Systeams online");
            first = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void supplementAugmentTooltips(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty() || !((Boolean)SysteamsConfig.REPLACE_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String augType = AugmentDataHelper.getAugmentType((ItemStack)stack);
        if (augType.equals("Dynamo")) {
            Systeams.replaceContents(tooltip);
        }
    }

    private static boolean replaceContents(List<Component> components) {
        for (int i = 0; i < components.size(); ++i) {
            TranslatableContents translatableContents;
            Component component = components.get(i);
            ComponentContents componentContents = component.m_214077_();
            if (componentContents instanceof TranslatableContents && (translatableContents = (TranslatableContents)componentContents).m_237508_().equals("info.thermal.augment.type.Dynamo")) {
                MutableComponent replacement = Component.m_237110_((String)"info.systeams.augment.type.DynamoBoiler", (Object[])translatableContents.m_237523_()).m_130948_(component.m_7383_());
                component.m_7360_().forEach(arg_0 -> ((MutableComponent)replacement).m_7220_(arg_0));
                components.set(i, (Component)replacement);
                return true;
            }
            if (!Systeams.replaceContents(component.m_7360_())) continue;
            return true;
        }
        return false;
    }
}

