/*
 * Decompiled with CFR 0.152.
 */
package dev.joshument.steamdynamo;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="steamdynamo", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue WATER_CONSUMPTION_AMOUNT = BUILDER.comment("The amount of water consumed per operation.").defineInRange("waterConsumptionAmount", 100, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue WATER_RF_PRODUCTION_AMOUNT = BUILDER.comment("The amount of RF that one consumption cycle of water provides.").defineInRange("waterRFConsumptionAmount", 50000, 0, Integer.MAX_VALUE);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int waterConsumptionAmount;
    public static int waterRFConsumptionAmount;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        waterConsumptionAmount = (Integer)WATER_CONSUMPTION_AMOUNT.get();
        waterRFConsumptionAmount = (Integer)WATER_RF_PRODUCTION_AMOUNT.get();
    }
}

