/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.jsonc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncElement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class JsoncObject
implements JsoncElement {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(^ *//.*$)|(/\\*(\\*(?!/)|[^*])*\\*/)", 8);
    private String comment = "";
    private final Map<String, JsoncElement> elements = new LinkedHashMap<String, JsoncElement>();

    public JsoncObject add(String key, JsoncElement element) {
        this.elements.put(key, element);
        return this;
    }

    public JsoncObject remove(String key) {
        this.elements.remove(key);
        return this;
    }

    @Override
    public String toString(int indentation) {
        if (this.elements.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{\n");
        for (Map.Entry<String, JsoncElement> entry : this.elements.entrySet()) {
            JsoncElement.writeComment(builder, entry.getValue(), indentation + 1);
            builder.append(INDENT.repeat(indentation + 1));
            builder.append("\"").append(entry.getKey()).append("\": ");
            builder.append(entry.getValue().toString(indentation + 1));
            builder.append(",\n");
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append(INDENT.repeat(indentation)).append("}");
        return builder.toString();
    }

    @Override
    public void comment(String comment) {
        this.comment = comment;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public String toString() {
        return this.toString(0);
    }

    public static JsonObject parse(String json) {
        json = COMMENT_PATTERN.matcher(json).replaceAll("");
        return (JsonObject)GSON.fromJson(json, JsonObject.class);
    }
}

