/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.utils;

import com.oe.rehooked.item.hook.HookItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CurioUtils {
    public static <T extends ICurioItem> Optional<List<ItemStack>> GetCuriosOfType(Class<T> clazz, LivingEntity entity) {
        LazyOptional optInventory = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!optInventory.isPresent()) {
            return Optional.empty();
        }
        return optInventory.resolve().flatMap(inventory -> inventory.getStacksHandler("hook").map(slot -> {
            ArrayList<ItemStack> retList = new ArrayList<ItemStack>();
            for (int i = 0; i < slot.getSlots(); ++i) {
                ItemStack stack = slot.getStacks().getStackInSlot(i);
                if (!clazz.isAssignableFrom(stack.m_41720_().getClass())) continue;
                retList.add(stack);
            }
            return retList;
        }));
    }

    public static <T> Optional<T> GetIfUnique(List<T> lst) {
        if (lst.size() == 1) {
            return Optional.of(lst.get(0));
        }
        return Optional.empty();
    }

    public static Optional<String> GetHookType(Player owner) {
        return CurioUtils.GetCuriosOfType(HookItem.class, (LivingEntity)owner).flatMap(CurioUtils::GetIfUnique).map(ItemStack::m_41720_).map(item -> ((HookItem)((Object)item)).getHookType());
    }
}

