/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.item.hook;

import com.oe.rehooked.client.KeyBindings;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.utils.HandlerHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class HookItem
extends Item
implements ICurioItem {
    private final String hookType;

    public HookItem(String hookType) {
        this(new Item.Properties().m_41499_(0).m_41487_(1), hookType);
    }

    public HookItem(Item.Properties properties, String hookType) {
        super(properties);
        this.hookType = hookType;
    }

    public String getHookType() {
        return this.hookType;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (!(pStack.m_41720_() instanceof HookItem)) {
            return;
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)("tooltip.rehooked:" + this.hookType + "_hook.info")));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.rehooked.press_fire", (Object[])new Object[]{KeyBindings.getCombinedKeyName(KeyBindings.FIRE_HOOK_KEY)}));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.rehooked.press_retract", (Object[])new Object[]{KeyBindings.getCombinedKeyName(KeyBindings.RETRACT_HOOK_KEY)}));
            HookRegistry.getHookData(this.hookType).ifPresent(hookData -> {
                if (!hookData.isCreative()) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.rehooked.press_retract_all", (Object[])new Object[]{KeyBindings.getCombinedKeyName(KeyBindings.REMOVE_ALL_HOOKS_KEY)}));
                }
            });
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.rehooked.press_shift_more_info").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player owner = (Player)livingEntity;
        HandlerHelper.getHookHandler(owner).ifPresent(ICommonPlayerHookHandler::onUnequip);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player owner = (Player)livingEntity;
        HandlerHelper.getHookHandler(owner).ifPresent(ICommonPlayerHookHandler::onEquip);
    }
}

