/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.def;

import com.oe.rehooked.data.HookData;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface ICommonPlayerHookHandler {
    public static final double THRESHOLD = 0.2;

    public void addHook(int var1);

    public void addHook(HookEntity var1);

    public void removeHook(int var1);

    public void removeHook(HookEntity var1);

    public void removeAllHooks();

    public void shootFromRotation(float var1, float var2);

    public ICommonPlayerHookHandler setOwner(Player var1);

    public Optional<? extends Player> getOwner();

    default public Optional<HookData> getHookData() {
        return this.getOwner().flatMap(CurioUtils::GetHookType).flatMap(HookRegistry::getHookData);
    }

    default public void afterDeath() {
    }

    public void update();

    public boolean shouldMoveThisTick();

    public Vec3 getDeltaVThisTick();

    default public int countPulling() {
        int count = 0;
        for (HookEntity hookEntity : this.getHooks()) {
            if (!hookEntity.getState().equals((Object)HookEntity.State.PULLING)) continue;
            ++count;
        }
        return count;
    }

    public Collection<HookEntity> getHooks();

    default public Vec3 getPullCenter() {
        double pulling = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (HookEntity hookEntity : this.getHooks()) {
            if (!hookEntity.getState().equals((Object)HookEntity.State.PULLING) || !hookEntity.getHitPos().isPresent()) continue;
            pulling += 1.0;
            Vec3 hit = hookEntity.m_20182_();
            x += hit.f_82479_;
            y += hit.f_82480_;
            z += hit.f_82481_;
        }
        return new Vec3(x / pulling, y / pulling, z / pulling);
    }

    default public VectorHelper.Box getBox() {
        VectorHelper.Box box = new VectorHelper.Box();
        for (HookEntity hookEntity : this.getHooks()) {
            if (!hookEntity.getState().equals((Object)HookEntity.State.PULLING)) continue;
            box.reassignPoints(hookEntity.m_20182_());
        }
        return box;
    }

    default public Vec3 reduceCollisions(Vec3 moveVector) {
        return this.reduceCollisions(moveVector.f_82479_, moveVector.f_82480_, moveVector.f_82481_);
    }

    default public Vec3 reduceCollisions(double dX, double dY, double dZ) {
        return this.getOwner().map(owner -> {
            double x = dX;
            double y = dY;
            double z = dZ;
            Vec3 ownerWaistPosition = PositionHelper.getWaistPosition((Entity)owner);
            BlockHitResult hitResult = VectorHelper.getFromEntityAndAngle((Entity)owner, new Vec3(1.0, 0.0, 0.0), x, PositionHelper::getWaistPosition);
            if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK) && !owner.m_9236_().m_8055_(hitResult.m_82425_()).m_60795_() && Math.abs(x = hitResult.m_82450_().m_82554_(ownerWaistPosition) * Math.signum(x)) <= 1.0) {
                x = 0.0;
            }
            if ((hitResult = VectorHelper.getFromEntityAndAngle((Entity)owner, new Vec3(0.0, 1.0, 0.0), y, PositionHelper::getWaistPosition)).m_6662_().equals((Object)HitResult.Type.BLOCK) && !owner.m_9236_().m_8055_(hitResult.m_82425_()).m_60795_() && Math.abs(y = hitResult.m_82450_().m_82554_(ownerWaistPosition) * Math.signum(y)) <= 1.5) {
                y = 0.0;
            }
            if ((hitResult = VectorHelper.getFromEntityAndAngle((Entity)owner, new Vec3(0.0, 0.0, 1.0), z, PositionHelper::getWaistPosition)).m_6662_().equals((Object)HitResult.Type.BLOCK) && !owner.m_9236_().m_8055_(hitResult.m_82425_()).m_60795_() && Math.abs(z = hitResult.m_82450_().m_82554_(ownerWaistPosition) * Math.signum(z)) <= 1.0) {
                z = 0.0;
            }
            return new Vec3(x, y, z);
        }).orElse(null);
    }

    default public void onUnequip() {
        this.removeAllHooks();
        this.update();
    }

    default public void onEquip() {
        this.removeAllHooks();
        this.update();
    }

    default public void jump() {
        this.getOwner().ifPresent(owner -> {
            this.setMomentum(this.getJumpVector());
            this.removeAllHooks();
        });
    }

    public void setDeltaVThisTick(Vec3 var1);

    default public Vec3 getJumpVector() {
        return this.getHookData().map(hookData -> {
            if (this.countPulling() > 0 && this.shouldMoveThisTick()) {
                Vec3 dVT = this.actualPlayerPositionChange();
                if (dVT.f_82480_ < 0.75) {
                    dVT = new Vec3(dVT.f_82479_, 0.75, dVT.f_82481_);
                }
                return this.reduceCollisions(dVT);
            }
            return Vec3.f_82478_;
        }).orElse(Vec3.f_82478_);
    }

    public Vec3 getMomentum();

    public void setMomentum(Vec3 var1);

    default public void updateMomentum() {
        if (this.getMomentum() == null) {
            return;
        }
        if (this.getMomentum().m_165924_() < 0.2 && this.getMomentum().f_82480_ < 0.2 || this.countPulling() > 0) {
            this.setMomentum(null);
            return;
        }
        this.getOwner().ifPresent(owner -> {
            boolean moreFriction;
            if (owner.m_150110_().f_35935_) {
                this.setMomentum(null);
                return;
            }
            double horizontalScale = 0.95;
            double verticalScale = 0.9;
            boolean bl = moreFriction = owner.m_20096_() || owner.m_20069_();
            if (moreFriction) {
                horizontalScale = 0.75;
                verticalScale = 0.75;
            }
            Vec3 actualMomentum = this.reduceCollisions(this.getMomentum());
            this.setDeltaVThisTick(actualMomentum);
            actualMomentum = actualMomentum.m_82542_(horizontalScale, verticalScale, horizontalScale);
            if (!moreFriction && !owner.m_150110_().f_35935_) {
                actualMomentum = actualMomentum.m_82492_(0.0, 0.08, 0.0);
            }
            this.setMomentum(actualMomentum);
        });
    }

    public Optional<Vec3> getLastPlayerPosition();

    default public Vec3 actualPlayerPositionChange() {
        return this.getOwner().map(Entity::m_20182_).flatMap(currPos -> this.getLastPlayerPosition().map(lastPos -> lastPos.m_82505_(currPos))).orElse(Vec3.f_82478_);
    }

    public void storeLastPlayerPosition();

    public void killHook(int var1);
}

