/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.redstoneclock.common.menu;

import com.hexagram2021.redstoneclock.common.register.RCMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;

public class RedstoneClockMenu
extends AbstractContainerMenu {
    private final Container redstoneClockContainer;
    public final ContainerData redstoneClock;
    public int multiplier = 0;

    @Contract(pure=true)
    public static int toMultiplier(int log) {
        return switch (log) {
            case 1 -> 20;
            case 2 -> 200;
            case 3 -> 2000;
            case 4 -> 20000;
            default -> 2;
        };
    }

    public RedstoneClockMenu(int id) {
        this(id, (Container)new SimpleContainer(0), (ContainerData)new SimpleContainerData(4));
    }

    public RedstoneClockMenu(int id, Container container, ContainerData containerData) {
        super((MenuType)RCMenuTypes.REDSTONE_CLOCK.get(), id);
        RedstoneClockMenu.m_38869_((Container)container, (int)0);
        RedstoneClockMenu.m_38886_((ContainerData)containerData, (int)4);
        this.redstoneClockContainer = container;
        this.redstoneClock = containerData;
        this.m_38884_(containerData);
    }

    public boolean m_6366_(Player player, int id) {
        switch (id) {
            case 0: {
                this.m_7511_(0, Math.min(15, this.redstoneClock.m_6413_(0) + 1));
                break;
            }
            case 1: {
                this.m_7511_(0, Math.max(1, this.redstoneClock.m_6413_(0) - 1));
                break;
            }
            case 2: {
                this.m_7511_(1, Math.min(24000, this.redstoneClock.m_6413_(1) + RedstoneClockMenu.toMultiplier(this.multiplier)));
                break;
            }
            case 3: {
                this.m_7511_(1, Math.max(2, this.redstoneClock.m_6413_(1) - RedstoneClockMenu.toMultiplier(this.multiplier)));
                break;
            }
            case 4: {
                this.m_7511_(2, Math.min(24000, this.redstoneClock.m_6413_(2) + RedstoneClockMenu.toMultiplier(this.multiplier)));
                break;
            }
            case 5: {
                this.m_7511_(2, Math.max(2, this.redstoneClock.m_6413_(2) - RedstoneClockMenu.toMultiplier(this.multiplier)));
                break;
            }
            case 6: {
                this.setNextMultiplier();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setNextMultiplier() {
        this.multiplier = (this.multiplier + 1) % 5;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public void m_7511_(int index, int value) {
        super.m_7511_(index, value);
        this.m_38946_();
    }

    public boolean m_6875_(Player player) {
        return this.redstoneClockContainer.m_6542_(player);
    }
}

