/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.item;

import cofh.core.common.capability.CapabilityArchery;
import cofh.core.common.capability.templates.ArcheryAmmoItemWrapper;
import cofh.core.common.capability.templates.ArcheryBowItemWrapper;
import cofh.core.common.config.CoreClientConfig;
import cofh.core.common.item.BowItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.api.capability.IArcheryAmmoItem;
import cofh.lib.api.capability.IArcheryBowItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.common.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.common.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxBowItem
extends BowItemCoFH
implements IMultiModeFluxItem {
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxBowItem(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier, Item.Properties builder, int energy, int xfer) {
        super(builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.setParams(enchantability, accuracyModifier, damageModifier, velocityModifier);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("pull"), this::getPullModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxBowItemWrapper(stack, this);
    }

    public float getPullModelProperty(ItemStack stack, Level world, LivingEntity entity, int seed) {
        if (entity == null || !entity.m_21211_().equals(stack)) {
            return 0.0f;
        }
        return MathHelper.clamp((float)((float)entity.m_21252_() / 20.0f), (float)0.0f, (float)1.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasEnergy(stack, this.isEmpowered(stack))) {
            return super.m_7203_(world, player, hand);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142522_(stack);
    }

    @Override
    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142159_(stack);
    }

    @Override
    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142158_(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxBowItemWrapper
    extends EnergyContainerItemWrapper
    implements IArcheryBowItem {
        private final LazyOptional<IArcheryBowItem> holder;
        private final float accuracyModifier;
        private final float damageModifier;
        private final float velocityModifier;
        protected final int simulateTicks = 100;
        final ItemStack bowItem;

        FluxBowItemWrapper(ItemStack bowItemContainer, FluxBowItem item) {
            super(bowItemContainer, (IEnergyContainerItem)item, item.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
            this.simulateTicks = 100;
            this.bowItem = bowItemContainer;
            this.accuracyModifier = MathHelper.clamp((float)item.accuracyModifier, (float)0.1f, (float)10.0f);
            this.damageModifier = MathHelper.clamp((float)item.damageModifier, (float)0.1f, (float)10.0f);
            this.velocityModifier = MathHelper.clamp((float)item.velocityModifier, (float)0.1f, (float)10.0f);
        }

        public float getAccuracyModifier(Player shooter) {
            return this.accuracyModifier;
        }

        public float getDamageModifier(Player shooter) {
            return this.damageModifier;
        }

        public float getVelocityModifier(Player shooter) {
            return this.velocityModifier;
        }

        public void onArrowLoosed(Player shooter) {
            FluxBowItem.this.useEnergy(this.bowItem, FluxBowItem.this.isEmpowered(this.bowItem), shooter.f_36077_.f_35937_);
        }

        public boolean fireArrow(ItemStack arrow, Player shooter, int charge, Level world) {
            if (FluxBowItem.this.isEmpowered(this.bowItem) && FluxBowItem.this.hasEnergy(this.bowItem, true)) {
                return this.fireInstantArrow(this.bowItem, arrow, shooter, charge, world);
            }
            return ArcheryHelper.fireArrow((ItemStack)this.bowItem, (ItemStack)arrow, (Player)shooter, (int)charge, (Level)world);
        }

        public boolean fireInstantArrow(ItemStack bow, ItemStack ammo, Player shooter, int charge, Level world) {
            boolean infinite;
            IArcheryBowItem bowCap = (IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)new ArcheryBowItemWrapper(bow));
            IArcheryAmmoItem ammoCap = (IArcheryAmmoItem)ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).orElse((Object)new ArcheryAmmoItemWrapper(ammo));
            boolean bl = infinite = shooter.f_36077_.f_35937_ || ammoCap.isInfinite(bow, shooter) || ArcheryHelper.isArrow((ItemStack)ammo) && ((ArrowItem)ammo.m_41720_()).isInfinite(ammo, bow, shooter) || ammo.m_41619_() && Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)bow) > 0;
            if (!ammo.m_41619_() || infinite) {
                if (ammo.m_41619_()) {
                    ammo = new ItemStack((ItemLike)Items.f_42412_);
                }
                float arrowVelocity = BowItem.m_40661_((int)charge);
                float accuracyMod = bowCap.getAccuracyModifier(shooter);
                float damageMod = bowCap.getDamageModifier(shooter);
                float velocityMod = bowCap.getVelocityModifier(shooter);
                if (arrowVelocity >= 0.1f) {
                    if (Utils.isServerWorld((Level)world)) {
                        int encVolley = Utils.getItemEnchantmentLevel((Enchantment)Utils.getEnchantment((String)"ensorcellation", (String)"volley"), (ItemStack)bow);
                        int encTrueshot = Utils.getItemEnchantmentLevel((Enchantment)Utils.getEnchantment((String)"ensorcellation", (String)"trueshot"), (ItemStack)bow);
                        int encPunch = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44989_, (ItemStack)bow);
                        int encPower = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)bow);
                        int encFlame = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44990_, (ItemStack)bow);
                        if (encTrueshot > 0) {
                            accuracyMod *= 1.5f / (float)(1 + encTrueshot);
                            damageMod *= 1.0f + 0.25f * (float)encTrueshot;
                            arrowVelocity = MathHelper.clamp((float)0.1f, (float)(arrowVelocity + 0.05f * (float)encTrueshot), (float)1.75f);
                        }
                        int numArrows = encVolley > 0 ? 3 : 1;
                        float volleyPitch = encVolley > 0 ? MathHelper.clamp((float)(90.0f + shooter.f_19858_ / (float)encVolley), (float)0.0f, (float)5.0f) : 0.0f;
                        BowItem bowItem = bow.m_41720_() instanceof BowItem ? (BowItem)bow.m_41720_() : null;
                        for (int shot = 0; shot < numArrows; ++shot) {
                            AbstractArrow arrow = ArcheryHelper.createArrow((Level)world, (ItemStack)ammo, (Player)shooter);
                            if (bowItem != null) {
                                arrow = bowItem.customArrow(arrow);
                            }
                            arrow.m_37251_((Entity)shooter, shooter.f_19858_ - volleyPitch * (float)shot, shooter.f_19857_, 0.0f, arrowVelocity * 3.0f * velocityMod, accuracyMod);
                            arrow.m_36781_(arrow.m_36789_() * (double)damageMod);
                            if (arrowVelocity >= 1.0f) {
                                arrow.m_36762_(true);
                            }
                            if (encTrueshot > 0) {
                                arrow.m_36767_((byte)encTrueshot);
                            }
                            if (encPower > 0 && arrow.m_36789_() > 0.0) {
                                arrow.m_36781_(arrow.m_36789_() + (double)encPower * 0.5 + 0.5);
                            }
                            if (encPunch > 0) {
                                arrow.m_36735_(encPunch);
                            }
                            if (encFlame > 0) {
                                arrow.m_20254_(100);
                            }
                            if (infinite || shot > 0) {
                                arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                            }
                            this.simulateArrow(arrow, world, 100);
                            if (!arrow.m_6084_()) continue;
                            world.m_7967_((Entity)arrow);
                        }
                        bowCap.onArrowLoosed(shooter);
                    }
                    world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                    if (!infinite && !shooter.f_36077_.f_35937_) {
                        ammoCap.onArrowLoosed(shooter);
                        if (ammo.m_41619_()) {
                            shooter.f_36093_.m_36057_(ammo);
                        }
                    }
                    shooter.m_36246_(Stats.f_12982_.m_12902_((Object)bow.m_41720_()));
                }
                return true;
            }
            return false;
        }

        public void simulateArrow(AbstractArrow arrow, Level world, int maxTicks) {
            for (int i = 0; i < maxTicks && arrow.m_6084_() && !arrow.m_20096_() && arrow.f_36697_ <= 1; ++i) {
                arrow.m_8119_();
                Vec3 velocity = arrow.m_20184_();
                if (!world.m_5776_()) {
                    Vec3 prevPos = velocity.m_82490_(-0.5).m_82549_(arrow.m_20182_());
                    ((ServerLevel)world).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, prevPos.m_7096_(), prevPos.m_7098_(), prevPos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)world).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (velocity.m_82556_() < (double)0.02f) break;
            }
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityArchery.BOW_ITEM_CAPABILITY) {
                return CapabilityArchery.BOW_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

