/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.experimental.entity.block_caching.suffocation;

import me.jellysquid.mods.lithium.common.entity.block_tracking.BlockCache;
import me.jellysquid.mods.lithium.common.entity.block_tracking.BlockCacheProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements BlockCacheProvider {
    @Shadow
    public Level f_19853_;
    @Shadow
    private EntityDimensions f_19815_;

    protected EntityMixin(EntityDimensions dimensions) {
        this.f_19815_ = dimensions;
    }

    @Inject(method={"isInsideWall"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;stream(Lnet/minecraft/util/math/Box;)Ljava/util/stream/Stream;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void isInsideWall(CallbackInfoReturnable<Boolean> cir, float f, AABB box) {
        int minX = Mth.m_14107_((double)box.f_82288_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxX = Mth.m_14107_((double)box.f_82291_);
        int maxY = Mth.m_14107_((double)box.f_82292_);
        int maxZ = Mth.m_14107_((double)box.f_82293_);
        BlockCache bc = this.getUpdatedBlockCache((Entity)this);
        byte cachedSuffocation = bc.getIsSuffocating();
        if (cachedSuffocation == 0) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (cachedSuffocation == 1) {
            cir.setReturnValue((Object)true);
            return;
        }
        Level world = this.f_19853_;
        if (world.m_141937_() > maxY || world.m_151558_() < minY) {
            bc.setCachedIsSuffocating(false);
            cir.setReturnValue((Object)false);
            return;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        VoxelShape suffocationShape = null;
        boolean shouldCache = true;
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    blockPos.m_122178_(x, y, z);
                    BlockState blockState = world.m_8055_((BlockPos)blockPos);
                    if (blockState.m_60795_() || !blockState.m_60828_((BlockGetter)this.f_19853_, (BlockPos)blockPos)) continue;
                    if (shouldCache && blockState.m_204336_(BlockTags.f_13083_)) {
                        shouldCache = false;
                    }
                    if (suffocationShape == null) {
                        suffocationShape = Shapes.m_83064_((AABB)new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_));
                    }
                    if (!Shapes.m_83157_((VoxelShape)blockState.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockPos).m_83216_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (VoxelShape)suffocationShape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    if (shouldCache) {
                        bc.setCachedIsSuffocating(true);
                    }
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
        if (shouldCache) {
            bc.setCachedIsSuffocating(false);
        }
        cir.setReturnValue((Object)false);
    }
}

