/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.item.faulty;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.parts.automation.AbstractLevelEmitterPart;
import appeng.parts.storagebus.StorageBusPart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import stone.mae2.MAE2;
import stone.mae2.item.faulty.FaultyCardMode;
import stone.mae2.util.TransHelper;

public class Incrementing
extends FaultyCardMode {
    private static final String IS_INCREMENTING = "incrementing";
    private boolean isIncrementing;

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        BlockEntity be = level.m_7702_(context.m_8083_());
        if (be instanceof IPartHost) {
            Item item;
            IPartHost partHost = (IPartHost)be;
            SelectedPart selectedPart = partHost.selectPartWorld(context.m_43720_());
            if (selectedPart.part != null && selectedPart.side != null && (item = stack.m_41720_()) instanceof IMemoryCard) {
                IMemoryCard card = (IMemoryCard)item;
                CompoundTag data = card.getData(stack);
                if (AbstractLevelEmitterPart.class.isAssignableFrom(selectedPart.part.getClass())) {
                    data.m_128356_("reportingValue", data.m_128454_("reportingValue") + (long)(this.isIncrementing ? 1 : -1));
                }
                if (StorageBusPart.class.isAssignableFrom(selectedPart.part.getClass())) {
                    data.m_128405_("priority", data.m_128451_("priority") + (this.isIncrementing ? 1 : -1));
                }
                stack.m_41784_().m_128365_("Data", (Tag)data);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> onItemUse(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.isIncrementing = !this.isIncrementing;
        this.save(stack.m_41784_());
        player.m_5661_(this.getName(), true);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    protected FaultyCardMode load(CompoundTag tag) {
        this.isIncrementing = tag.m_128471_(IS_INCREMENTING);
        return this;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        CompoundTag data = super.save(tag);
        data.m_128379_(IS_INCREMENTING, this.isIncrementing);
        return data;
    }

    @Override
    public ResourceLocation getType() {
        return MAE2.toKey(IS_INCREMENTING);
    }

    @Override
    protected Component getName() {
        return Component.m_237115_((String)TransHelper.GUI.toKey("faulty", this.isIncrementing ? "increment" : "decrement"));
    }

    @Override
    public int getTintColor() {
        int p = AEColor.MAGENTA.mediumVariant;
        if (this.isIncrementing) {
            int saturate = ((p & 0x808080) >> 7) * 255;
            p = (p & 0x7F7F7F) << 1 | saturate;
        }
        return p;
    }
}

