/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.appeng.helpers.patternprovider;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.me.storage.CompositeStorage;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.BlockApiCache;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class PatternProviderTargetCache {
    private final BlockApiCache<MEStorage> cache;
    private final Direction direction;
    private final IActionSource src;
    private final Map<AEKeyType, ExternalStorageStrategy> strategies;

    public PatternProviderTargetCache(ServerLevel l, BlockPos pos, Direction direction, IActionSource src) {
        this.cache = BlockApiCache.create((Capability)Capabilities.STORAGE, (ServerLevel)l, (BlockPos)pos);
        this.direction = direction;
        this.src = src;
        this.strategies = StackWorldBehaviors.createExternalStorageStrategies((ServerLevel)l, (BlockPos)pos, (Direction)direction);
    }

    @Nullable
    public PatternProviderTarget find() {
        MEStorage meStorage = (MEStorage)this.cache.find(this.direction);
        if (meStorage != null) {
            return this.wrapMeStorage(meStorage);
        }
        IdentityHashMap<AEKeyType, MEStorage> externalStorages = new IdentityHashMap<AEKeyType, MEStorage>(2);
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.strategies.entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(false, () -> {});
            if (wrapper == null) continue;
            externalStorages.put(entry.getKey(), wrapper);
        }
        if (externalStorages.size() > 0) {
            return this.wrapMeStorage((MEStorage)new CompositeStorage(externalStorages));
        }
        return null;
    }

    private PatternProviderTarget wrapMeStorage(final MEStorage storage) {
        return new PatternProviderTarget(){

            public long insert(AEKey what, long amount, Actionable type) {
                return storage.insert(what, amount, type, PatternProviderTargetCache.this.src);
            }

            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                for (Object2LongMap.Entry stack : storage.getAvailableStacks()) {
                    if (!patternInputs.contains(((AEKey)stack.getKey()).dropSecondary())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

