/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.StreetParts;

public class StreetSettings {
    private final Integer streetWidth;
    private final Character streetBlock;
    private final Character streetBaseBlock;
    private final Character streetVariantBlock;
    private final Character borderBlock;
    private final Character wallBlock;
    private final StreetParts parts;
    public static final Codec<StreetSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("width").forGetter(l -> Optional.ofNullable(l.streetWidth)), (App)Codec.STRING.optionalFieldOf("street").forGetter(l -> DataTools.toNullable(l.streetBlock)), (App)Codec.STRING.optionalFieldOf("streetbase").forGetter(l -> DataTools.toNullable(l.streetBaseBlock)), (App)Codec.STRING.optionalFieldOf("streetvariant").forGetter(l -> DataTools.toNullable(l.streetVariantBlock)), (App)Codec.STRING.optionalFieldOf("border").forGetter(l -> DataTools.toNullable(l.borderBlock)), (App)Codec.STRING.optionalFieldOf("wall").forGetter(l -> DataTools.toNullable(l.wallBlock)), (App)StreetParts.CODEC.optionalFieldOf("parts").forGetter(l -> l.parts.get())).apply((Applicative)instance, StreetSettings::new));

    public Integer getStreetWidth() {
        return this.streetWidth;
    }

    public Character getStreetBlock() {
        return this.streetBlock;
    }

    public Character getStreetBaseBlock() {
        return this.streetBaseBlock;
    }

    public Character getStreetVariantBlock() {
        return this.streetVariantBlock;
    }

    public Character getBorderBlock() {
        return this.borderBlock;
    }

    public Character getWallBlock() {
        return this.wallBlock;
    }

    public StreetParts getParts() {
        return this.parts;
    }

    public StreetSettings(Optional<Integer> streetWidth, Optional<String> streetBlock, Optional<String> streetBaseBlock, Optional<String> streetVariantBlock, Optional<String> borderBlock, Optional<String> wallBlock, Optional<StreetParts> parts) {
        this.streetWidth = streetWidth.orElse(null);
        this.streetBlock = DataTools.getNullableChar(streetBlock);
        this.streetBaseBlock = DataTools.getNullableChar(streetBaseBlock);
        this.streetVariantBlock = DataTools.getNullableChar(streetVariantBlock);
        this.borderBlock = DataTools.getNullableChar(borderBlock);
        this.wallBlock = DataTools.getNullableChar(wallBlock);
        this.parts = parts.orElse(StreetParts.DEFAULT);
    }
}

