/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.QualityRandom;
import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Transform;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Building;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import mcjty.lostcities.worldgen.lost.cityassets.MultiBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.ScatteredBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredReference;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredSettings;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Scattered {
    public static boolean avoidScattered(LostCityTerrainFeature feature, BuildingInfo info) {
        if (info.isCity) {
            return true;
        }
        if (info.hasBridge(feature.provider)) {
            return true;
        }
        return Highway.hasHighway(info.coord, feature.provider, feature.profile);
    }

    public static void generateScattered(LostCityTerrainFeature feature, BuildingInfo info, ScatteredSettings scatteredSettings, ChunkHeightmap heightmap) {
        int diff;
        int h;
        int w;
        MultiBuilding multiBuilding;
        int chunkX = info.coord.chunkX();
        int chunkZ = info.coord.chunkZ();
        IDimensionInfo provider = feature.provider;
        int ax = (chunkX + 2000000) / scatteredSettings.getAreasize();
        int az = (chunkZ + 2000000) / scatteredSettings.getAreasize();
        QualityRandom scatteredRandom = new QualityRandom(provider.getSeed() + (long)ax * 5564338337L + (long)az * 25564337621L);
        if (scatteredRandom.nextFloat() < scatteredSettings.getChance()) {
            return;
        }
        ScatteredReference reference = Scattered.selectRandomScattered(feature, info, scatteredSettings, scatteredRandom);
        if (reference == null) {
            return;
        }
        ScatteredBuilding scattered = AssetRegistries.SCATTERED.getOrThrow((CommonLevelAccessor)provider.getWorld(), reference.getName());
        if (scattered.getMultibuilding() != null) {
            multiBuilding = AssetRegistries.MULTI_BUILDINGS.getOrThrow((CommonLevelAccessor)provider.getWorld(), scattered.getMultibuilding());
            w = multiBuilding.getDimX();
            h = multiBuilding.getDimZ();
        } else {
            h = 1;
            w = 1;
            multiBuilding = null;
        }
        int tlChunkX = ax * scatteredSettings.getAreasize() - 2000000 + scatteredRandom.nextInt(scatteredSettings.getAreasize() - w + 1);
        int tlChunkZ = az * scatteredSettings.getAreasize() - 2000000 + scatteredRandom.nextInt(scatteredSettings.getAreasize() - h + 1);
        if (chunkX < tlChunkX || chunkZ < tlChunkZ || chunkX >= tlChunkX + w || chunkZ >= tlChunkZ + h) {
            return;
        }
        int minheight = Integer.MAX_VALUE;
        int maxheight = Integer.MIN_VALUE;
        int avgheight = 0;
        for (int x = tlChunkX; x < tlChunkX + w; ++x) {
            for (int z = tlChunkZ; z < tlChunkZ + h; ++z) {
                ChunkCoord coord = new ChunkCoord(provider.getType(), x, z);
                if (!Scattered.isValidScatterBiome(feature, reference, coord)) {
                    return;
                }
                BuildingInfo tinfo = BuildingInfo.getBuildingInfo(coord, provider);
                if (Scattered.avoidScattered(feature, tinfo)) {
                    return;
                }
                if (!(!reference.isNearHighway() || Highway.hasHighway(coord.east(), provider, feature.profile) || Highway.hasHighway(coord.west(), provider, feature.profile) || Highway.hasHighway(coord.north(), provider, feature.profile) || Highway.hasHighway(coord.south(), provider, feature.profile))) {
                    return;
                }
                ChunkHeightmap hm = feature.getHeightmap(coord, provider.getWorld());
                if (!(reference.isAllowVoid() || feature.profile.isDefault() || feature.profile.isCavern() || hm.getHeight() > feature.provider.getWorld().m_141937_() + 3)) {
                    return;
                }
                minheight = Math.min(minheight, hm.getHeight());
                maxheight = Math.max(maxheight, hm.getHeight());
                avgheight += hm.getHeight();
            }
        }
        if (reference.getMaxheightdiff() != null && (diff = maxheight - minheight) > reference.getMaxheightdiff()) {
            return;
        }
        avgheight /= w * h;
        if (multiBuilding == null) {
            List<String> buildings = scattered.getBuildings();
            if (buildings == null) {
                throw new RuntimeException("Missing buildings for scattered '" + reference.getName() + "'!");
            }
            String buildingName = buildings.size() == 1 ? buildings.get(0) : buildings.get(scatteredRandom.nextInt(buildings.size()));
            Building building = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)provider.getWorld(), buildingName);
            int lowestLevel = Scattered.handleScatteredTerrain(feature, scattered, info.coord, heightmap);
            Scattered.generateScatteredBuilding(feature, info, building, scatteredRandom, lowestLevel, scattered.getTerrainfix());
        } else {
            int lowestLevel = Scattered.handleScatteredTerrainMulti(feature, scattered, info.coord, minheight, maxheight, avgheight);
            int relx = chunkX - tlChunkX;
            int relz = chunkZ - tlChunkZ;
            String buildingName = multiBuilding.getBuilding(relx, relz);
            Building building = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)provider.getWorld(), buildingName);
            Scattered.generateScatteredBuilding(feature, info, building, scatteredRandom, lowestLevel, scattered.getTerrainfix());
        }
    }

    @Nullable
    private static ScatteredReference selectRandomScattered(LostCityTerrainFeature feature, BuildingInfo info, ScatteredSettings scatteredSettings, Random rand) {
        ScatteredReference reference2;
        List<ScatteredReference> list = scatteredSettings.getList();
        if (list.isEmpty()) {
            return null;
        }
        int totalweight = 0;
        ArrayList<ScatteredReference> filteredList = new ArrayList<ScatteredReference>();
        for (ScatteredReference reference2 : list) {
            if (!Scattered.isValidScatterBiome(feature, reference2, info.coord)) continue;
            totalweight += reference2.getWeight();
            filteredList.add(reference2);
        }
        if (filteredList.isEmpty()) {
            return null;
        }
        int rndweight = rand.nextInt(totalweight + scatteredSettings.getWeightnone());
        reference2 = null;
        for (ScatteredReference scatteredReference : filteredList) {
            int weight = scatteredReference.getWeight();
            if (rndweight <= weight) {
                reference2 = scatteredReference;
                break;
            }
            rndweight -= weight;
        }
        return reference2;
    }

    private static boolean isValidScatterBiome(LostCityTerrainFeature feature, ScatteredReference reference, ChunkCoord coord) {
        if (reference.getBiomeMatcher() != null) {
            BiomeInfo biome = BiomeInfo.getBiomeInfo(feature.provider, coord);
            return reference.getBiomeMatcher().test(biome.getMainBiome());
        }
        return true;
    }

    private static void generateScatteredBuilding(LostCityTerrainFeature feature, final BuildingInfo info, Building building, Random rand, int lowestLevel, ScatteredBuilding.TerrainFix terrainFix) {
        int maxfloors;
        final IDimensionInfo provider = feature.provider;
        int height = lowestLevel;
        int minfloors = building.getMinFloors();
        if (minfloors <= 0) {
            minfloors = 1;
        }
        if ((maxfloors = building.getMaxFloors()) <= 0) {
            maxfloors = 1;
        }
        int floors = minfloors >= maxfloors ? minfloors : minfloors + rand.nextInt(maxfloors - minfloors + 1);
        for (int f = 0; f < floors; ++f) {
            ConditionContext conditionContext = new ConditionContext(lowestLevel, f, 0, floors, "<none>", building.getName(), info.coord){

                @Override
                public boolean isBuilding() {
                    return true;
                }

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(info.coord, info.getCenter(0), provider);
                }

                @Override
                public ResourceLocation getBiome() {
                    Holder biome = provider.getWorld().m_204166_(info.getCenter(0));
                    return (ResourceLocation)biome.m_203439_().map(ResourceKey::m_135782_, b -> provider.getWorld().m_9598_().m_175515_(Registries.f_256952_).m_7981_(b));
                }
            };
            ChunkDriver driver = feature.driver;
            BlockState air = Blocks.f_50016_.m_49966_();
            BlockState liquid = feature.liquid;
            String randomPart = building.getRandomPart(rand, conditionContext);
            BuildingPart part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), randomPart);
            randomPart = building.getRandomPart2(rand, conditionContext);
            BuildingPart part2 = AssetRegistries.PARTS.get((CommonLevelAccessor)provider.getWorld(), randomPart);
            if (f == 0) {
                switch (terrainFix) {
                    case NONE: {
                        break;
                    }
                    case CLEAR: {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                feature.clearRange(info, x, z, lowestLevel, lowestLevel + 50, false);
                            }
                        }
                        break;
                    }
                    case REPEATSLICE: {
                        CompiledPalette compiledPalette = feature.computePalette(info, part);
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                char c = part.getPaletteChar(x, 0, z).charValue();
                                if (c == ' ') continue;
                                int y = lowestLevel - 1;
                                driver.current(x, y, z);
                                BlockState b = driver.getBlock();
                                while (b == air || b == liquid) {
                                    driver.block(compiledPalette.get(c));
                                    driver.decY();
                                    b = driver.getBlock();
                                }
                            }
                        }
                        break;
                    }
                }
            }
            height += feature.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, LostCityTerrainFeature.HardAirSetting.AIR);
            if (part2 == null) continue;
            feature.generatePart(info, part2, Transform.ROTATE_NONE, 0, height, 0, LostCityTerrainFeature.HardAirSetting.AIR);
        }
    }

    private static int handleScatteredTerrain(LostCityTerrainFeature feature, ScatteredBuilding scattered, ChunkCoord coord, ChunkHeightmap heightmap) {
        int lowestLevel = switch (scattered.getTerrainheight()) {
            default -> throw new IncompatibleClassChangeError();
            case ScatteredBuilding.TerrainHeight.LOWEST -> heightmap.getHeight();
            case ScatteredBuilding.TerrainHeight.AVERAGE -> heightmap.getHeight();
            case ScatteredBuilding.TerrainHeight.HIGHEST -> heightmap.getHeight();
            case ScatteredBuilding.TerrainHeight.OCEAN -> ((ServerChunkCache)feature.provider.getWorld().m_7726_()).m_8481_().m_6337_();
        };
        return lowestLevel += scattered.getHeightoffset();
    }

    private static int handleScatteredTerrainMulti(LostCityTerrainFeature feature, ScatteredBuilding scattered, ChunkCoord coord, int minimum, int maximum, int average) {
        int lowestLevel = switch (scattered.getTerrainheight()) {
            default -> throw new IncompatibleClassChangeError();
            case ScatteredBuilding.TerrainHeight.LOWEST -> minimum;
            case ScatteredBuilding.TerrainHeight.AVERAGE -> maximum;
            case ScatteredBuilding.TerrainHeight.HIGHEST -> average;
            case ScatteredBuilding.TerrainHeight.OCEAN -> ((ServerChunkCache)feature.provider.getWorld().m_7726_()).m_8481_().m_6337_();
        };
        return lowestLevel += scattered.getHeightoffset();
    }
}

