/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularForegroundRecipeWidget;
import com.lowdragmc.lowdraglib.jei.ModularUIGuiEventListener;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ModularUIRecipeCategory<T extends ModularWrapper<?>>
implements IRecipeCategory<T> {
    private static void addJEISlot(IRecipeLayoutBuilder builder, final IRecipeIngredientSlot slot, RecipeIngredientRole role, int index) {
        String slotName = "slot_" + index;
        IRecipeSlotBuilder slotBuilder = builder.addSlot(role, slot.self().getPositionX(), slot.self().getPositionY());
        HashMap<IIngredientType, List> ingredientMap = new HashMap<IIngredientType, List>();
        for (Object object : slot.getXEIIngredients()) {
            if (!(object instanceof IClickableIngredient)) continue;
            IClickableIngredient clickableIngredient = (IClickableIngredient)object;
            ingredientMap.computeIfAbsent(clickableIngredient.getIngredientType(), k -> new ArrayList()).add(clickableIngredient.getIngredient());
        }
        for (Map.Entry entry : ingredientMap.entrySet()) {
            IIngredientType type = (IIngredientType)entry.getKey();
            List ingredients = (List)entry.getValue();
            slotBuilder.addIngredients(type, ingredients);
            slotBuilder.setCustomRenderer(type, (IIngredientRenderer)new IIngredientRenderer<Object>(){

                public void render(GuiGraphics guiGraphics, Object ingredient) {
                    slot.setCurrentJEIRenderedIngredient(ingredient);
                }

                public List<Component> getTooltip(Object ingredient, TooltipFlag tooltipFlag) {
                    return Collections.emptyList();
                }

                public void getTooltip(ITooltipBuilder tooltip, Object ingredient, TooltipFlag tooltipFlag) {
                    tooltip.addAll(slot.getFullTooltipTexts());
                }

                public int getWidth() {
                    return slot.self().getSizeWidth();
                }

                public int getHeight() {
                    return slot.self().getSizeHeight();
                }
            });
        }
        slotBuilder.setSlotName(slotName);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T wrapper, IFocusGroup focuses) {
        ((ModularWrapper)((Object)wrapper)).setRecipeWidget(0, 0);
        List<Widget> flatVisibleWidgetCollection = ((ModularWrapper)((Object)wrapper)).modularUI.getFlatWidgetCollection();
        for (int i = 0; i < flatVisibleWidgetCollection.size(); ++i) {
            Widget widget = flatVisibleWidgetCollection.get(i);
            if (!(widget instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)widget);
            RecipeIngredientRole role = ModularUIRecipeCategory.mapToRole(slot.getIngredientIO());
            if (role == null) {
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.INPUT, i);
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.OUTPUT, i);
                continue;
            }
            ModularUIRecipeCategory.addJEISlot(builder, slot, role, i);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T wrapper, IFocusGroup focuses) {
        builder.addGuiEventListener(new ModularUIGuiEventListener((ModularWrapper<?>)((Object)wrapper)));
        builder.addWidget((IRecipeWidget)new ModularForegroundRecipeWidget((ModularWrapper<?>)((Object)wrapper)));
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ((ModularWrapper)((Object)recipe)).draw(guiGraphics, (int)mouseX, (int)mouseY, Minecraft.m_91087_().m_91296_());
    }

    public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        if (((ModularWrapper)((Object)recipe)).tooltipTexts != null && !((ModularWrapper)((Object)recipe)).tooltipTexts.isEmpty()) {
            tooltip.addAll((Collection)((ModularWrapper)((Object)recipe)).tooltipTexts);
        }
        if (((ModularWrapper)((Object)recipe)).tooltipComponent != null) {
            tooltip.add(((ModularWrapper)((Object)recipe)).tooltipComponent);
        }
    }

    @Nullable
    public static RecipeIngredientRole mapToRole(IngredientIO ingredientIO) {
        return switch (ingredientIO) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientIO.INPUT -> RecipeIngredientRole.INPUT;
            case IngredientIO.OUTPUT -> RecipeIngredientRole.OUTPUT;
            case IngredientIO.CATALYST -> RecipeIngredientRole.CATALYST;
            case IngredientIO.RENDER_ONLY -> RecipeIngredientRole.RENDER_ONLY;
            case IngredientIO.BOTH -> null;
        };
    }
}

