/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor.language;

import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.ILanguageDefinition;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.TokenType;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class LanguageDefinition
implements ILanguageDefinition {
    private final String name;
    private final List<TokenType> typesInOrder;
    private final Set<String> indentations;
    private Pattern tokenPattern;

    public LanguageDefinition(String name, List<TokenType> typesInOrder, Set<String> indentations) {
        this.name = name;
        this.typesInOrder = typesInOrder;
        this.indentations = indentations;
    }

    public LanguageDefinition compileTokenPattern() {
        StringBuilder patternBuilder = new StringBuilder();
        for (TokenType tokenType : this.typesInOrder) {
            if (!tokenType.hasPattern()) continue;
            patternBuilder.append("|(?<").append(tokenType.name).append(">").append(tokenType.getPattern()).append(")");
        }
        if (!patternBuilder.isEmpty()) {
            patternBuilder.deleteCharAt(0);
        }
        this.tokenPattern = Pattern.compile(patternBuilder.toString());
        return this;
    }

    @Override
    public Pattern getTokenPattern() {
        if (this.tokenPattern == null) {
            this.compileTokenPattern();
        }
        return this.tokenPattern;
    }

    @Override
    @Nullable
    public TokenType getTokenType(Matcher matcher) {
        for (TokenType type : this.typesInOrder) {
            if (!type.test(matcher)) continue;
            return type;
        }
        return null;
    }

    @Override
    public boolean shouldIncreaseIndentation(String trimmedLine) {
        for (String indentation : this.indentations) {
            if (!trimmedLine.endsWith(indentation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<TokenType> getTypesInOrder() {
        return this.typesInOrder;
    }

    public Set<String> getIndentations() {
        return this.indentations;
    }
}

