/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.FileNode;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ItemStackSelectorWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.TreeListWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DialogWidget
extends WidgetGroup {
    protected boolean isParentInVisible;
    protected Runnable onClosed;
    protected boolean clickClose;

    public DialogWidget(WidgetGroup parent, boolean isClient) {
        this(0, 0, parent.getSize().width, parent.getSize().height);
        if (isClient) {
            this.setClientSideWidget();
        }
        if (this.autoAdd()) {
            parent.addWidget(this);
        }
    }

    public DialogWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    protected boolean autoAdd() {
        return true;
    }

    public DialogWidget setOnClosed(Runnable onClosed) {
        this.onClosed = onClosed;
        return this;
    }

    public DialogWidget setParentInVisible() {
        this.isParentInVisible = true;
        for (Widget widget : this.parent.widgets) {
            if (widget == this) continue;
            widget.setVisible(false);
            widget.setActive(false);
        }
        return this;
    }

    public void close() {
        this.parent.waitToRemoved(this);
        if (this.isParentInVisible) {
            for (Widget widget : this.parent.widgets) {
                widget.setVisible(true);
                widget.setActive(true);
            }
        }
        if (this.onClosed != null) {
            this.onClosed.run();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            if (this.clickClose) {
                this.close();
                return true;
            }
            return false;
        }
        super.mouseClicked(mouseX, mouseY, button);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        super.mouseReleased(mouseX, mouseY, button);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        super.mouseWheelMove(mouseX, mouseY, wheelDelta);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseMoved(double mouseX, double mouseY) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        super.mouseMoved(mouseX, mouseY);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!super.keyPressed(keyCode, scanCode, modifiers) && keyCode == 256) {
            this.writeClientAction(-1, x -> {});
            this.close();
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        super.keyReleased(keyCode, scanCode, modifiers);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean charTyped(char codePoint, int modifiers) {
        super.charTyped(codePoint, modifiers);
        return true;
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        if (id == -1) {
            this.close();
        }
    }

    public static Predicate<TreeNode<File, File>> suffixFilter(String ... suffixes) {
        return node -> {
            for (String suffix : suffixes) {
                if (node.isLeaf() && ((File)node.getContent()).isFile() && !((File)node.getContent()).getName().toLowerCase().endsWith(suffix.toLowerCase())) continue;
                return true;
            }
            return false;
        };
    }

    public static WidgetGroup createContainer(DialogWidget dialog, int x, int y, int width, int height, String titleText) {
        WidgetGroup title = new WidgetGroup(x, y, width, 15);
        dialog.addWidget(title);
        title.setBackground(new GuiTextureGroup(ColorPattern.RED.rectTexture().setTopRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setTopRadius(5.0f), new TextTexture(titleText).setWidth(width).setDropShadow(false).setType(TextTexture.TextType.ROLL)));
        WidgetGroup content = new WidgetGroup(x, y + 15, width, height - 15);
        dialog.addWidget(content);
        content.setBackground(new GuiTextureGroup(ColorPattern.BLACK.rectTexture().setBottomRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setBottomRadius(5.0f)));
        return content;
    }

    public static WidgetGroup createContainer(DialogWidget dialog, int width, int height, String titleText) {
        return DialogWidget.createContainer(dialog, (dialog.getSize().width - width) / 2, (dialog.getSize().height - height) / 2, width, height, titleText);
    }

    public static TextFieldWidget createTextField(WidgetGroup parent, int x, int y, int width, int height) {
        parent.addWidget(new ImageWidget(x, y, width, height, ColorPattern.T_GRAY.rectTexture().setRadius((float)height / 2.0f)));
        TextFieldWidget textFieldWidget = new TextFieldWidget(x + 3, y, width - 6, height, null, null);
        parent.addWidget(textFieldWidget);
        textFieldWidget.setBordered(false);
        return textFieldWidget;
    }

    public static TextTexture createText(WidgetGroup parent, int x, int y, int width, int height) {
        TextTexture textTexture = new TextTexture().setWidth(width);
        parent.addWidget(new ImageWidget(x, y, width, height, textTexture));
        return textTexture;
    }

    public static ButtonWidget createButton(WidgetGroup parent, int x, int y, int width, int height, String text, Runnable onClick) {
        ButtonWidget buttonWidget = new ButtonWidget(x, y, width, height, new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture().setRadius((float)height / 2.0f), new TextTexture(text).setWidth(width).setDropShadow(false).setType(TextTexture.TextType.ROLL)), cd -> onClick.run()).setHoverTexture(new GuiTextureGroup(ColorPattern.GRAY.rectTexture().setRadius((float)height / 2.0f), new TextTexture(text).setWidth(width).setDropShadow(false).setType(TextTexture.TextType.ROLL)));
        parent.addWidget(buttonWidget);
        return buttonWidget;
    }

    public static DialogWidget showStringEditorDialog(WidgetGroup parent, String title, String initial, @Nullable Predicate<String> predicate, Consumer<String> result) {
        DialogWidget dialog = new DialogWidget(parent, true);
        WidgetGroup container = DialogWidget.createContainer(dialog, 200, 100, title);
        Size size = container.getSize();
        TextFieldWidget textFieldWidget = DialogWidget.createTextField(container, 10, size.height / 2 - 10 - 5, size.width - 20, 10);
        textFieldWidget.setCurrentString(initial);
        if (predicate != null) {
            textFieldWidget.setValidator(s -> predicate.test((String)s) ? s : textFieldWidget.getCurrentString());
        }
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2, size.height / 2 + 20 - 7, 60, 15, "ldlib.gui.tips.confirm", () -> {
            dialog.close();
            if (result != null) {
                result.accept(textFieldWidget.getCurrentString());
            }
        });
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2 + size.width / 2, size.height / 2 + 20 - 7, 60, 15, "ldlib.gui.tips.cancel", () -> {
            dialog.close();
            if (result != null) {
                result.accept(null);
            }
        });
        return dialog;
    }

    public static DialogWidget showNotification(WidgetGroup parent, String title, String info) {
        return DialogWidget.showNotification(parent, title, info, 200, 100, null);
    }

    public static DialogWidget showNotification(WidgetGroup parent, String title, String info, int width, int height, Runnable onClosed) {
        DialogWidget dialog = new DialogWidget(parent, true);
        WidgetGroup container = DialogWidget.createContainer(dialog, width, height, title);
        Size size = container.getSize();
        TextTexture text = DialogWidget.createText(container, 10, size.height / 2 - 10 - 5, size.width - 20, 10);
        text.setSupplier(() -> info);
        DialogWidget.createButton(container, (size.width - 60) / 2, size.height / 2 + 20 - 7, 60, 15, "ldlib.gui.tips.confirm", () -> {
            dialog.close();
            if (onClosed != null) {
                onClosed.run();
            }
        });
        return dialog;
    }

    public static DialogWidget showCheckBox(WidgetGroup parent, String title, String info, BooleanConsumer onClosed) {
        return DialogWidget.showCheckBox(parent, title, info, 200, 100, onClosed);
    }

    public static DialogWidget showCheckBox(WidgetGroup parent, String title, String info, int width, int height, BooleanConsumer onClosed) {
        DialogWidget dialog = new DialogWidget(parent, true);
        WidgetGroup container = DialogWidget.createContainer(dialog, width, height, title);
        Size size = container.getSize();
        TextTexture text = DialogWidget.createText(container, 10, size.height / 2 - 10 - 5, size.width - 20, 10);
        text.setSupplier(() -> info);
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2, size.height - 20 + 3, 60, 15, "ldlib.gui.tips.confirm", () -> {
            dialog.close();
            if (onClosed != null) {
                onClosed.accept(true);
            }
        });
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2 + size.width / 2, size.height - 20 + 3, 60, 15, "ldlib.gui.tips.cancel", () -> {
            dialog.close();
            if (onClosed != null) {
                onClosed.accept(false);
            }
        });
        return dialog;
    }

    public static DialogWidget showItemSelector(WidgetGroup parent, String title, ItemStack init, Consumer<Item> itemConsumer) {
        DialogWidget dialog = new DialogWidget(parent, true);
        WidgetGroup container = DialogWidget.createContainer(dialog, 200, 100, title);
        Size size = container.getSize();
        AtomicReference<ItemStack> selected = new AtomicReference<ItemStack>();
        selected.set(init);
        container.addWidget(new ItemStackSelectorWidget(10, size.height / 2 - 20, size.width - 2, false).setItemStack(init).setOnItemStackUpdate(selected::set));
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2, size.height - 20 + 3, 60, 15, "ldlib.gui.tips.confirm", () -> {
            dialog.close();
            if (itemConsumer != null) {
                itemConsumer.accept(((ItemStack)selected.get()).m_41720_());
            }
        });
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2 + size.width / 2, size.height - 20 + 3, 60, 15, "ldlib.gui.tips.cancel", () -> {
            dialog.close();
            if (itemConsumer != null) {
                itemConsumer.accept(null);
            }
        });
        return dialog;
    }

    public static DialogWidget showFileDialog(WidgetGroup parent, String title, File dir, boolean isSelector, Predicate<TreeNode<File, File>> valid, Consumer<File> result) {
        DialogWidget dialog = new DialogWidget(parent, true);
        dialog.addWidget(new ImageWidget(0, 0, parent.getSize().width, parent.getSize().height, new ColorRectTexture(0x4F000000)));
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return dialog;
        }
        WidgetGroup container = DialogWidget.createContainer(dialog, 300, 200, title);
        Size size = container.getSize();
        AtomicReference<File> selected = new AtomicReference<File>();
        selected.set(dir);
        container.addWidget(new TreeListWidget(3, 15, size.width - 6, size.height - 20 - 15, new FileNode(dir).setValid(valid), node -> selected.set((File)node.getKey())).setKeyIconSupplier(file -> Icons.FOLDER).setContentIconSupplier(file -> Icons.getIcon(file.getName().substring(file.getName().lastIndexOf(46) + 1))).canSelectNode(true).setBackground((IGuiTexture)ColorPattern.GRAY.borderTexture(-1)));
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2, size.height - 20 + 3, 60, 15, "ldlib.gui.tips.confirm", () -> {
            dialog.close();
            if (result != null) {
                result.accept((File)selected.get());
            }
        });
        DialogWidget.createButton(container, (size.width / 2 - 60) / 2 + size.width / 2, size.height - 20 + 3, 60, 15, "ldlib.gui.tips.cancel", () -> {
            dialog.close();
            if (result != null) {
                result.accept(null);
            }
        });
        TextFieldWidget textFieldWidget = DialogWidget.createTextField(container, 3, 3, size.width - 6, 10);
        String rootPath = dir.toString();
        if (isSelector) {
            textFieldWidget.setTextSupplier(() -> {
                File file = (File)selected.get();
                if (file != null && !file.isDirectory()) {
                    return ((File)selected.get()).toString();
                }
                return "no file selected";
            });
            textFieldWidget.setTextResponder(res -> {
                if (!res.isEmpty() && res.startsWith(rootPath)) {
                    selected.set(new File((String)res));
                }
            });
        } else {
            textFieldWidget.setTextSupplier(() -> {
                File file = (File)selected.get();
                if (file != null && !file.isDirectory()) {
                    return ((File)selected.get()).getName();
                }
                return "";
            });
            textFieldWidget.setTextResponder(res -> {
                File file = (File)selected.get();
                if (file == null) {
                    return;
                }
                if (file.isDirectory()) {
                    selected.set(new File(file, (String)res));
                } else {
                    selected.set(new File(file.getParent(), (String)res));
                }
            });
        }
        container.addWidget(new ButtonWidget(3, size.height - 20 + 3, 15, 15, new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), Icons.OPEN_FILE), cd -> {
            File file = (File)selected.get();
            if (file != null) {
                Util.m_137581_().m_137644_(file.isDirectory() ? file : file.getParentFile());
            }
        }).setHoverTexture(new GuiTextureGroup(ColorPattern.GRAY.rectTexture().setRadius(5.0f), Icons.OPEN_FILE)).setHoverTooltips("ldlib.gui.tips.open_folder"));
        return dialog;
    }

    public void setClickClose(boolean clickClose) {
        this.clickClose = clickClose;
    }
}

