/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.resource;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;

public class ResourceContainer<T, C extends Widget>
extends WidgetGroup {
    protected final ResourcePanel panel;
    protected final Resource<T> resource;
    protected final Map<String, C> widgets;
    protected DraggableScrollableWidgetGroup container;
    protected Function<String, C> widgetSupplier;
    protected Function<String, T> onAdd;
    protected Predicate<String> onRemove;
    protected Consumer<String> onEdit;
    protected Function<String, Object> draggingMapping;
    protected TriFunction<String, Object, Position, IGuiTexture> draggingRenderer;
    protected Supplier<String> nameSupplier;
    protected Predicate<String> renamePredicate;
    @Nullable
    protected String selected;
    private boolean firstClick;
    private String firstClickName;
    private long firstClickTime;

    public ResourceContainer(Resource<T> resource, ResourcePanel panel) {
        super(3, 0, panel.getSize().width - 6, panel.getSize().height - 14);
        this.setClientSideWidget();
        this.widgets = new HashMap<String, C>();
        this.panel = panel;
        this.resource = resource;
    }

    public <D> ResourceContainer<T, C> setDragging(Function<String, D> draggingMapping, Function<D, IGuiTexture> draggingRenderer) {
        this.draggingMapping = draggingMapping::apply;
        this.draggingRenderer = (k, o, p) -> (IGuiTexture)draggingRenderer.apply(o);
        return this;
    }

    public <D> ResourceContainer<T, C> setDragging(Function<String, D> draggingMapping, TriFunction<String, D, Position, IGuiTexture> draggingRenderer) {
        this.draggingMapping = draggingMapping::apply;
        this.draggingRenderer = (k, o, p) -> (IGuiTexture)draggingRenderer.apply(k, o, p);
        return this;
    }

    @Override
    public void initWidget() {
        Size size = this.getSize();
        this.container = new DraggableScrollableWidgetGroup(1, 2, size.width - 2, size.height - 2);
        this.container.setYScrollBarWidth(4).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(2.0f));
        this.addWidget(this.container);
        this.reBuild();
        super.initWidget();
    }

    public void reBuild() {
        this.selected = null;
        this.container.clearAllWidgets();
        int width = this.getSize().getWidth();
        int x = 1;
        int y = 3;
        for (Map.Entry<String, T> entry : this.resource.allResources()) {
            Widget widget = (Widget)this.widgetSupplier.apply(entry.getKey());
            this.widgets.put(entry.getKey(), widget);
            Size size = widget.getSize();
            SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, 0, size.width, size.height + 14);
            selectableWidgetGroup.setDraggingProvider(this.draggingMapping == null ? entry::getValue : () -> this.draggingMapping.apply((String)entry.getKey()), (c, p) -> this.draggingRenderer == null ? new TextTexture((String)entry.getKey()) : (IGuiTexture)this.draggingRenderer.apply((Object)((String)entry.getKey()), c, p));
            selectableWidgetGroup.addWidget(widget);
            selectableWidgetGroup.addWidget(new ImageWidget(0, size.height + 3, size.width, 10, new TextTexture(entry.getKey()).setWidth(size.width).setType(TextTexture.TextType.ROLL)));
            selectableWidgetGroup.setOnSelected(s -> {
                this.selected = (String)entry.getKey();
            });
            selectableWidgetGroup.setOnUnSelected(s -> {
                this.selected = null;
            });
            selectableWidgetGroup.setSelectedTexture(ColorPattern.T_GRAY.rectTexture());
            size = selectableWidgetGroup.getSize();
            if (size.width >= width - 5) {
                selectableWidgetGroup.setSelfPosition(new Position(0, y));
                y += size.height + 3;
            } else if (size.width < width - 5 - x) {
                selectableWidgetGroup.setSelfPosition(new Position(x, y));
                x += size.width + 3;
            } else {
                x = 1;
                selectableWidgetGroup.setSelfPosition(new Position(x, y += size.height + 3));
                x += size.width + 3;
            }
            this.container.addWidget(selectableWidgetGroup);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (button == 1 && this.isMouseOverElement(mouseX, mouseY)) {
            this.panel.getEditor().openMenu(mouseX, mouseY, this.getMenu());
            return true;
        }
        if (button == 0 && this.isMouseOverElement(mouseX, mouseY) && this.selected != null && this.onEdit != null) {
            if (this.firstClick && this.firstClickName.equals(this.selected) && this.gui.getTickCount() - this.firstClickTime < 10L) {
                this.editResource();
                this.firstClick = false;
                return true;
            }
            this.firstClick = true;
            this.firstClickName = this.selected;
            this.firstClickTime = this.gui.getTickCount();
        }
        return result;
    }

    protected TreeBuilder.Menu getMenu() {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start();
        if (this.onEdit != null) {
            menu.leaf(Icons.EDIT_FILE, "ldlib.gui.editor.menu.edit", this::editResource);
        }
        menu.leaf("ldlib.gui.editor.menu.rename", this::renameResource);
        menu.crossLine();
        menu.leaf(Icons.COPY, "ldlib.gui.editor.menu.copy", this::copy);
        menu.leaf(Icons.PASTE, "ldlib.gui.editor.menu.paste", this::paste);
        if (this.onAdd != null) {
            menu.leaf(Icons.ADD_FILE, "ldlib.gui.editor.menu.add_resource", this::addNewResource);
        }
        menu.leaf(Icons.REMOVE_FILE, "ldlib.gui.editor.menu.remove", this::removeSelectedResource);
        return menu;
    }

    protected void paste() {
        this.panel.getEditor().ifCopiedPresent(this.resource.name(), c -> {
            T value = this.getResource().deserialize((Tag)c);
            this.resource.addResource(this.genNewFileName(), value);
            this.reBuild();
        });
    }

    protected void copy() {
        if (this.selected != null) {
            this.panel.getEditor().setCopy(this.resource.name(), this.resource.serialize(this.resource.getResource(this.selected)));
        }
    }

    protected void renameResource() {
        if (this.selected != null) {
            DialogWidget.showStringEditorDialog(Editor.INSTANCE, LocalizationUtils.format("ldlib.gui.editor.tips.rename", new Object[0]) + " " + LocalizationUtils.format(this.resource.name(), new Object[0]), this.selected, s -> {
                if (this.resource.hasResource((String)s)) {
                    return false;
                }
                if (this.renamePredicate != null) {
                    return this.renamePredicate.test((String)s);
                }
                return true;
            }, s -> {
                if (s == null) {
                    return;
                }
                T stored = this.resource.removeResource(this.selected);
                this.resource.addResource((String)s, stored);
                this.reBuild();
            });
        }
    }

    protected void editResource() {
        if (this.onEdit != null && this.selected != null) {
            this.onEdit.accept(this.selected);
        }
    }

    protected String genNewFileName() {
        Object randomName = "new ";
        if (this.nameSupplier != null) {
            randomName = this.nameSupplier.get();
        } else {
            int i = 0;
            while (this.resource.hasResource((String)randomName + i)) {
                ++i;
            }
            randomName = (String)randomName + i;
        }
        return randomName;
    }

    protected void addNewResource() {
        if (this.onAdd != null) {
            String randomName = this.genNewFileName();
            this.resource.addResource(randomName, this.onAdd.apply(randomName));
            this.reBuild();
        }
    }

    protected void removeSelectedResource() {
        if (this.selected == null) {
            return;
        }
        if (this.onRemove == null || this.onRemove.test(this.selected)) {
            this.resource.removeResource(this.selected);
            this.reBuild();
        }
    }

    public ResourcePanel getPanel() {
        return this.panel;
    }

    public Resource<T> getResource() {
        return this.resource;
    }

    public Map<String, C> getWidgets() {
        return this.widgets;
    }

    public ResourceContainer<T, C> setWidgetSupplier(Function<String, C> widgetSupplier) {
        this.widgetSupplier = widgetSupplier;
        return this;
    }

    public Function<String, C> getWidgetSupplier() {
        return this.widgetSupplier;
    }

    public ResourceContainer<T, C> setOnAdd(Function<String, T> onAdd) {
        this.onAdd = onAdd;
        return this;
    }

    public ResourceContainer<T, C> setOnRemove(Predicate<String> onRemove) {
        this.onRemove = onRemove;
        return this;
    }

    public ResourceContainer<T, C> setOnEdit(Consumer<String> onEdit) {
        this.onEdit = onEdit;
        return this;
    }

    public ResourceContainer<T, C> setNameSupplier(Supplier<String> nameSupplier) {
        this.nameSupplier = nameSupplier;
        return this;
    }

    public ResourceContainer<T, C> setRenamePredicate(Predicate<String> renamePredicate) {
        this.renamePredicate = renamePredicate;
        return this;
    }

    @Nullable
    public String getSelected() {
        return this.selected;
    }
}

