/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.LaserIO;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.setup.Registration;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class MixinUtil {
    public static int byteScale(int x, int y) {
        return x * y / 255;
    }

    public static int tintColor(int base, int tint) {
        int r = MixinUtil.byteScale(base & 0xFF, tint >> 16);
        int g = MixinUtil.byteScale(base >> 8 & 0xFF, tint >> 8 & 0xFF);
        int b = MixinUtil.byteScale(base >> 16 & 0xFF, tint & 0xFF);
        return r | g << 8 | b << 16 | base & 0xFF000000;
    }

    public static int byteLerp(int from, int to, int factor) {
        return (from * (255 - factor) + to * factor) / 255;
    }

    public static int blendColor(int dst, int src) {
        int factor = src >> 24 & 0xFF;
        int r = MixinUtil.byteLerp(dst & 0xFF, src & 0xFF, factor);
        int g = MixinUtil.byteLerp(dst >> 8 & 0xFF, src >> 8 & 0xFF, factor);
        int b = MixinUtil.byteLerp(dst >> 16 & 0xFF, src >> 16 & 0xFF, factor);
        int a = MixinUtil.byteLerp(dst >> 24 & 0xFF, factor, factor);
        return r | g << 8 | b << 16 | a << 24;
    }

    public static long getPixels(NativeImage image) {
        String imageString = image.toString();
        int startIndex = imageString.indexOf("@") + 1;
        String pixelsAsString = imageString.substring(startIndex, imageString.length() - 2);
        return Long.parseLong(pixelsAsString);
    }

    public static NativeImage loadNativeImage(String name) {
        NativeImage nativeImage;
        block8: {
            name = "/assets/laserio/textures/" + (String)name + ".png";
            InputStream is = LaserIO.class.getResourceAsStream((String)name);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return nativeImage;
    }

    public static void fillLangTable(Map<String, String> table) {
        String prefix = "item.laserio.";
        for (int i = 0; i < Registration.Energy_Overclocker_Cards.size(); ++i) {
            String name = i < ((List)Config.NAME_TIERS.get()).size() ? (String)((List)Config.NAME_TIERS.get()).get(i) : "Energy Overclocker Tier " + (i + 1);
            table.put(prefix + Registration.Energy_Overclocker_Cards.get(i).getId().m_135815_(), name);
        }
    }
}

