/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.FilterCountScreen;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketGhostSlot;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.IMekanismAccess;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class JEIIntegrationUtil {
    public static <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(final AbstractContainerScreen<? extends AbstractContainerMenu> gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (final Slot slot : gui.m_6262_().f_38839_) {
            if (!slot.m_6659_()) continue;
            final Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
            if (ingredient.getIngredient() instanceof ItemStack && slot instanceof FilterBasicSlot) {
                targets.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return bounds;
                    }

                    public void accept(I ingredient) {
                        ItemStack itemStack = (ItemStack)ingredient;
                        slot.m_5852_(gui instanceof CardItemScreen ? itemStack.m_41777_() : itemStack);
                        if (gui instanceof FilterCountScreen) {
                            FilterCountScreen filterCountGui = (FilterCountScreen)gui;
                            ((FilterCountContainer)filterCountGui.m_6262_()).handler.setStackInSlotSave(slot.f_40219_, itemStack);
                        }
                        PacketHandler.sendToServer(new PacketGhostSlot(slot.f_40219_, itemStack, itemStack.m_41613_()));
                    }
                });
                continue;
            }
            if (ingredient.getIngredient() instanceof FluidStack && slot instanceof FilterBasicSlot) {
                targets.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return bounds;
                    }

                    public void accept(I ingredient) {
                        ItemStack itemStack = new ItemStack((ItemLike)((FluidStack)ingredient).getFluid().m_6859_(), 1);
                        slot.m_5852_(itemStack);
                        if (gui instanceof FilterCountScreen) {
                            FilterCountScreen filterCountGui = (FilterCountScreen)gui;
                            ((FilterCountContainer)filterCountGui.m_6262_()).handler.setStackInSlotSave(slot.f_40219_, itemStack);
                        }
                        PacketHandler.sendToServer(new PacketGhostSlot(slot.f_40219_, itemStack, itemStack.m_41613_()));
                    }
                });
                continue;
            }
            if (!MekanismIntegration.isLoaded() || !(ingredient.getIngredient() instanceof ChemicalStack) || !(slot instanceof FilterBasicSlot)) continue;
            targets.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return bounds;
                }

                public void accept(I ingredient) {
                    ItemStack itemStack = ItemStack.f_41583_;
                    if (ingredient instanceof GasStack) {
                        GasStack gasStack = (GasStack)ingredient;
                        itemStack = IMekanismAccess.INSTANCE.jeiHelper().getGasStackHelper().getCheatItemStack((Object)gasStack);
                    } else if (ingredient instanceof SlurryStack) {
                        SlurryStack slurryStack = (SlurryStack)ingredient;
                        itemStack = IMekanismAccess.INSTANCE.jeiHelper().getSlurryStackHelper().getCheatItemStack((Object)slurryStack);
                    } else if (ingredient instanceof PigmentStack) {
                        PigmentStack pigmentStack = (PigmentStack)ingredient;
                        itemStack = IMekanismAccess.INSTANCE.jeiHelper().getPigmentStackHelper().getCheatItemStack((Object)pigmentStack);
                    } else if (ingredient instanceof InfusionStack) {
                        InfusionStack infusionStack = (InfusionStack)ingredient;
                        itemStack = IMekanismAccess.INSTANCE.jeiHelper().getInfusionStackHelper().getCheatItemStack((Object)infusionStack);
                    }
                    slot.m_5852_(itemStack);
                    if (gui instanceof FilterCountScreen) {
                        FilterCountScreen filterCountGui = (FilterCountScreen)gui;
                        ((FilterCountContainer)filterCountGui.m_6262_()).handler.setStackInSlotSave(slot.f_40219_, itemStack);
                    }
                    PacketHandler.sendToServer(new PacketGhostSlot(slot.f_40219_, itemStack, itemStack.m_41613_()));
                }
            });
        }
        return targets;
    }
}

