/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.util.BaseCardCache;
import com.direwolf20.laserio.util.ExtractorCardCache;
import com.direwolf20.laserio.util.InserterCardCache;
import com.direwolf20.laserio.util.ItemStackKey;
import com.direwolf20.laserio.util.TransferResult;
import com.google.common.collect.ArrayListMultimap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerUtil {
    @Nonnull
    public static ExtractResult extractItem(IItemHandler source, @Nonnull ItemStack incstack, boolean simulate, boolean isCompareNBT) {
        return ItemHandlerUtil.extractItem(source, incstack, incstack.m_41613_(), simulate, isCompareNBT);
    }

    @Nonnull
    public static ExtractResult extractItemOnce(IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT) {
        if (source == null || incstack.m_41619_()) {
            return new ExtractResult(incstack, -1);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        ItemStack tempStack = ItemStack.f_41583_;
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amount, stackInSlot.m_41613_());
            tempStack = source.extractItem(i, extractAmt, simulate);
            return new ExtractResult(tempStack, i);
        }
        return new ExtractResult(tempStack, -1);
    }

    @Nonnull
    public static ExtractResult extractItem(IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT) {
        if (source == null || incstack.m_41619_()) {
            return new ExtractResult(incstack, -1);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        ItemStack tempStack = ItemStack.f_41583_;
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amount, stackInSlot.m_41613_());
            if (tempStack.m_41619_()) {
                tempStack = source.extractItem(i, extractAmt, simulate);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)tempStack, (ItemStack)stackInSlot)) {
                tempStack.m_41769_(source.extractItem(i, extractAmt, simulate).m_41613_());
            } else {
                return new ExtractResult(tempStack, i);
            }
            if (tempStack.m_41619_() || (amount -= extractAmt) != 0) continue;
            return new ExtractResult(tempStack, i);
        }
        return new ExtractResult(tempStack, -1);
    }

    @Nonnull
    public static ExtractResult extractItemBackwards(IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT) {
        if (source == null || incstack.m_41619_()) {
            return new ExtractResult(incstack, -1);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        ItemStack tempStack = ItemStack.f_41583_;
        for (int i = source.getSlots() - 1; i >= 0; --i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amount, stackInSlot.m_41613_());
            if (tempStack.m_41619_()) {
                tempStack = source.extractItem(i, extractAmt, simulate);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)tempStack, (ItemStack)stackInSlot)) {
                tempStack.m_41769_(source.extractItem(i, extractAmt, simulate).m_41613_());
            } else {
                return new ExtractResult(tempStack, i);
            }
            if (tempStack.m_41619_() || (amount -= extractAmt) != 0) continue;
            return new ExtractResult(tempStack, i);
        }
        return new ExtractResult(tempStack, -1);
    }

    @Nonnull
    public static TransferResult extractItemWithSlots(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT, BaseCardCache cardCache) {
        TransferResult extractResults = new TransferResult();
        if (source == null || incstack.m_41619_()) {
            return extractResults;
        }
        int amtRemaining = amount;
        ItemStack remainingStack = incstack.m_41777_();
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        for (int i = 0; i < source.getSlots(); ++i) {
            int extractAmt;
            ItemStack extractStack;
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT)) || (extractStack = source.extractItem(i, extractAmt = Math.min(amtRemaining, stackInSlot.m_41613_()), simulate)).m_41619_()) continue;
            extractResults.addResult(new TransferResult.Result(source, i, cardCache, extractStack, be, true));
            remainingStack.m_41764_(amtRemaining -= extractAmt);
            if (amtRemaining != 0) continue;
            return extractResults;
        }
        extractResults.addRemainingStack(remainingStack);
        return extractResults;
    }

    @Nonnull
    public static TransferResult extractItemWithSlotsBackwards(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT, ExtractorCardCache extractorCardCache) {
        TransferResult extractResults = new TransferResult();
        if (source == null || incstack.m_41619_()) {
            return extractResults;
        }
        int amtRemaining = amount;
        ItemStack remainingStack = incstack.m_41777_();
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        for (int i = source.getSlots() - 1; i >= 0; --i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amtRemaining, stackInSlot.m_41613_());
            ItemStack extractStack = source.extractItem(i, extractAmt, simulate);
            extractResults.addResult(new TransferResult.Result(source, i, extractorCardCache, extractStack, be, true));
            remainingStack.m_41764_(amtRemaining -= extractAmt);
            if (amtRemaining != 0) continue;
            return extractResults;
        }
        extractResults.addRemainingStack(remainingStack);
        return extractResults;
    }

    @Nonnull
    public static TransferResult insertItemWithSlots(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int startAt, boolean simulate, boolean isCompareNBT, boolean stacksFirst, InserterCardCache inserterCardCache) {
        return ItemHandlerUtil.insertItemWithSlots(be, source, incstack, incstack.m_41613_(), startAt, simulate, isCompareNBT, stacksFirst, inserterCardCache);
    }

    @Nonnull
    public static TransferResult insertItemWithSlots(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int amount, int startAt, boolean simulate, boolean isCompareNBT, boolean stacksFirst, InserterCardCache inserterCardCache) {
        TransferResult insertResults = new TransferResult();
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        if (source == null || incstack.m_41619_()) {
            return insertResults;
        }
        int amtRemaining = amount;
        ItemStack remainingStack = incstack.m_41777_();
        remainingStack.m_41764_(amtRemaining);
        if (inserterCardCache.filterCard.m_41720_() instanceof FilterCount) {
            int filterCount = inserterCardCache.getFilterAmt(incstack);
            if (filterCount <= 0) {
                return insertResults;
            }
            InventoryCounts inventoryCounts = new InventoryCounts(source, inserterCardCache.isCompareNBT);
            int amtInInv = inventoryCounts.getCount(remainingStack);
            int amtNeeded = filterCount - amtInInv;
            if (amtNeeded <= 0) {
                return insertResults;
            }
            amtRemaining = Math.min(remainingStack.m_41613_(), amtNeeded);
            remainingStack.m_41764_(amtRemaining);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        if (stacksFirst) {
            for (int i = startAt; i < source.getSlots(); ++i) {
                int amtInserted;
                ItemStack stackInSlot = source.getStackInSlot(i);
                if (stackInSlot.m_41619_()) {
                    emptySlots.add(i);
                }
                if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT)) || (amtInserted = amtRemaining - (remainingStack = source.insertItem(i, remainingStack, simulate)).m_41613_()) <= 0) continue;
                insertResults.addResult(new TransferResult.Result(source, i, inserterCardCache, incstack.m_41620_(amtInserted), be, false));
                amtRemaining = remainingStack.m_41613_();
                if (amtRemaining != 0) continue;
                return insertResults;
            }
            for (Integer i : emptySlots) {
                remainingStack = source.insertItem(i.intValue(), remainingStack, simulate);
                if (remainingStack.m_41613_() == amtRemaining) continue;
                insertResults.addResult(new TransferResult.Result(source, i, inserterCardCache, incstack.m_41620_(amtRemaining - remainingStack.m_41613_()), be, false));
                amtRemaining = remainingStack.m_41613_();
                if (amtRemaining != 0) continue;
                return insertResults;
            }
        } else {
            for (int i = 0; i < source.getSlots(); ++i) {
                remainingStack = source.insertItem(i, remainingStack, simulate);
                insertResults.addResult(new TransferResult.Result(source, i, inserterCardCache, incstack.m_41620_(amtRemaining - remainingStack.m_41613_()), be, false));
                amtRemaining = remainingStack.m_41613_();
                if (amtRemaining != 0) continue;
                return insertResults;
            }
        }
        insertResults.addRemainingStack(remainingStack);
        return insertResults;
    }

    public static ItemStack extractIngredient(IItemHandler source, @Nonnull Ingredient ingredient, boolean simulate) {
        if (source == null || ingredient.checkInvalidation()) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!ingredient.test(stackInSlot)) continue;
            ItemStack tempStack = source.extractItem(i, 1, simulate);
            return tempStack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean doItemsMatch(ItemStack a, ItemStack b, boolean isCompareNBT) {
        return isCompareNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) : ItemStack.m_41656_((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.m_41619_() || inSlot.m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public record ExtractResult(ItemStack itemStack, int slot) {
    }

    public static class InventoryCounts {
        private final ArrayListMultimap<Item, ItemStack> itemMap = ArrayListMultimap.create();
        private int totalCount = 0;
        private boolean isCompareNBT;

        public InventoryCounts() {
        }

        public InventoryCounts(IItemHandler handler, boolean compareNBT) {
            this.isCompareNBT = compareNBT;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                this.setCount(stack);
            }
        }

        public InventoryCounts(ListTag nbtList) {
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag nbt = nbtList.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("itemStack"));
                stack.m_41764_(nbt.m_128451_("count"));
                this.setCount(stack);
            }
        }

        public ListTag serialize() {
            ListTag nbtList = new ListTag();
            int i = 0;
            for (ItemStack stack : this.itemMap.values()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("itemStack", (Tag)stack.serializeNBT());
                nbt.m_128405_("count", stack.m_41613_());
                nbtList.add(i, (Tag)nbt);
                ++i;
            }
            return nbtList;
        }

        public void addHandler(IItemHandler handler) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                this.setCount(stack);
            }
        }

        public void addHandlerWithFilter(IItemHandler handler, BaseCardCache filterCard) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_() || !filterCard.isStackValidForCard(stack)) continue;
                this.setCount(stack);
            }
        }

        public ArrayListMultimap<Item, ItemStack> getItemCounts() {
            return this.itemMap;
        }

        public void setCount(ItemStack stack) {
            if (stack.m_41619_()) {
                return;
            }
            for (ItemStack cacheStack : this.itemMap.get((Object)stack.m_41720_())) {
                boolean sameItems = this.isCompareNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)cacheStack, (ItemStack)stack) : ItemStack.m_41656_((ItemStack)cacheStack, (ItemStack)stack);
                if (!sameItems) continue;
                cacheStack.m_41769_(stack.m_41613_());
                this.totalCount += stack.m_41613_();
                return;
            }
            this.itemMap.put((Object)stack.m_41720_(), (Object)stack.m_41777_());
            this.totalCount += stack.m_41613_();
        }

        public ItemStack removeStack(ItemStack stack, int count) {
            ItemStack returnStack = ItemStack.f_41583_;
            for (ItemStack cacheStack : this.itemMap.get((Object)stack.m_41720_())) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)cacheStack, (ItemStack)stack)) continue;
                returnStack = cacheStack.m_41620_(count);
                break;
            }
            if (returnStack.m_41619_()) {
                return returnStack;
            }
            this.itemMap.get((Object)returnStack.m_41720_()).removeIf(o -> o.m_41619_());
            this.totalCount -= returnStack.m_41613_();
            return returnStack;
        }

        public int getCount(ItemStack stack) {
            for (ItemStack cacheStack : this.itemMap.get((Object)stack.m_41720_())) {
                boolean sameItems = this.isCompareNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)cacheStack, (ItemStack)stack) : ItemStack.m_41656_((ItemStack)cacheStack, (ItemStack)stack);
                if (!sameItems) continue;
                return cacheStack.m_41613_();
            }
            return 0;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    public static class InventoryInfo {
        private final NonNullList<ItemStack> inventory;
        private final IntList stackSizes = new IntArrayList();

        public InventoryInfo(IItemHandler handler) {
            this.inventory = NonNullList.m_122780_((int)handler.getSlots(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                this.inventory.set(i, (Object)stack);
                this.stackSizes.add(stack.m_41613_());
            }
        }
    }
}

