/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.CardHolderContainer;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.FilterBasicContainer;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.FilterNBTContainer;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketOpenFilter {
    private int slotNumber;

    public PacketOpenFilter(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static void encode(PacketOpenFilter msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slotNumber);
    }

    public static PacketOpenFilter decode(FriendlyByteBuf buffer) {
        return new PacketOpenFilter(buffer.readInt());
    }

    public static void doOpenFilter(ItemStack filterItem, ItemStack cardItem, ServerPlayer sender, BlockPos sourcePos) {
        FilterBasicHandler handler;
        if (filterItem.m_41720_() instanceof FilterBasic) {
            handler = FilterBasic.getInventory(filterItem);
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterBasicContainer(windowId, playerInventory, (Player)sender, handler, sourcePos, filterItem, cardItem), (Component)Component.m_237115_((String)"")), buf -> {
                buf.m_130055_(filterItem);
                buf.m_130055_(cardItem);
            });
        }
        if (filterItem.m_41720_() instanceof FilterCount) {
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterCountContainer(windowId, playerInventory, (Player)sender, sourcePos, filterItem, cardItem), (Component)Component.m_237115_((String)"")), buf -> {
                buf.m_130055_(filterItem);
                buf.m_130055_(cardItem);
            });
        }
        if (filterItem.m_41720_() instanceof FilterTag) {
            handler = FilterBasic.getInventory(filterItem);
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterTagContainer(windowId, playerInventory, (Player)sender, handler, sourcePos, filterItem, cardItem), (Component)Component.m_237115_((String)"")), buf -> {
                buf.m_130055_(filterItem);
                buf.m_130055_(ItemStack.f_41583_);
            });
        }
        if (filterItem.m_41720_() instanceof FilterNBT) {
            handler = FilterBasic.getInventory(filterItem);
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterNBTContainer(windowId, playerInventory, (Player)sender, handler, sourcePos, filterItem, cardItem), (Component)Component.m_237115_((String)"")), buf -> {
                buf.m_130055_(filterItem);
                buf.m_130055_(ItemStack.f_41583_);
            });
        }
    }

    public static class Handler {
        public static void handle(PacketOpenFilter msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (container == null) {
                    return;
                }
                Slot slot = (Slot)container.f_38839_.get(msg.slotNumber);
                ItemStack itemStack = slot.m_7993_();
                if (container instanceof CardItemContainer) {
                    PacketOpenFilter.doOpenFilter(itemStack, ((CardItemContainer)container).cardItem, sender, ((CardItemContainer)container).sourceContainer);
                } else if (container instanceof CardHolderContainer) {
                    PacketOpenFilter.doOpenFilter(itemStack, ItemStack.f_41583_, sender, BlockPos.f_121853_);
                } else {
                    return;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

