/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketCopyPasteCard {
    int slot;
    boolean copy;

    public PacketCopyPasteCard(int slot, boolean copy) {
        this.slot = slot;
        this.copy = copy;
    }

    public static void encode(PacketCopyPasteCard msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slot);
        buffer.writeBoolean(msg.copy);
    }

    public static PacketCopyPasteCard decode(FriendlyByteBuf buffer) {
        return new PacketCopyPasteCard(buffer.readInt(), buffer.readBoolean());
    }

    public static void playSound(ServerPlayer player, SoundEvent soundEvent) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        ClientboundSoundPacket packet = new ClientboundSoundPacket(Holder.m_205709_((Object)soundEvent), SoundSource.PLAYERS, x, y, z, 1.0f, 1.0f, 1L);
        player.f_8906_.m_9829_((Packet)packet);
    }

    public static int returnItemToHolder(LaserNodeContainer container, ItemStack returnStack, boolean simulate) {
        int returnCount = returnStack.m_41613_();
        if (returnCount == 0) {
            return 0;
        }
        if (container.cardHolder.m_41619_()) {
            return returnCount;
        }
        HashMap<Integer, Integer> returnStackMap = new HashMap<Integer, Integer>();
        for (int returnSlot = 10; returnSlot < 25; ++returnSlot) {
            ItemStack possibleReturnStack = container.m_38853_(returnSlot).m_7993_();
            if (!possibleReturnStack.m_41619_() && (!possibleReturnStack.m_150930_(returnStack.m_41720_()) || possibleReturnStack.m_41613_() >= possibleReturnStack.m_41741_())) continue;
            int roomAvailable = possibleReturnStack.m_41741_() - possibleReturnStack.m_41613_();
            int amtFit = Math.min(returnCount, roomAvailable);
            returnStackMap.put(returnSlot, amtFit);
            if ((returnCount -= amtFit) == 0) break;
        }
        if (simulate) {
            return returnCount;
        }
        for (Map.Entry entry : returnStackMap.entrySet()) {
            ItemStack possibleReturnStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
            if (possibleReturnStack.m_41619_()) {
                container.m_38853_((Integer)entry.getKey()).m_5852_(returnStack);
                possibleReturnStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
                possibleReturnStack.m_41764_(((Integer)entry.getValue()).intValue());
                continue;
            }
            possibleReturnStack.m_41769_(((Integer)entry.getValue()).intValue());
        }
        return returnCount;
    }

    public static boolean getItemFromHolder(LaserNodeContainer container, ItemStack neededStack, boolean simulate) {
        int neededCount = neededStack.m_41613_();
        if (neededCount == 0) {
            return true;
        }
        if (container.cardHolder.m_41619_()) {
            return false;
        }
        HashMap<Integer, Integer> foundStackMap = new HashMap<Integer, Integer>();
        for (int getSlot = 10; getSlot < 25; ++getSlot) {
            ItemStack possibleStack = container.m_38853_(getSlot).m_7993_();
            if (!possibleStack.m_150930_(neededStack.m_41720_())) continue;
            int stackAvailable = possibleStack.m_41613_();
            int amtFound = Math.min(neededCount, stackAvailable);
            foundStackMap.put(getSlot, amtFound);
            if ((neededCount -= amtFound) != 0) continue;
            if (!simulate) break;
            return true;
        }
        if (neededCount > 0) {
            return false;
        }
        for (Map.Entry entry : foundStackMap.entrySet()) {
            ItemStack foundStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
            foundStack.m_41774_(((Integer)entry.getValue()).intValue());
        }
        return true;
    }

    public static class Handler {
        public static void handle(PacketCopyPasteCard msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                AbstractContainerMenu container = player.f_36096_;
                if (container == null) {
                    return;
                }
                if (!(container instanceof LaserNodeContainer)) {
                    return;
                }
                LaserNodeContainer laserNodeContainer = (LaserNodeContainer)container;
                if (player.f_36096_.m_142621_().m_41619_()) {
                    return;
                }
                ItemStack slotStack = container.m_38853_(msg.slot).m_7993_();
                ItemStack clonerStack = container.m_142621_();
                if (msg.copy) {
                    CardCloner.setItemType(clonerStack, slotStack.m_41720_().toString());
                    CompoundTag compoundTag = slotStack.m_41783_() == null ? new CompoundTag() : slotStack.m_41783_();
                    CardCloner.saveSettings(clonerStack, compoundTag);
                    PacketCopyPasteCard.playSound(player, SoundEvents.f_12493_);
                } else {
                    Item slotItem = slotStack.m_41720_();
                    if (slotItem.toString().equals(CardCloner.getItemType(clonerStack))) {
                        ItemStack neededStack;
                        ItemStack filterNeeded = CardCloner.getFilter(clonerStack);
                        ItemStack overclockersNeeded = CardCloner.getOverclocker(clonerStack);
                        ItemStack existingFilter = ItemStack.f_41583_;
                        ItemStack existingOverclockers = ItemStack.f_41583_;
                        if (slotItem instanceof CardEnergy && CardEnergyContainer.SLOTS == 1) {
                            cardItemHandler = CardEnergy.getInventory(slotStack);
                            existingOverclockers = cardItemHandler.getStackInSlot(0);
                        } else if (!(slotItem instanceof CardRedstone)) {
                            cardItemHandler = BaseCard.getInventory(slotStack);
                            existingFilter = cardItemHandler.getStackInSlot(0);
                            existingOverclockers = cardItemHandler.getStackInSlot(1);
                        }
                        boolean filterSatisfied = true;
                        if (!existingFilter.m_150930_(filterNeeded.m_41720_())) {
                            filterSatisfied = PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, filterNeeded, true);
                        }
                        int amtReturn = 0;
                        int amtNeeded = 0;
                        if (!existingOverclockers.m_150930_(overclockersNeeded.m_41720_())) {
                            amtReturn = existingOverclockers.m_41613_();
                            amtNeeded = overclockersNeeded.m_41613_();
                        } else {
                            int amt = existingOverclockers.m_41613_() - overclockersNeeded.m_41613_();
                            if (amt > 0) {
                                amtReturn = amt;
                            } else {
                                amtNeeded = -amt;
                            }
                        }
                        boolean overclockSatisfied = true;
                        if (amtNeeded > 0) {
                            neededStack = new ItemStack((ItemLike)overclockersNeeded.m_41720_(), amtNeeded);
                            overclockSatisfied = PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, neededStack, true);
                        }
                        if (filterSatisfied && overclockSatisfied) {
                            ItemStack returnStack;
                            int remaining;
                            if (!existingFilter.m_150930_(filterNeeded.m_41720_())) {
                                if (PacketCopyPasteCard.returnItemToHolder(laserNodeContainer, existingFilter, false) != 0) {
                                    ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), existingFilter);
                                    player.m_9236_().m_7967_((Entity)itemEntity);
                                }
                                PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, filterNeeded, false);
                            }
                            if (amtReturn > 0 && (remaining = PacketCopyPasteCard.returnItemToHolder(laserNodeContainer, returnStack = new ItemStack((ItemLike)existingOverclockers.m_41720_(), amtReturn), false)) > 0) {
                                returnStack.m_41764_(remaining);
                                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), returnStack);
                                player.m_9236_().m_7967_((Entity)itemEntity);
                            }
                            if (amtNeeded > 0) {
                                neededStack = new ItemStack((ItemLike)overclockersNeeded.m_41720_(), amtNeeded);
                                PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, neededStack, false);
                            }
                            ItemStack tempStack = slotStack.m_41777_();
                            CompoundTag compoundTag = CardCloner.getSettings(clonerStack);
                            if (compoundTag.m_128456_()) {
                                tempStack.m_41751_(null);
                            } else {
                                tempStack.m_41751_(compoundTag.m_6426_());
                            }
                            container.m_38853_(msg.slot).m_5852_(tempStack);
                            PacketCopyPasteCard.playSound(player, SoundEvents.f_11887_);
                            ((LaserNodeContainer)container).tile.updateThisNode();
                        } else {
                            PacketCopyPasteCard.playSound(player, SoundEvents.f_276627_);
                        }
                    } else {
                        PacketCopyPasteCard.playSound(player, SoundEvents.f_276627_);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

