/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.baseblocks.BaseLaserBlock;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class LaserWrench
extends Item {
    public LaserWrench() {
        super(new Item.Properties().m_41487_(1));
    }

    public static DimBlockPos storeConnectionPos(ItemStack wrench, Level level, BlockPos pos) {
        DimBlockPos dimBlockPos = new DimBlockPos(level, pos);
        wrench.m_41784_().m_128365_("connectiondimpos", (Tag)dimBlockPos.toNBT());
        return dimBlockPos;
    }

    public static DimBlockPos getConnectionPos(ItemStack wrench, Level level) {
        CompoundTag compound = wrench.m_41784_();
        if (level == null) {
            return null;
        }
        return !compound.m_128441_("connectiondimpos") ? LaserWrench.storeConnectionPos(wrench, level, BlockPos.f_121853_) : new DimBlockPos(compound.m_128469_("connectiondimpos"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack wrench = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)wrench);
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, (int)((Integer)Config.MAX_INTERACTION_RANGE.get()));
        if ((lookingAt == null || !(level.m_8055_(VectorHelper.getLookingAt(player, wrench, (int)((Integer)Config.MAX_INTERACTION_RANGE.get())).m_82425_()).m_60734_() instanceof BaseLaserBlock)) && player.m_6144_()) {
            LaserWrench.storeConnectionPos(wrench, level, BlockPos.f_121853_);
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        BlockPos targetPos = lookingAt.m_82425_();
        BlockEntity targetBE = level.m_7702_(targetPos);
        if (!(targetBE instanceof BaseLaserBE)) {
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        if (player.m_6144_()) {
            if (targetPos.equals((Object)LaserWrench.getConnectionPos((ItemStack)wrench, (Level)level).blockPos)) {
                LaserWrench.storeConnectionPos(wrench, level, BlockPos.f_121853_);
                return InteractionResultHolder.m_19098_((Object)wrench);
            }
            LaserWrench.storeConnectionPos(wrench, level, targetPos);
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        DimBlockPos sourceDimPos = LaserWrench.getConnectionPos(wrench, level);
        BlockEntity sourceBE = sourceDimPos.getLevel(level.m_7654_()).m_7702_(sourceDimPos.blockPos);
        if (!(sourceBE instanceof BaseLaserBE)) {
            LaserWrench.storeConnectionPos(wrench, level, BlockPos.f_121853_);
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        if (targetBE instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE targetAdv = (LaserConnectorAdvBE)targetBE;
            if (sourceBE instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE sourceAdv = (LaserConnectorAdvBE)sourceBE;
                targetAdv.handleAdvancedConnection(sourceAdv);
                return InteractionResultHolder.m_19090_((Object)wrench);
            }
        }
        if (!targetPos.m_123314_((Vec3i)sourceDimPos.blockPos, (double)((Integer)Config.MAX_NODES_DISTANCE.get()).intValue()) || !level.equals(sourceDimPos.getLevel(level.m_7654_()))) {
            player.m_5661_((Component)Component.m_237110_((String)"message.laserio.wrenchrange", (Object[])new Object[]{Config.MAX_NODES_DISTANCE.get()}), true);
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        ((BaseLaserBE)targetBE).handleConnection((BaseLaserBE)sourceBE);
        return InteractionResultHolder.m_19090_((Object)wrench);
    }
}

