/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.containers.CardHolderContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.util.ItemStackHandlerProvider;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class CardHolder
extends Item {
    public CardHolder() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (level.m_5776_()) {
            if (player.m_6144_()) {
                String translationKey = "message.laserio.card_holder_pulling_" + (CardHolder.getActive(itemStack) ? "disabled" : "enabled");
                player.m_5661_((Component)Component.m_237115_((String)translationKey), true);
                player.m_216990_(SoundEvents.f_11871_);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
        }
        if (player.m_6144_()) {
            CardHolder.setActive(itemStack, !CardHolder.getActive(itemStack));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
        }
        itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(h -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardHolderContainer(windowId, playerInventory, player, itemStack, (IItemHandler)h), (Component)Component.m_237115_((String)"")), buf -> buf.m_130055_(itemStack)));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return CardHolder.getActive(itemStack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemStackHandlerProvider(15);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (!world.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            if (CardHolder.getActive(stack)) {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack cardStack = player.m_150109_().m_8020_(i);
                    if (!(cardStack.m_41720_() instanceof BaseCard) && !(cardStack.m_41720_() instanceof BaseFilter) && !(cardStack.m_41720_() instanceof OverclockerCard) && !(cardStack.m_41720_() instanceof OverclockerNode)) continue;
                    CardHolder.addCardToInventory(stack, cardStack);
                }
            }
        }
    }

    public static ItemStack addCardToInventory(ItemStack cardHolder, ItemStack card) {
        if (card.m_41720_() instanceof BaseFilter && card.m_41782_()) {
            return card;
        }
        IItemHandler handler = (IItemHandler)cardHolder.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse((Object)new ItemStackHandler(15));
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            int maxSize;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                emptySlots.add(i);
            }
            if (stackInSlot.m_41619_() || !ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)card)) continue;
            int j = stackInSlot.m_41613_() + card.m_41613_();
            if (j <= (maxSize = 64)) {
                card.m_41764_(0);
                stackInSlot.m_41764_(j);
            } else if (stackInSlot.m_41613_() < maxSize) {
                card.m_41774_(maxSize - stackInSlot.m_41613_());
                stackInSlot.m_41764_(maxSize);
            }
            if (!card.m_41619_()) continue;
            return card;
        }
        if (emptySlots.isEmpty()) {
            return card;
        }
        handler.insertItem(((Integer)emptySlots.get(0)).intValue(), card.m_41620_(card.m_41613_()), false);
        return card;
    }

    public static UUID getUUID(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128403_("UUID")) {
            UUID newId = UUID.randomUUID();
            nbt.m_128362_("UUID", newId);
            return newId;
        }
        return nbt.m_128342_("UUID");
    }

    public static boolean getActive(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("active")) {
            return false;
        }
        return compound.m_128471_("active");
    }

    public static boolean setActive(ItemStack stack, boolean active) {
        if (!active) {
            stack.m_41749_("active");
        } else {
            stack.m_41784_().m_128379_("active", active);
        }
        return active;
    }
}

