/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.util.MiscTools;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class CardCloner
extends Item {
    public CardCloner() {
        super(new Item.Properties().m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (world == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (!sneakPressed) {
            tooltip.add((Component)Component.m_237115_((String)"laserio.tooltip.item.show_settings").m_130940_(ChatFormatting.GRAY));
        } else {
            String cardType = CardCloner.getItemType(stack);
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.filter.type", ChatFormatting.GRAY.m_126665_());
            int cardColor = ChatFormatting.WHITE.m_126665_();
            boolean isEnergyCard = false;
            boolean isRedstoneCard = false;
            if (cardType.equals("card_item")) {
                cardColor = ChatFormatting.GREEN.m_126665_();
            } else if (cardType.equals("card_fluid")) {
                cardColor = ChatFormatting.BLUE.m_126665_();
            } else if (cardType.equals("card_energy")) {
                cardColor = ChatFormatting.YELLOW.m_126665_();
                isEnergyCard = true;
            } else if (cardType.equals("card_redstone")) {
                cardColor = ChatFormatting.RED.m_126665_();
                isRedstoneCard = true;
            }
            if (cardType.equals("")) {
                toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", cardColor));
            } else {
                toWrite.m_7220_((Component)MiscTools.tooltipMaker("item.laserio." + cardType, cardColor));
            }
            tooltip.add((Component)toWrite);
            if (cardType.equals("")) {
                return;
            }
            CompoundTag compoundTag = stack.m_41784_().m_128469_("settings");
            byte mode = !compoundTag.m_128441_("mode") ? (byte)0 : compoundTag.m_128445_("mode");
            String currentMode = BaseCard.TransferMode.values()[mode].toString();
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.mode", ChatFormatting.GRAY.m_126665_());
            int modeColor = ChatFormatting.GRAY.m_126665_();
            if (currentMode.equals("EXTRACT")) {
                modeColor = ChatFormatting.RED.m_126665_();
            } else if (currentMode.equals("INSERT")) {
                modeColor = ChatFormatting.GREEN.m_126665_();
            } else if (currentMode.equals("STOCK")) {
                modeColor = ChatFormatting.BLUE.m_126665_();
            } else if (currentMode.equals("SENSOR")) {
                modeColor = ChatFormatting.YELLOW.m_126665_();
            }
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.mode." + currentMode, modeColor));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.channel", ChatFormatting.GRAY.m_126665_());
            byte channel = !compoundTag.m_128441_("channel") ? (byte)0 : compoundTag.m_128445_("channel");
            toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(channel), LaserNodeBERender.colors[channel].getRGB()));
            tooltip.add((Component)toWrite);
            if (isRedstoneCard) {
                return;
            }
            if (!isEnergyCard) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.Filter", ChatFormatting.GRAY.m_126665_());
                ItemStack filterStack = CardCloner.getFilter(stack);
                if (filterStack.m_41619_()) {
                    toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", ChatFormatting.WHITE.m_126665_()));
                } else {
                    toWrite.m_7220_((Component)MiscTools.tooltipMaker("item.laserio." + filterStack.m_41720_(), ChatFormatting.DARK_AQUA.m_126665_()));
                }
                tooltip.add((Component)toWrite);
            }
            if (!isEnergyCard || isEnergyCard && CardEnergyContainer.SLOTS == 1) {
                ItemStack overclockerStack = CardCloner.getOverclocker(stack);
                if (isEnergyCard) {
                    toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.Overclocker", ChatFormatting.GRAY.m_126665_());
                    if (overclockerStack.m_41619_()) {
                        toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", ChatFormatting.WHITE.m_126665_()));
                    } else {
                        toWrite.m_7220_((Component)MiscTools.tooltipMaker("item.laserio." + overclockerStack.m_41720_(), ChatFormatting.DARK_AQUA.m_126665_()));
                    }
                } else {
                    toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.Overclockers", ChatFormatting.GRAY.m_126665_());
                    if (overclockerStack.m_41619_()) {
                        toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(0), ChatFormatting.WHITE.m_126665_()));
                    } else {
                        toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(overclockerStack.m_41613_()), ChatFormatting.DARK_AQUA.m_126665_()));
                    }
                }
                tooltip.add((Component)toWrite);
            }
        }
    }

    public static void setItemType(ItemStack stack, String itemType) {
        stack.m_41784_().m_128359_("itemType", itemType);
    }

    public static String getItemType(ItemStack stack) {
        return stack.m_41784_().m_128461_("itemType");
    }

    public static void saveSettings(ItemStack stack, CompoundTag tag) {
        stack.m_41784_().m_128365_("settings", (Tag)tag);
    }

    public static CompoundTag getSettings(ItemStack stack) {
        return stack.m_41784_().m_128469_("settings");
    }

    public static ItemStack getFilter(ItemStack stack) {
        String cardType = CardCloner.getItemType(stack);
        CompoundTag compoundTag = CardCloner.getSettings(stack);
        ItemStack filterStack = ItemStack.f_41583_;
        if (!cardType.equals("card_energy") && !cardType.equals("card_redstone")) {
            ItemStackHandler itemStackHandler = new ItemStackHandler(2);
            itemStackHandler.deserializeNBT(compoundTag.m_128469_("inv"));
            filterStack = itemStackHandler.getStackInSlot(0);
        }
        return filterStack;
    }

    public static ItemStack getOverclocker(ItemStack stack) {
        String cardType = CardCloner.getItemType(stack);
        CompoundTag compoundTag = CardCloner.getSettings(stack);
        ItemStack overclockStack = ItemStack.f_41583_;
        if (cardType.equals("card_energy")) {
            if (CardEnergyContainer.SLOTS == 1) {
                ItemStackHandler itemStackHandler = new ItemStackHandler(CardEnergyContainer.SLOTS);
                itemStackHandler.deserializeNBT(compoundTag.m_128469_("inv"));
                overclockStack = itemStackHandler.getStackInSlot(0);
            }
        } else if (!cardType.equals("card_redstone")) {
            ItemStackHandler itemStackHandler = new ItemStackHandler(2);
            itemStackHandler.deserializeNBT(compoundTag.m_128469_("inv"));
            overclockStack = itemStackHandler.getStackInSlot(1);
        }
        return overclockStack;
    }
}

