/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserNodeSettingsScreen;
import com.direwolf20.laserio.client.screens.widgets.IconButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.LaserNodeSlot;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketCopyPasteCard;
import com.direwolf20.laserio.common.network.packets.PacketOpenCard;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketToggleParticles;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.Vec2i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class LaserNodeScreen
extends AbstractContainerScreen<LaserNodeContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/laser_node.png");
    protected final LaserNodeContainer container;
    private boolean showCardHolderUI;
    private boolean currentParticles;
    Button settingsButton;
    Button particlesButton;
    private final MutableComponent[] sides = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.down"), Component.m_237115_((String)"screen.laserio.up"), Component.m_237115_((String)"screen.laserio.north"), Component.m_237115_((String)"screen.laserio.south"), Component.m_237115_((String)"screen.laserio.west"), Component.m_237115_((String)"screen.laserio.east")};
    private final Vec2i[] tabs = new Vec2i[]{new Vec2i(34, 4), new Vec2i(6, 4), new Vec2i(62, 4), new Vec2i(90, 4), new Vec2i(118, 4), new Vec2i(146, 4)};

    public LaserNodeScreen(LaserNodeContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.f_97727_ = 181;
        this.showCardHolderUI = !container.cardHolder.m_41619_();
        this.currentParticles = container.tile.getShowParticles();
    }

    public void m_7856_() {
        super.m_7856_();
        ArrayList<Button> leftWidgets = new ArrayList<Button>();
        ResourceLocation settings = new ResourceLocation("laserio", "textures/gui/buttons/settings.png");
        this.settingsButton = new IconButton(this.getGuiLeft() + 155, this.getGuiTop() + 25, 16, 16, settings, button -> Minecraft.m_91087_().m_91152_((Screen)new LaserNodeSettingsScreen(this.container, (Component)Component.m_237115_((String)"screen.laserio.settings"))));
        leftWidgets.add(this.settingsButton);
        ResourceLocation[] regulateTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/regulatefalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/regulatetrue.png")};
        this.particlesButton = new ToggleButton(this.getGuiLeft() + 155, this.getGuiTop() + 45, 16, 16, regulateTextures, this.currentParticles ? 1 : 0, button -> {
            this.currentParticles = !this.currentParticles;
            ((ToggleButton)button).setTexturePosition(this.currentParticles ? 1 : 0);
            PacketHandler.sendToServer(new PacketToggleParticles(this.currentParticles));
        });
        leftWidgets.add(this.particlesButton);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.m_142416_((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (this.showCardHolderUI) {
            return mouseX < (double)guiLeftIn - 100.0 || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.f_97726_) || mouseY >= (double)(guiTopIn + this.f_97727_);
        }
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.toggleHolderSlots();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.particlesButton.m_252754_(), this.particlesButton.m_252907_(), this.particlesButton.m_5711_(), this.particlesButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[4];
            translatableComponents[0] = Component.m_237115_((String)"screen.laserio.showparticles");
            translatableComponents[1] = Component.m_237115_((String)"screen.laserio.hideparticles");
            guiGraphics.m_280557_(this.f_96547_, (Component)(this.currentParticles ? translatableComponents[0] : translatableComponents[1]), mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280509_(this.tabs[this.container.side].x + 2, this.tabs[this.container.side].y + 2, this.tabs[this.container.side].x + 22, this.tabs[this.container.side].y + 14, -3750202);
        guiGraphics.m_280509_(this.tabs[this.container.side].x, this.tabs[this.container.side].y + 11, this.tabs[this.container.side].x + 2, this.tabs[this.container.side].y + 12, -1);
        guiGraphics.m_280509_(this.tabs[this.container.side].x + 22, this.tabs[this.container.side].y + 11, this.tabs[this.container.side].x + 24, this.tabs[this.container.side].y + 12, -1);
        guiGraphics.m_280056_(this.f_96547_, this.sides[this.container.side].getString(), this.f_97726_ / 2 - this.f_96547_.m_92895_(this.sides[this.container.side].getString()) / 2, 20, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280056_(this.f_96547_, "U", 15, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280056_(this.f_96547_, "D", 43, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280056_(this.f_96547_, "N", 71, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280056_(this.f_96547_, "S", 99, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280056_(this.f_96547_, "W", 128, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280056_(this.f_96547_, "E", 155, 7, Color.DARK_GRAY.getRGB(), false);
        for (Direction direction : Direction.values()) {
            ItemStack itemStack = this.getAdjacentBlock(direction);
            if (itemStack.m_41619_()) continue;
            guiGraphics.m_280256_(itemStack, this.tabs[direction.ordinal()].x + 4, this.tabs[direction.ordinal()].y - 14, 0);
            if (!MiscTools.inBounds(this.getGuiLeft() + this.tabs[direction.ordinal()].x + 4, this.getGuiTop() + this.tabs[direction.ordinal()].y - 14, 16, 16, mouseX, mouseY)) continue;
            guiGraphics.m_280153_(this.f_96547_, itemStack, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    protected ItemStack getAdjacentBlock(Direction direction) {
        BlockState blockState = this.container.playerEntity.m_9236_().m_8055_(this.container.tile.m_58899_().m_121945_(direction));
        ItemStack itemStack = blockState.m_60734_().m_5456_().m_7968_();
        return itemStack;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        if (this.showCardHolderUI) {
            ResourceLocation CardHolderGUI = new ResourceLocation("laserio", "textures/gui/cardholder_node.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CardHolderGUI);
            guiGraphics.m_280218_(CardHolderGUI, this.getGuiLeft() - 100, this.getGuiTop() + 24, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    public void toggleHolderSlots() {
        for (int i = 9; i < 24; ++i) {
            Slot slot;
            if (i >= this.container.f_38839_.size() || !((slot = this.container.m_38853_(i)) instanceof CardHolderSlot)) continue;
            ((CardHolderSlot)slot).setEnabled(this.showCardHolderUI);
        }
    }

    public boolean m_6375_(double x, double y, int btn) {
        if (this.f_97734_ != null && this.container.m_142621_().m_41720_() instanceof CardCloner) {
            if (this.f_97734_ instanceof LaserNodeSlot && !this.f_97734_.m_7993_().m_41619_()) {
                if (btn == 0) {
                    PacketHandler.sendToServer(new PacketCopyPasteCard(this.f_97734_.getSlotIndex(), true));
                } else if (btn == 1) {
                    PacketHandler.sendToServer(new PacketCopyPasteCard(this.f_97734_.getSlotIndex(), false));
                }
            }
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[1].x, this.getGuiTop() + this.tabs[1].y, 24, 12, x, y) && this.container.side != 1) {
            PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), 1));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[0].x, this.getGuiTop() + this.tabs[0].y, 24, 12, x, y) && this.container.side != 0) {
            PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), 0));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[2].x, this.getGuiTop() + this.tabs[2].y, 24, 12, x, y) && this.container.side != 2) {
            PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), 2));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[3].x, this.getGuiTop() + this.tabs[3].y, 24, 12, x, y) && this.container.side != 3) {
            PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), 3));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[4].x, this.getGuiTop() + this.tabs[4].y, 24, 12, x, y) && this.container.side != 4) {
            PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), 4));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[5].x, this.getGuiTop() + this.tabs[5].y, 24, 12, x, y) && this.container.side != 5) {
            PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), 5));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (this.f_97734_ == null || this.f_97734_.m_7993_().m_41619_() || !(this.f_97734_.m_7993_().m_41720_() instanceof BaseCard)) {
            return super.m_6375_(x, y, btn);
        }
        if (btn == 1 && this.f_97734_ instanceof LaserNodeSlot) {
            int slot = this.f_97734_.getSlotIndex();
            PacketHandler.sendToServer(new PacketOpenCard(slot, this.container.tile.m_58899_(), LaserNodeScreen.m_96638_()));
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

