/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateRedstoneCard;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CardRedstoneScreen
extends AbstractContainerScreen<CardRedstoneContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/redstonecard.png");
    protected final CardRedstoneContainer container;
    protected byte currentMode;
    protected byte currentRedstoneChannel;
    protected boolean currentThreshold;
    protected byte currentThresholdLimit;
    protected byte currentThresholdOutput;
    protected boolean currentStrong;
    protected byte currentOutputMode;
    protected byte currentLogicOperation;
    protected byte currentLogicOperationChannel;
    protected final ItemStack card;
    protected Map<String, Button> buttons = new HashMap<String, Button>();

    public CardRedstoneScreen(CardRedstoneContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.m_252754_(), modeButton.m_252907_(), modeButton.m_5711_(), modeButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[3];
            translatableComponents[0] = Component.m_237115_((String)"screen.laserio.input");
            translatableComponents[1] = Component.m_237115_((String)"screen.laserio.output");
            guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (this.currentMode == 0) {
            Button thresholdToggleButton = this.buttons.get("thresholdToggle");
            if (MiscTools.inBounds(thresholdToggleButton.m_252754_(), thresholdToggleButton.m_252907_(), thresholdToggleButton.m_5711_(), thresholdToggleButton.m_93694_(), mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.threshold"), mouseX, mouseY);
            }
            if (this.currentThreshold) {
                Button thresholdOutputButton;
                Button thresholdLimitButton = this.buttons.get("thresholdLimit");
                if (MiscTools.inBounds(thresholdLimitButton.m_252754_(), thresholdLimitButton.m_252907_(), thresholdLimitButton.m_5711_(), thresholdLimitButton.m_93694_(), mouseX, mouseY)) {
                    guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.thresholdlimit"), mouseX, mouseY);
                }
                if (MiscTools.inBounds((thresholdOutputButton = this.buttons.get("thresholdOutput")).m_252754_(), thresholdOutputButton.m_252907_(), thresholdOutputButton.m_5711_(), thresholdOutputButton.m_93694_(), mouseX, mouseY)) {
                    guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.thresholdoutput"), mouseX, mouseY);
                }
            }
        } else {
            Button logicOperationChannelButton;
            Button logicOperationButton;
            Button outputModeButton;
            Button strongButton = this.buttons.get("strong");
            if (MiscTools.inBounds(strongButton.m_252754_(), strongButton.m_252907_(), strongButton.m_5711_(), strongButton.m_93694_(), mouseX, mouseY)) {
                MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.weak"), Component.m_237115_((String)"screen.laserio.strong")};
                guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentStrong ? 1 : 0], mouseX, mouseY);
            }
            if (MiscTools.inBounds((outputModeButton = this.buttons.get("outputMode")).m_252754_(), outputModeButton.m_252907_(), outputModeButton.m_5711_(), outputModeButton.m_93694_(), mouseX, mouseY)) {
                MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.redstone.normal"), Component.m_237115_((String)"screen.laserio.redstone.complementary"), Component.m_237115_((String)"screen.laserio.redstone.not")};
                guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentOutputMode], mouseX, mouseY);
            }
            if (MiscTools.inBounds((logicOperationButton = this.buttons.get("logicOperation")).m_252754_(), logicOperationButton.m_252907_(), logicOperationButton.m_5711_(), logicOperationButton.m_93694_(), mouseX, mouseY)) {
                MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.redstone.nologicoperation"), Component.m_237115_((String)"screen.laserio.redstone.or"), Component.m_237115_((String)"screen.laserio.redstone.and"), Component.m_237115_((String)"screen.laserio.redstone.xor")};
                guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentLogicOperation], mouseX, mouseY);
            }
            if (this.currentLogicOperation != 0 && MiscTools.inBounds((logicOperationChannelButton = this.buttons.get("logicOperationChannel")).m_252754_(), logicOperationChannelButton.m_252907_(), logicOperationChannelButton.m_5711_(), logicOperationChannelButton.m_93694_(), mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentLogicOperationChannel)), mouseX, mouseY);
            }
        }
        Button channelButton = this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneinput.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneoutput.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = CardRedstone.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            this.modeChange();
        }));
    }

    public void addChannelButton() {
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void addThresholdToggleButton() {
        ResourceLocation[] thresholdTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstone_thresholdfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstone_thresholdtrue.png")};
        this.buttons.put("thresholdToggle", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, thresholdTextures, this.currentThreshold ? 1 : 0, button -> {
            this.currentThreshold = !this.currentThreshold;
            ((ToggleButton)button).setTexturePosition(this.currentThreshold ? 1 : 0);
            this.thresholdChange();
        }));
    }

    public void addThresholdLimitButton() {
        this.buttons.put("thresholdLimit", new NumberButton(this.getGuiLeft() + 25, this.getGuiTop() + 25, 16, 16, this.currentThresholdLimit, button -> this.changeThresholdLimit(-1)));
    }

    public void addThresholdOutputButton() {
        this.buttons.put("thresholdOutput", new NumberButton(this.getGuiLeft() + 45, this.getGuiTop() + 25, 16, 16, this.currentThresholdOutput, button -> this.changeThresholdOutput(-1)));
    }

    public void addStrongButton() {
        ResourceLocation[] strongTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("strong", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, strongTextures, this.currentStrong ? 1 : 0, button -> {
            this.currentStrong = !this.currentStrong;
            ((ToggleButton)button).setTexturePosition(this.currentStrong ? 1 : 0);
        }));
    }

    public void addOutputModeButton() {
        ResourceLocation[] outputModeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstone_normal.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstone_complementary.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstone_not.png")};
        this.buttons.put("outputMode", new ToggleButton(this.getGuiLeft() + 155, this.getGuiTop() + 5, 16, 16, outputModeTextures, this.currentOutputMode, button -> {
            this.currentOutputMode = (byte)(this.currentOutputMode == 2 ? 0 : this.currentOutputMode + 1);
            ((ToggleButton)button).setTexturePosition(this.currentOutputMode);
        }));
    }

    public void addLogicOperationButton() {
        ResourceLocation[] logicOperationTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstone_nologicoperation.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstone_or.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstone_and.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstone_xor.png")};
        this.buttons.put("logicOperation", new ToggleButton(this.getGuiLeft() + 155, this.getGuiTop() + 25, 16, 16, logicOperationTextures, this.currentLogicOperation, button -> {
            this.currentLogicOperation = (byte)(this.currentLogicOperation == 3 ? 0 : this.currentLogicOperation + 1);
            ((ToggleButton)button).setTexturePosition(this.currentLogicOperation);
            this.logicOperationChange();
        }));
    }

    public void addLogicOperationChannelButton() {
        this.buttons.put("logicOperationChannel", new ChannelButton(this.getGuiLeft() + 135, this.getGuiTop() + 25, 16, 16, this.currentLogicOperationChannel, button -> {
            this.currentLogicOperationChannel = CardRedstone.nextRedstoneChannelOperation(this.card);
            ((ChannelButton)button).setChannel(this.currentLogicOperationChannel);
        }));
    }

    public void m_7856_() {
        super.m_7856_();
        this.currentMode = CardRedstone.getTransferMode(this.card);
        this.currentRedstoneChannel = CardRedstone.getRedstoneChannel(this.card);
        this.currentThreshold = CardRedstone.getThreshold(this.card);
        this.currentThresholdLimit = CardRedstone.getThresholdLimit(this.card);
        this.currentThresholdOutput = CardRedstone.getThresholdOutput(this.card);
        this.currentStrong = CardRedstone.getStrong(this.card);
        this.currentOutputMode = CardRedstone.getOutputMode(this.card);
        this.currentLogicOperation = CardRedstone.getLogicOperation(this.card);
        this.currentLogicOperationChannel = CardRedstone.getRedstoneChannelOperation(this.card);
        this.addModeButton();
        this.addChannelButton();
        this.addThresholdToggleButton();
        this.addThresholdLimitButton();
        this.addThresholdOutputButton();
        this.addStrongButton();
        this.addOutputModeButton();
        this.addLogicOperationButton();
        this.addLogicOperationChannelButton();
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.m_237113_((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.m_142416_((GuiEventListener)button2.getValue());
        }
        this.modeChange();
    }

    public void modeChange() {
        Button strongButton = this.buttons.get("strong");
        Button outputModeButton = this.buttons.get("outputMode");
        Button thresholdToggleButton = this.buttons.get("thresholdToggle");
        Button thresholdLimitButton = this.buttons.get("thresholdLimit");
        Button thresholdOutputButton = this.buttons.get("thresholdOutput");
        Button logicOperationButton = this.buttons.get("logicOperation");
        Button logicOperationChannelButton = this.buttons.get("logicOperationChannel");
        if (this.currentMode == 0) {
            if (!this.f_169369_.contains(thresholdToggleButton)) {
                this.m_142416_((GuiEventListener)thresholdToggleButton);
            }
            this.m_169411_((GuiEventListener)strongButton);
            this.m_169411_((GuiEventListener)outputModeButton);
            this.m_169411_((GuiEventListener)logicOperationButton);
            this.m_169411_((GuiEventListener)logicOperationChannelButton);
            this.thresholdChange();
        } else {
            if (!this.f_169369_.contains(strongButton)) {
                this.m_142416_((GuiEventListener)strongButton);
            }
            if (!this.f_169369_.contains(outputModeButton)) {
                this.m_142416_((GuiEventListener)outputModeButton);
            }
            if (!this.f_169369_.contains(logicOperationButton)) {
                this.m_142416_((GuiEventListener)logicOperationButton);
            }
            if (!this.f_169369_.contains(logicOperationChannelButton)) {
                this.m_142416_((GuiEventListener)logicOperationChannelButton);
            }
            this.m_169411_((GuiEventListener)thresholdToggleButton);
            this.m_169411_((GuiEventListener)thresholdLimitButton);
            this.m_169411_((GuiEventListener)thresholdOutputButton);
            this.logicOperationChange();
        }
    }

    public void thresholdChange() {
        Button thresholdLimitButton = this.buttons.get("thresholdLimit");
        Button thresholdOutputButton = this.buttons.get("thresholdOutput");
        if (this.currentThreshold) {
            if (!this.f_169369_.contains(thresholdLimitButton)) {
                this.m_142416_((GuiEventListener)thresholdLimitButton);
            }
            if (!this.f_169369_.contains(thresholdOutputButton)) {
                this.m_142416_((GuiEventListener)thresholdOutputButton);
            }
        } else {
            this.m_169411_((GuiEventListener)thresholdLimitButton);
            this.m_169411_((GuiEventListener)thresholdOutputButton);
        }
    }

    public void logicOperationChange() {
        Button logicOperationChannelButton = this.buttons.get("logicOperationChannel");
        if (this.currentLogicOperation != 0) {
            if (!this.f_169369_.contains(logicOperationChannelButton)) {
                this.m_142416_((GuiEventListener)logicOperationChannelButton);
            }
        } else {
            this.m_169411_((GuiEventListener)logicOperationChannelButton);
        }
    }

    public void changeThresholdLimit(int change) {
        if (Screen.m_96638_()) {
            change *= 15;
        }
        this.currentThresholdLimit = change < 0 ? (byte)Math.max(this.currentThresholdLimit + change, 0) : (byte)Math.min(this.currentThresholdLimit + change, 15);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.saveSettings();
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void saveSettings() {
        PacketHandler.sendToServer(new PacketUpdateRedstoneCard(this.currentMode, this.currentRedstoneChannel, this.currentThreshold, this.currentThresholdLimit, this.currentThresholdOutput, this.currentStrong, this.currentOutputMode, this.currentLogicOperation, this.currentLogicOperationChannel));
    }

    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public void changeThresholdOutput(int change) {
        if (Screen.m_96638_()) {
            change *= 15;
        }
        this.currentThresholdOutput = change < 0 ? (byte)Math.max(this.currentThresholdOutput + change, 0) : (byte)Math.min(this.currentThresholdOutput + change, 15);
    }

    public void setThresholdLimit(NumberButton button, int btn) {
        if (btn == 0) {
            this.changeThresholdLimit(1);
        } else if (btn == 1) {
            this.changeThresholdLimit(-1);
        }
        button.setValue(this.currentThresholdLimit);
        button.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void setThresholdOutput(NumberButton button, int btn) {
        if (btn == 0) {
            this.changeThresholdOutput(1);
        } else if (btn == 1) {
            this.changeThresholdOutput(-1);
        }
        button.setValue(this.currentThresholdOutput);
        button.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public boolean m_6375_(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = CardRedstone.previousRedstoneChannel(this.card);
            }
            channelButton.setChannel(this.currentRedstoneChannel);
            channelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        NumberButton thresholdLimitButton = (NumberButton)this.buttons.get("thresholdLimit");
        if (this.currentMode == 0 && this.currentThreshold && MiscTools.inBounds(thresholdLimitButton.m_252754_(), thresholdLimitButton.m_252907_(), thresholdLimitButton.m_5711_(), thresholdLimitButton.m_93694_(), x, y)) {
            this.setThresholdLimit(thresholdLimitButton, btn);
            return true;
        }
        NumberButton thresholdOutputButton = (NumberButton)this.buttons.get("thresholdOutput");
        if (this.currentMode == 0 && this.currentThreshold && MiscTools.inBounds(thresholdOutputButton.m_252754_(), thresholdOutputButton.m_252907_(), thresholdOutputButton.m_5711_(), thresholdOutputButton.m_93694_(), x, y)) {
            this.setThresholdOutput(thresholdOutputButton, btn);
            return true;
        }
        ChannelButton logicOperationChannelButton = (ChannelButton)this.buttons.get("logicOperationChannel");
        if (this.currentMode == 1 && this.currentLogicOperation != 0 && MiscTools.inBounds(logicOperationChannelButton.m_252754_(), logicOperationChannelButton.m_252907_(), logicOperationChannelButton.m_5711_(), logicOperationChannelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentLogicOperationChannel = CardRedstone.nextRedstoneChannelOperation(this.card);
            } else if (btn == 1) {
                this.currentLogicOperationChannel = CardRedstone.previousRedstoneChannelOperation(this.card);
            }
            logicOperationChannelButton.setChannel(this.currentLogicOperationChannel);
            logicOperationChannelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

