/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketGhostSlot;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateCard;
import com.direwolf20.laserio.common.network.packets.PacketUpdateFilter;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.setup.Config;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CardChemicalScreen
extends CardItemScreen {
    public int currentChemicalExtractAmt;
    public final int filterStartX;
    public final int filterStartY;
    public final int filterEndX;
    public final int filterEndY;

    public CardChemicalScreen(CardItemContainer container, Inventory inv, Component name) {
        super(container, inv, name);
        this.filterStartX = 35;
        this.filterStartY = 16;
        this.filterEndX = 125;
        this.filterEndY = 70;
    }

    @Override
    public void m_7856_() {
        this.currentTicks = CardChemical.getExtractSpeed(this.card);
        this.currentChemicalExtractAmt = CardChemical.getChemicalExtractAmt(this.card);
        super.m_7856_();
        this.renderChemicals = true;
    }

    @Override
    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 139, this.getGuiTop() + 25, 32, 12, this.currentMode == 0 ? this.currentPriority : this.currentChemicalExtractAmt, button -> this.changeAmount(-1)));
    }

    @Override
    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/modeinserter.png"), new ResourceLocation("laserio", "textures/gui/buttons/modeextractor.png"), new ResourceLocation("laserio", "textures/gui/buttons/modestocker.png"), new ResourceLocation("laserio", "textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)((Object)((Object)this.buttons.get("amount")))).setValue(this.currentMode == 0 ? this.currentPriority : this.currentChemicalExtractAmt);
            this.modeChange();
        }));
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (((CardItemContainer)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            ItemStack itemStack = this.f_97734_.m_7993_();
            if (this.f_97734_ instanceof FilterBasicSlot) {
                ChemicalStack<?> chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(itemStack);
                if (chemicalStack.isEmpty()) {
                    pGuiGraphics.renderTooltip(this.f_96547_, this.m_280553_(itemStack), itemStack.m_150921_(), itemStack, pX, pY);
                } else {
                    pGuiGraphics.m_280557_(this.f_96547_, chemicalStack.getTextComponent(), pX, pY);
                }
                return;
            }
            pGuiGraphics.renderTooltip(this.f_96547_, this.m_280553_(itemStack), itemStack.m_150921_(), itemStack, pX, pY);
        }
    }

    @Override
    public void changeAmount(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 100;
        }
        if (Screen.m_96639_()) {
            change *= 1000;
        }
        int overclockerCount = this.container.m_38853_(1).m_7993_().m_41613_();
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentChemicalExtractAmt = Math.max(this.currentChemicalExtractAmt + change, 1);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentChemicalExtractAmt = Math.min(this.currentChemicalExtractAmt + change, Math.max(overclockerCount * (Integer)Config.MULTIPLIER_MILLI_BUCKETS_CHEMICAL.get(), (Integer)Config.BASE_MILLI_BUCKETS_CHEMICAL.get()));
        }
    }

    @Override
    public void changeTick(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 100;
        }
        this.currentTicks = change < 0 ? Math.max(this.currentTicks + change, (Integer)((List)Config.MIN_TICKS_CHEMICAL.get()).get(this.container.m_38853_(1).m_7993_().m_41613_())) : Math.min(this.currentTicks + change, 1200);
    }

    @Override
    public boolean filterSlot(int btn, boolean isScrollWheel) {
        int newMBAmt;
        ItemStack slotStack = this.f_97734_.m_7993_();
        if (!MekanismStatics.doesItemStackHoldChemicals(slotStack)) {
            return super.filterSlot(btn, isScrollWheel);
        }
        if (slotStack.m_41619_()) {
            return true;
        }
        if (btn == 2) {
            slotStack.m_41764_(0);
            PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_(), 0));
            return true;
        }
        int amt = btn == 0 ? 1 : -1;
        int filterSlot = this.f_97734_.f_40219_ - 2;
        int currentMBAmt = FilterCount.getSlotAmount(this.filter, filterSlot);
        if (Screen.m_96638_()) {
            amt *= 10;
        }
        if (Screen.m_96637_()) {
            amt *= 100;
        }
        if (Screen.m_96639_()) {
            amt *= 1000;
        }
        if ((newMBAmt = currentMBAmt + amt) > 4096000) {
            newMBAmt = 4096000;
        }
        if (newMBAmt <= 0) {
            newMBAmt = isScrollWheel ? 1 : 0;
        }
        PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_(), newMBAmt));
        return true;
    }

    @Override
    public void setExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeAmount(1);
        } else if (btn == 1) {
            this.changeAmount(-1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : this.currentChemicalExtractAmt);
        amountButton.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    @Override
    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public void saveSettings() {
        if (this.showFilter) {
            PacketHandler.sendToServer(new PacketUpdateFilter(this.isAllowList == 1, this.isCompareNBT == 1));
        }
        PacketHandler.sendToServer(new PacketUpdateCard(this.currentMode, this.currentChannel, this.currentChemicalExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, 0, 0, this.currentRedstoneMode, this.currentRedstoneChannel, this.currentAndMode));
    }

    @Override
    protected void m_6597_(Slot slot, int inventorySlotIndex, int depositedAmount, ClickType clickType) {
        super.m_6597_(slot, inventorySlotIndex, depositedAmount, clickType);
        int newOverclockerCount = this.container.m_38853_(1).m_7993_().m_41613_();
        if (newOverclockerCount == this.lastOverclockerCount) {
            return;
        }
        this.currentChemicalExtractAmt = Math.max(newOverclockerCount * (Integer)Config.MULTIPLIER_MILLI_BUCKETS_CHEMICAL.get(), (Integer)Config.BASE_MILLI_BUCKETS_CHEMICAL.get());
        this.lastOverclockerCount = newOverclockerCount;
        if (this.currentMode != 0) {
            ((NumberButton)((Object)this.buttons.get("amount"))).setValue(this.currentChemicalExtractAmt);
        }
    }
}

