/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.input;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.CPacketKeysPressed;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber(modid="gtceu", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public enum KeyBind {
    VANILLA_JUMP(() -> () -> Minecraft.m_91087_().f_91066_.f_92089_),
    VANILLA_SNEAK(() -> () -> Minecraft.m_91087_().f_91066_.f_92090_),
    VANILLA_FORWARD(() -> () -> Minecraft.m_91087_().f_91066_.f_92085_),
    VANILLA_BACKWARD(() -> () -> Minecraft.m_91087_().f_91066_.f_92087_),
    VANILLA_LEFT(() -> () -> Minecraft.m_91087_().f_91066_.f_92086_),
    VANILLA_RIGHT(() -> () -> Minecraft.m_91087_().f_91066_.f_92088_),
    ARMOR_MODE_SWITCH("gtceu.key.armor_mode_switch", (IKeyConflictContext)KeyConflictContext.IN_GAME, 77),
    ARMOR_HOVER("gtceu.key.armor_hover", (IKeyConflictContext)KeyConflictContext.IN_GAME, 72),
    JETPACK_ENABLE("gtceu.key.enable_jetpack", (IKeyConflictContext)KeyConflictContext.IN_GAME, 71),
    BOOTS_ENABLE("gtceu.key.enable_boots", (IKeyConflictContext)KeyConflictContext.IN_GAME, 46),
    ARMOR_CHARGING("gtceu.key.armor_charging", (IKeyConflictContext)KeyConflictContext.IN_GAME, 78),
    TOOL_AOE_CHANGE("gtceu.key.tool_aoe_change", (IKeyConflictContext)KeyConflictContext.IN_GAME, 86),
    ACTION("gtceu.key.action", (IKeyConflictContext)KeyConflictContext.GUI, 261);

    public static final KeyBind[] VALUES;
    private static double mouseDelta;
    @OnlyIn(value=Dist.CLIENT)
    private Supplier<Supplier<KeyMapping>> keybindingGetter;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keybinding;
    @OnlyIn(value=Dist.CLIENT)
    private boolean isPressed;
    @OnlyIn(value=Dist.CLIENT)
    private boolean isKeyDown;
    private final WeakHashMap<ServerPlayer, MutablePair<Boolean, Boolean>> mapping = new WeakHashMap();

    public static void init() {
        GTCEu.LOGGER.info("Registering KeyBinds");
        if (GTCEu.isClientSide()) {
            MinecraftForge.EVENT_BUS.register(KeyBind.class);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onInputEvent(InputEvent.Key event) {
        ArrayList<KeyBind> updating = new ArrayList<KeyBind>();
        for (KeyBind keybind : VALUES) {
            boolean previousPressed = keybind.isPressed;
            boolean previousKeyDown = keybind.isKeyDown;
            keybind.isPressed = keybind.isPressed();
            keybind.isKeyDown = keybind.isKeyDown();
            if (previousPressed == keybind.isPressed && previousKeyDown == keybind.isKeyDown) continue;
            updating.add(keybind);
        }
        if (!updating.isEmpty()) {
            GTNetwork.NETWORK.sendToServer((IPacket)new CPacketKeysPressed(updating));
        }
    }

    public static void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        Arrays.stream(VALUES).forEach(value -> {
            if (value.keybindingGetter == null) {
                event.register(value.keybinding);
            } else {
                value.keybinding = value.keybindingGetter.get().get();
            }
        });
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        mouseDelta = event.getScrollDelta();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean scrollingUp() {
        return mouseDelta > 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean notScrolling() {
        return mouseDelta == 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean scrollingDown() {
        return mouseDelta < 0.0;
    }

    private KeyBind(Supplier<Supplier<KeyMapping>> keybindingGetter) {
        if (GTCEu.isClientSide()) {
            this.keybindingGetter = keybindingGetter;
        }
    }

    private KeyBind(String langKey, int button) {
        if (GTCEu.isClientSide()) {
            this.keybinding = new KeyMapping(langKey, button, "GregTechCEu");
        }
    }

    private KeyBind(String langKey, IKeyConflictContext ctx, int button) {
        if (GTCEu.isClientSide()) {
            this.keybinding = new KeyMapping(langKey, ctx, InputConstants.Type.KEYSYM, button, "GregTechCEu");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping toMinecraft() {
        return this.keybinding;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isPressed() {
        return this.keybinding.m_90857_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isKeyDown() {
        return this.keybinding.m_90857_();
    }

    public void update(boolean pressed, boolean keyDown, ServerPlayer player) {
        MutablePair<Boolean, Boolean> pair = this.mapping.get(player);
        if (pair == null) {
            this.mapping.put(player, (MutablePair<Boolean, Boolean>)MutablePair.of((Object)pressed, (Object)keyDown));
        } else {
            pair.left = pressed;
            pair.right = keyDown;
        }
    }

    public boolean isPressed(Player player) {
        if (player.m_9236_().f_46443_) {
            return this.isPressed();
        }
        MutablePair<Boolean, Boolean> pair = this.mapping.get((ServerPlayer)player);
        return pair != null && (Boolean)pair.left != false;
    }

    public boolean isKeyDown(Player player) {
        if (player.m_9236_().f_46443_) {
            return this.isKeyDown();
        }
        MutablePair<Boolean, Boolean> pair = this.mapping.get((ServerPlayer)player);
        return pair != null && (Boolean)pair.right != false;
    }

    static {
        VALUES = KeyBind.values();
        mouseDelta = 0.0;
    }
}

