/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.entry.item;

import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemTagList
implements ItemEntryList {
    private final List<ItemTagEntry> entries = new ArrayList<ItemTagEntry>();

    public static ItemTagList of(@NotNull TagKey<Item> tag, int amount, @Nullable CompoundTag nbt) {
        ItemTagList list = new ItemTagList();
        list.add(tag, amount, nbt);
        return list;
    }

    public void add(ItemTagEntry entry) {
        this.entries.add(entry);
    }

    public void add(@NotNull TagKey<Item> tag, int amount, @Nullable CompoundTag nbt) {
        this.add(new ItemTagEntry(tag, amount, nbt));
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.entries.stream().flatMap(ItemTagEntry::stacks).toList();
    }

    private static ItemStack stackWithTag(Holder<Item> holder, int amount, @Nullable CompoundTag nbt) {
        ItemStack stack = new ItemStack((ItemLike)holder.m_203334_(), amount);
        stack.m_41751_(nbt);
        return stack;
    }

    public List<ItemTagEntry> getEntries() {
        return this.entries;
    }

    public record ItemTagEntry(@NotNull TagKey<Item> tag, int amount, @Nullable CompoundTag nbt) {
        public Stream<ItemStack> stacks() {
            return BuiltInRegistries.f_257033_.m_203431_(this.tag).map(HolderSet.ListBacked::m_203614_).orElseGet(Stream::empty).map(holder -> ItemTagList.stackWithTag((Holder<Item>)holder, this.amount, this.nbt));
        }
    }
}

