/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders;

import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import dev.latvian.mods.kubejs.client.LangEventJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class GTRecipeCategoryBuilder
extends BuilderBase<GTRecipeCategory> {
    private final transient String name;
    private transient GTRecipeType recipeType;
    private transient IGuiTexture icon;
    private transient boolean isXEIVisible;
    private transient String langValue;

    public GTRecipeCategoryBuilder(ResourceLocation id) {
        super(id);
        this.name = id.m_135815_();
        this.recipeType = null;
        this.icon = null;
        this.isXEIVisible = true;
        this.langValue = null;
    }

    public GTRecipeCategoryBuilder setCustomIcon(ResourceLocation location) {
        this.icon = new ResourceTexture(location.m_246208_("textures/").m_266382_(".png"));
        return this;
    }

    public GTRecipeCategoryBuilder setItemIcon(ItemStack ... stacks) {
        this.icon = new ItemStackTexture(stacks);
        return this;
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        if (this.langValue != null) {
            lang.add(((GTRecipeCategory)this.value).getLanguageKey(), this.langValue);
        } else {
            lang.add("gtceu", ((GTRecipeCategory)this.value).getLanguageKey(), FormattingUtil.toEnglishName(((GTRecipeCategory)this.value).name));
        }
    }

    @Override
    public GTRecipeCategory register() {
        GTRecipeCategory category = GTRecipeCategories.register(this.name, this.recipeType).setIcon(this.icon).setXEIVisible(this.isXEIVisible);
        this.value = category;
        return this.value;
    }

    public GTRecipeCategoryBuilder recipeType(GTRecipeType recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    public GTRecipeCategoryBuilder icon(IGuiTexture icon) {
        this.icon = icon;
        return this;
    }

    public GTRecipeCategoryBuilder isXEIVisible(boolean isXEIVisible) {
        this.isXEIVisible = isXEIVisible;
        return this;
    }

    public GTRecipeCategoryBuilder langValue(String langValue) {
        this.langValue = langValue;
        return this;
    }
}

