/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.data.chemical.Element;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.SimpleWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.GTRegistry;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.common.unification.material.MaterialRegistryManager;
import com.gregtechceu.gtceu.integration.kjs.GTCEuStartupEvents;
import com.gregtechceu.gtceu.integration.kjs.built.KJSTagPrefix;
import com.gregtechceu.gtceu.integration.kjs.events.GTRegistryEventJS;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class GTRegistryInfo<K, V> {
    public static final Map<ResourceLocation, GTRegistryInfo<?, ?>> MAP = new LinkedHashMap();
    public static final Set<ResourceLocation> EXTRA_IDS = new HashSet<ResourceLocation>();
    public static final Map<ResourceLocation, List<GTRegistryInfo<?, ?>>> POST_AT = new HashMap();
    public static final List<BuilderBase<?>> ALL_BUILDERS = new ArrayList();
    public static final GTRegistryInfo<String, Element> ELEMENT = GTRegistryInfo.add(GTRegistries.ELEMENTS, Element.class);
    public static final GTRegistryInfo<String, Material> MATERIAL = GTRegistryInfo.add(MaterialRegistryManager.getInstance().getRegistry("gtceu"), Material.class);
    public static final GTRegistryInfo<ResourceLocation, GTRecipeType> RECIPE_TYPE = GTRegistryInfo.add(GTRegistries.RECIPE_TYPES, GTRecipeType.class);
    public static final GTRegistryInfo<ResourceLocation, GTRecipeCategory> RECIPE_CATEGORY = GTRegistryInfo.add(GTRegistries.RECIPE_CATEGORIES, GTRecipeCategory.class);
    public static final GTRegistryInfo<ResourceLocation, MachineDefinition> MACHINE = GTRegistryInfo.add(GTRegistries.MACHINES, MachineDefinition.class);
    public static final GTRegistryInfo<String, MaterialIconSet> MATERIAL_ICON_SET = GTRegistryInfo.add(GTCEu.id("material_icon_set"), () -> MaterialIconSet.ICON_SETS, MaterialIconSet.class);
    public static final GTRegistryInfo<String, MaterialIconType> MATERIAL_ICON_TYPE = GTRegistryInfo.add(GTCEu.id("material_icon_type"), () -> MaterialIconType.ICON_TYPES, MaterialIconType.class);
    public static final GTRegistryInfo<String, IWorldGenLayer> WORLD_GEN_LAYER = GTRegistryInfo.add(GTCEu.id("world_gen_layer"), () -> WorldGeneratorUtils.WORLD_GEN_LAYERS, SimpleWorldGenLayer.class);
    public static final GTRegistryInfo<String, TagPrefix> TAG_PREFIX = GTRegistryInfo.add(GTCEu.id("tag_prefix"), () -> TagPrefix.PREFIXES, KJSTagPrefix.class);
    public static final GTRegistryInfo<ResourceLocation, DimensionMarker> DIMENSION_MARKER = GTRegistryInfo.add(GTRegistries.DIMENSION_MARKERS, DimensionMarker.class);
    public final ResourceLocation registryKey;
    public final Class<V> objectBaseClass;
    public final Map<String, BuilderType<V>> types;
    public final Map<ResourceLocation, BuilderBase<? extends V>> objects;
    public final Supplier<Map<K, V>> registryValues;
    private BuilderType<V> defaultType;
    public BuilderBase<? extends V> current;

    private GTRegistryInfo(ResourceLocation key, Supplier<Map<K, V>> registryValues, Class<V> baseClass) {
        this.registryKey = key;
        this.objectBaseClass = baseClass;
        this.types = new LinkedHashMap<String, BuilderType<V>>();
        this.objects = new LinkedHashMap<ResourceLocation, BuilderBase<? extends V>>();
        this.registryValues = registryValues;
        this.current = null;
    }

    public static <K, V> GTRegistryInfo<K, V> add(GTRegistry<K, V> key, Class<?> baseClass) {
        ResourceLocation id = key.getRegistryName();
        GTRegistryInfo<K, V> types = new GTRegistryInfo<K, V>(id, key::registry, (Class)UtilsJS.cast(baseClass));
        if (MAP.put(id, types) != null) {
            throw new IllegalStateException("Registry with id '" + id + "' already exists!");
        }
        POST_AT.computeIfAbsent(key.getRegistryName(), k -> new LinkedList()).add(types);
        return types;
    }

    public static <K, V> GTRegistryInfo<K, V> add(ResourceLocation id, Supplier<Map<K, V>> registryValues, Class<?> baseClass) {
        GTRegistryInfo<K, V> types = new GTRegistryInfo<K, V>(id, registryValues, (Class)UtilsJS.cast(baseClass));
        if (MAP.put(id, types) != null || !EXTRA_IDS.add(id)) {
            throw new IllegalStateException("Registry with id '" + id + "' already exists!");
        }
        POST_AT.computeIfAbsent(id, k -> new LinkedList()).add(types);
        return types;
    }

    public void addType(String type, Class<? extends BuilderBase<? extends V>> builderType, BuilderFactory<V> factory, boolean isDefault) {
        BuilderType<V> b = new BuilderType<V>(type, builderType, factory);
        this.types.put(type, b);
        if (isDefault) {
            if (this.defaultType != null) {
                ConsoleJS.STARTUP.warn((Object)("Previous default type '" + this.defaultType.type + "' for registry '" + this.registryKey + "' replaced with '" + type + "'!"));
            }
            this.defaultType = b;
        }
    }

    public void addBuilder(BuilderBase<? extends V> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + this.registryKey + "'!");
        }
        if (DevProperties.get().debugInfo) {
            ConsoleJS.STARTUP.info((Object)("~ " + this.registryKey + " | " + builder.id));
        }
        if (this.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + builder.id + "' in registry '" + this.registryKey + "'!");
        }
        this.objects.put(builder.id, builder);
        ALL_BUILDERS.add(builder);
    }

    public BuilderType<V> getDefaultType() {
        if (this.types.isEmpty()) {
            return null;
        }
        if (this.defaultType == null) {
            this.defaultType = this.types.values().iterator().next();
        }
        return this.defaultType;
    }

    public void postEvent() {
        GTCEuStartupEvents.REGISTRY.post((ScriptTypeHolder)ScriptType.STARTUP, (Object)this.registryKey, new GTRegistryEventJS(this));
    }

    public static void registerFor(ResourceLocation registry) {
        for (GTRegistryInfo type : POST_AT.getOrDefault(registry, List.of())) {
            type.postEvent();
            for (BuilderBase builder : type.objects.values()) {
                if (DevProperties.get().debugInfo) {
                    ConsoleJS.STARTUP.info((Object)("+ " + registry + " | " + builder.id));
                }
                builder.register();
            }
        }
    }

    public record BuilderType<T>(String type, Class<? extends BuilderBase<? extends T>> builderClass, BuilderFactory<T> factory) {
    }

    @FunctionalInterface
    public static interface BuilderFactory<T> {
        public BuilderBase<? extends T> createBuilder(ResourceLocation var1);
    }
}

