/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine.trait;

import appeng.api.networking.GridFlags;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.utils.SerializableManagedGridNode;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GridNodeHolder
extends MachineTrait {
    protected final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(GridNodeHolder.class);
    @Persisted
    @ReadOnlyManaged(onDirtyMethod="onGridNodeDirty", serializeMethod="serializeGridNode", deserializeMethod="deserializeGridNode")
    protected final SerializableManagedGridNode mainNode = this.createManagedNode();

    public GridNodeHolder(IGridConnectedMachine machine) {
        super(machine.self());
    }

    protected SerializableManagedGridNode createManagedNode() {
        SerializableManagedGridNode node = (SerializableManagedGridNode)new SerializableManagedGridNode((IGridConnectedBlockEntity)this.machine, BlockEntityNodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation((ItemLike)this.machine.getDefinition().getItem()).setIdlePowerUsage(ConfigHolder.INSTANCE.compat.ae2.meHatchEnergyUsage).setInWorldNode(true).setExposedOnSides(this.machine.hasFrontFacing() ? EnumSet.of(this.machine.getFrontFacing()) : EnumSet.allOf(Direction.class)).setTagName("proxy");
        return node;
    }

    protected void createMainNode() {
        this.mainNode.create(this.machine.getLevel(), this.machine.getPos());
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        Level level = this.machine.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::createMainNode));
        }
    }

    @Override
    public void onMachineUnLoad() {
        super.onMachineUnLoad();
        this.mainNode.destroy();
    }

    public ManagedFieldHolder getFieldHolder() {
        return this.MANAGED_FIELD_HOLDER;
    }

    public boolean onGridNodeDirty(SerializableManagedGridNode node) {
        return node != null && node.isActive() && node.isOnline();
    }

    public CompoundTag serializeGridNode(SerializableManagedGridNode node) {
        return node.serializeNBT();
    }

    public SerializableManagedGridNode deserializeGridNode(CompoundTag tag) {
        this.mainNode.deserializeNBT(tag);
        return this.mainNode;
    }

    public SerializableManagedGridNode getMainNode() {
        return this.mainNode;
    }
}

