/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.recipe.ToolHeadReplaceRecipe;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class ToolRecipeHandler {
    public static Map<Integer, ItemEntry<? extends Item>> motorItems = new HashMap<Integer, ItemEntry<? extends Item>>();
    public static Map<Integer, Material> baseMaterials = new HashMap<Integer, Material>();
    public static Map<Integer, List<ItemEntry<? extends Item>>> batteryItems = new HashMap<Integer, List<ItemEntry<? extends Item>>>();
    public static Map<Integer, ItemEntry<? extends Item>> powerUnitItems = new HashMap<Integer, ItemEntry<? extends Item>>();
    private static final Material[] softMaterials = new Material[]{GTMaterials.Wood, GTMaterials.Rubber, GTMaterials.Polyethylene, GTMaterials.Polytetrafluoroethylene, GTMaterials.Polybenzimidazole, GTMaterials.SiliconeRubber, GTMaterials.StyreneButadieneRubber};

    public static void init(Consumer<FinishedRecipe> provider) {
        ToolRecipeHandler.initializeGTItems();
        TagPrefix.plate.executeHandler(provider, PropertyKey.TOOL, ToolRecipeHandler::processTool);
        TagPrefix.plate.executeHandler(provider, PropertyKey.TOOL, ToolRecipeHandler::processElectricTool);
        ToolRecipeHandler.registerPowerUnitRecipes(provider);
        ToolRecipeHandler.registerCustomToolRecipes(provider);
    }

    public static void initializeGTItems() {
        motorItems.put(1, GTItems.ELECTRIC_MOTOR_LV);
        motorItems.put(2, GTItems.ELECTRIC_MOTOR_MV);
        motorItems.put(3, GTItems.ELECTRIC_MOTOR_HV);
        motorItems.put(4, GTItems.ELECTRIC_MOTOR_EV);
        motorItems.put(5, GTItems.ELECTRIC_MOTOR_IV);
        baseMaterials.put(1, GTMaterials.Steel);
        baseMaterials.put(2, GTMaterials.Aluminium);
        baseMaterials.put(3, GTMaterials.StainlessSteel);
        baseMaterials.put(4, GTMaterials.Titanium);
        baseMaterials.put(5, GTMaterials.TungstenSteel);
        powerUnitItems.put(1, GTItems.POWER_UNIT_LV);
        powerUnitItems.put(2, GTItems.POWER_UNIT_MV);
        powerUnitItems.put(3, GTItems.POWER_UNIT_HV);
        powerUnitItems.put(4, GTItems.POWER_UNIT_EV);
        powerUnitItems.put(5, GTItems.POWER_UNIT_IV);
        batteryItems.put(0, Collections.singletonList(GTItems.BATTERY_ULV_TANTALUM));
        batteryItems.put(1, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_LV_LITHIUM, GTItems.BATTERY_LV_CADMIUM, GTItems.BATTERY_LV_SODIUM));
        batteryItems.put(2, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_MV_LITHIUM, GTItems.BATTERY_MV_CADMIUM, GTItems.BATTERY_MV_SODIUM));
        batteryItems.put(3, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_HV_LITHIUM, GTItems.BATTERY_HV_CADMIUM, GTItems.BATTERY_HV_SODIUM, GTItems.ENERGIUM_CRYSTAL));
        batteryItems.put(4, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_EV_VANADIUM, GTItems.LAPOTRON_CRYSTAL));
        batteryItems.put(5, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_IV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB));
        batteryItems.put(6, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_LuV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB_CLUSTER));
        batteryItems.put(7, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_ZPM_NAQUADRIA, GTItems.ENERGY_MODULE));
        batteryItems.put(8, (List<ItemEntry<? extends Item>>)ImmutableList.of(GTItems.BATTERY_UV_NAQUADRIA, GTItems.ENERGY_CLUSTER));
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_MV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_EV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadChainsaw, GTToolType.CHAINSAW_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWrench, GTToolType.WRENCH_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWrench, GTToolType.WRENCH_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWrench, GTToolType.WRENCH_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadBuzzSaw, GTToolType.BUZZSAW);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadScrewdriver, GTToolType.SCREWDRIVER_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWireCutter, GTToolType.WIRE_CUTTER_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWireCutter, GTToolType.WIRE_CUTTER_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWireCutter, GTToolType.WIRE_CUTTER_IV);
    }

    public static void registerPowerUnitRecipes(Consumer<FinishedRecipe> provider) {
        for (int tier : powerUnitItems.keySet()) {
            List<ItemEntry<? extends Item>> tieredBatteryItems = batteryItems.get(tier);
            for (ItemEntry<? extends Item> batteryItem : tieredBatteryItems) {
                if (powerUnitItems.get(tier) == null) continue;
                ItemStack batteryStack = batteryItem.asStack();
                long maxCharge = GTCapabilityHelper.getElectricItem(batteryStack).getMaxCharge();
                ItemStack powerUnitStack = ToolItemHelper.getMaxChargeOverrideStack((Item)powerUnitItems.get(tier).get(), maxCharge);
                String recipeName = String.format("%s_%s", BuiltInRegistries.f_257033_.m_7981_((Object)((Item)powerUnitItems.get(tier).get())).m_135815_(), BuiltInRegistries.f_257033_.m_7981_((Object)((Item)batteryItem.get())).m_135815_());
                VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, recipeName, Ingredient.m_43927_((ItemStack[])new ItemStack[]{batteryStack}), powerUnitStack, "S d", "GMG", "PBP", Character.valueOf('M'), motorItems.get(tier).asStack(), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, baseMaterials.get(tier)), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, baseMaterials.get(tier)), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, baseMaterials.get(tier)), Character.valueOf('B'), batteryStack);
            }
        }
    }

    private static void processTool(TagPrefix prefix, Material material, ToolProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        UnificationEntry plate = new UnificationEntry(TagPrefix.plate, material);
        UnificationEntry ingot = new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material);
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MINING_HAMMER, true, "PPf", "PPS", "PPh", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SPADE, false, "fPh", "PSP", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SAW, false, "PPS", "fhS", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.AXE, false, "PIh", "PS ", "fS ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HOE, false, "PIh", "fS ", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.PICKAXE, false, "PII", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCYTHE, false, "PPI", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SHOVEL, false, "fPh", " S ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SWORD, false, " P ", "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HARD_HAMMER, true, "II ", "IIS", "II ", Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.FILE, true, " P ", " P ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.KNIFE, false, "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WRENCH, false, "PhP", " P ", " P ", Character.valueOf('P'), plate);
        } else {
            GTCEu.LOGGER.info("Did not find plate for " + material.getName() + ", skipping mining hammer, spade, saw, axe, hoe, pickaxe, scythe, shovel, sword, hammer, file, knife, wrench recipes");
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            UnificationEntry rod = new UnificationEntry(TagPrefix.rod, material);
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.BUTCHERY_KNIFE, false, "PPf", "PP ", "Sh ", Character.valueOf('P'), plate, Character.valueOf('S'), rod);
                if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
                    ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WIRE_CUTTER, false, "PfP", "hPd", "STS", Character.valueOf('P'), plate, Character.valueOf('T'), new UnificationEntry(TagPrefix.screw, material), Character.valueOf('S'), rod);
                } else if (!ArrayUtils.contains((Object[])softMaterials, (Object)material)) {
                    GTCEu.LOGGER.info("Did not find bolt for " + material.getName() + ", skipping wirecutter recipe");
                }
            } else {
                GTCEu.LOGGER.info("Did not find plate for " + material.getName() + ", skipping wirecutter, butchery knife recipes");
            }
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCREWDRIVER, true, " fS", " Sh", "W  ", Character.valueOf('S'), rod, Character.valueOf('W'), stick);
            ToolRecipeHandler.addDyeableToolRecipe(provider, material, GTToolType.CROWBAR, true, "hDS", "DSD", "SDf", Character.valueOf('S'), rod);
        } else if (!ArrayUtils.contains((Object[])softMaterials, (Object)material)) {
            GTCEu.LOGGER.info("Did not find rod for " + material.getName() + ", skipping wirecutter, butchery knife, screwdriver, crowbar recipes");
        }
    }

    private static void processElectricTool(TagPrefix prefix, Material material, ToolProperty property, Consumer<FinishedRecipe> provider) {
        TagPrefix toolPrefix;
        int voltageMultiplier;
        int n = voltageMultiplier = material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            UnificationEntry plate = new UnificationEntry(TagPrefix.plate, material);
            UnificationEntry steelPlate = new UnificationEntry(TagPrefix.plate, GTMaterials.Steel);
            UnificationEntry steelRing = new UnificationEntry(TagPrefix.ring, GTMaterials.Steel);
            if (property.hasType(GTToolType.DRILL_LV)) {
                toolPrefix = TagPrefix.toolHeadDrill;
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("drill_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "XSX", "XSX", "ShS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate);
                ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new GTToolType[]{GTToolType.DRILL_LV, GTToolType.DRILL_MV, GTToolType.DRILL_HV, GTToolType.DRILL_EV, GTToolType.DRILL_IV}, provider);
            }
            if (property.hasType(GTToolType.CHAINSAW_LV)) {
                toolPrefix = TagPrefix.toolHeadChainsaw;
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("chainsaw_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "SRS", "XhX", "SRS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate, Character.valueOf('R'), steelRing);
                ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new GTToolType[]{GTToolType.CHAINSAW_LV}, provider);
            }
            if (property.hasType(GTToolType.WRENCH_LV)) {
                toolPrefix = TagPrefix.toolHeadWrench;
                ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new GTToolType[]{GTToolType.WRENCH_LV, GTToolType.WRENCH_HV, GTToolType.WRENCH_IV}, provider);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("wrench_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "hXW", "XRX", "WXd", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('W'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel));
            }
            if (property.hasType(GTToolType.WIRE_CUTTER_LV)) {
                toolPrefix = TagPrefix.toolHeadWireCutter;
                ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new GTToolType[]{GTToolType.WIRE_CUTTER_LV, GTToolType.WIRE_CUTTER_HV, GTToolType.WIRE_CUTTER_IV}, provider);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("wirecutter_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "XfX", "X X", "SRS", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel));
            }
            if (property.hasType(GTToolType.BUZZSAW)) {
                toolPrefix = TagPrefix.toolHeadBuzzSaw;
                ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new GTToolType[]{GTToolType.BUZZSAW}, provider);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("buzzsaw_blade_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "sXh", "X X", "fXx", Character.valueOf('X'), plate);
                if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                    GTRecipeTypes.LATHE_RECIPES.recipeBuilder("buzzsaw_gear_" + material.getName(), new Object[0]).inputItems(TagPrefix.gear, material).outputItems(toolPrefix, material).duration((int)material.getMass() * 4).EUt(8L * (long)voltageMultiplier).save(provider);
                } else {
                    GTCEu.LOGGER.info("Did not find gear for " + material.getName() + ", skipping gear -> buzzsaw blade recipe");
                }
            }
        } else {
            GTCEu.LOGGER.info("Did not find plate for " + material.getName() + ", skipping electric drill, chainsaw, wrench, wirecutter, buzzsaw recipe");
        }
        if (property.hasType(GTToolType.SCREWDRIVER_LV)) {
            if (material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
                toolPrefix = TagPrefix.toolHeadScrewdriver;
                ToolRecipeHandler.addElectricToolRecipe(toolPrefix, material, new GTToolType[]{GTToolType.SCREWDRIVER_LV}, provider);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("screwdriver_tip_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "fR", " h", Character.valueOf('R'), new UnificationEntry(TagPrefix.rodLong, material));
            } else {
                GTCEu.LOGGER.info("Did not find long rod for " + material.getName() + ", skipping electric screwdriver recipe");
            }
        }
    }

    public static void addElectricToolRecipe(TagPrefix toolHead, Material material, GTToolType[] toolItems, Consumer<FinishedRecipe> provider) {
        for (GTToolType toolType : toolItems) {
            if (!material.getProperty(PropertyKey.TOOL).hasType(toolType)) continue;
            int tier = toolType.electricTier;
            ItemStack powerUnitStack = powerUnitItems.get(tier).asStack();
            IElectricItem powerUnit = GTCapabilityHelper.getElectricItem(powerUnitStack);
            ItemStack tool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType)).get()).get(0L, powerUnit.getMaxCharge());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, true, true, String.format("%s_%s", material.getName(), toolType.name), Ingredient.m_43927_((ItemStack[])new ItemStack[]{powerUnitStack}), tool, "wHd", " U ", Character.valueOf('H'), new UnificationEntry(toolHead, material), Character.valueOf('U'), powerUnitStack);
        }
    }

    public static void addToolRecipe(Consumer<FinishedRecipe> provider, @NotNull Material material, @NotNull GTToolType tool, boolean mirrored, Object ... recipe) {
        ItemStack toolStack = ToolHelper.get(tool, material);
        if (toolStack.m_41619_()) {
            return;
        }
        if (mirrored) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material.getName()), toolStack, recipe);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material.getName()), toolStack, recipe);
        }
    }

    public static void addDyeableToolRecipe(Consumer<FinishedRecipe> provider, @NotNull Material material, @NotNull GTToolType tool, boolean mirrored, Object ... recipe) {
        ItemStack toolStack = ToolHelper.get(tool, material);
        if (toolStack.m_41619_()) {
            return;
        }
        for (Map.Entry color : MarkerMaterials.Color.COLORS.entrySet()) {
            ToolHelper.getToolTag(toolStack).m_128405_("TintColor", ((DyeColor)color.getKey()).m_41071_());
            Object[] recipeWithDye = ArrayUtils.addAll((Object[])recipe, (Object[])new Object[]{Character.valueOf('D'), new UnificationEntry(TagPrefix.dye, (Material)color.getValue())});
            if (mirrored) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s_%s", tool.name, material.getName(), ((DyeColor)color.getKey()).m_7912_()), toolStack, recipeWithDye);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s_%s", tool.name, material.getName(), ((DyeColor)color.getKey()).m_7912_()), toolStack, recipeWithDye);
        }
    }

    public static void registerCustomToolRecipes(Consumer<FinishedRecipe> provider) {
        ToolRecipeHandler.registerFlintToolRecipes(provider);
        ToolRecipeHandler.registerMortarRecipes(provider);
        ToolRecipeHandler.registerSoftToolRecipes(provider);
        ToolRecipeHandler.registerElectricRecipes(provider);
        SpecialRecipeBuilder.m_245676_(ToolHeadReplaceRecipe.SERIALIZER).m_126359_(provider, "gtceu:crafting/replace_tool_head");
    }

    private static void registerFlintToolRecipes(Consumer<FinishedRecipe> provider) {
        UnificationEntry flint = new UnificationEntry(TagPrefix.gem, GTMaterials.Flint);
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), flint, Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SWORD, false, "I", "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.PICKAXE, false, "III", " S ", " S ", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SHOVEL, false, "I", "S", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.AXE, true, "II", "IS", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.HOE, true, "II", " S", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.KNIFE, false, "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
    }

    private static void registerMortarRecipes(Consumer<FinishedRecipe> provider) {
        for (Material material : new Material[]{GTMaterials.Bronze, GTMaterials.Iron, GTMaterials.Invar, GTMaterials.Steel, GTMaterials.DamascusSteel, GTMaterials.CobaltBrass, GTMaterials.WroughtIron}) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
        }
    }

    private static void registerSoftToolRecipes(Consumer<FinishedRecipe> provider) {
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        for (int i = 0; i < softMaterials.length; ++i) {
            Material material = softMaterials[i];
            if (material.hasProperty(PropertyKey.WOOD)) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material.getName()), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), ItemTags.f_13168_, Character.valueOf('S'), stick);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material.getName()), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), new UnificationEntry(TagPrefix.ingot, material), Character.valueOf('S'), stick);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("plunger_%s", material.getName()), ToolHelper.getAndSetToolData(GTToolType.PLUNGER, material, 128 * (i << 1), 1, 4.0f, 0.0f), "xPP", " SP", "S f", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), TagPrefix.rod);
        }
    }

    private static void registerElectricRecipes(Consumer<FinishedRecipe> provider) {
        for (ItemEntry<? extends Item> batteryItem : batteryItems.get(1)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_lv_" + batteryItem.getId().m_135815_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PROSPECTOR_LV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('S'), GTItems.SENSOR_LV.asStack(), Character.valueOf('D'), new UnificationEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('C'), CustomTags.LV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "lv_magnet_" + batteryItem.getId().m_135815_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), GTItems.ITEM_MAGNET_LV.asStack(), "MwM", "MBM", "CPC", Character.valueOf('M'), new UnificationEntry(TagPrefix.rod, GTMaterials.SteelMagnetic), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('C'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Tin), Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry<? extends Item> batteryItem : batteryItems.get(2)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "portable_scanner_" + batteryItem.getId().m_135815_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PORTABLE_SCANNER.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_MV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Aluminium), Character.valueOf('S'), GTItems.SENSOR_MV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.MV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry<? extends Item> batteryItem : batteryItems.get(3)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_hv_" + batteryItem.getId().m_135815_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PROSPECTOR_HV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_HV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('S'), GTItems.SENSOR_HV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.HV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "hv_magnet_" + batteryItem.getId().m_135815_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), GTItems.ITEM_MAGNET_HV.asStack(), "MwM", "MBM", "CPC", Character.valueOf('M'), new UnificationEntry(TagPrefix.rod, GTMaterials.NeodymiumMagnetic), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('C'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Gold), Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry<? extends Item> batteryItem : batteryItems.get(6)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_luv_" + batteryItem.getId().m_135815_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PROSPECTOR_LuV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LuV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium), Character.valueOf('S'), GTItems.SENSOR_LuV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.LuV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
    }
}

