/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.pack;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTDynamicResourcePack
implements PackResources {
    protected static final ObjectSet<String> CLIENT_DOMAINS = new ObjectOpenHashSet();
    @ApiStatus.Internal
    public static final ConcurrentMap<ResourceLocation, byte[]> DATA = new ConcurrentHashMap<ResourceLocation, byte[]>();
    private final String name;

    public GTDynamicResourcePack(String name) {
        this(name, AddonFinder.getAddons().stream().map(IGTAddon::addonModId).collect(Collectors.toSet()));
    }

    public GTDynamicResourcePack(String name, Collection<String> domains) {
        this.name = name;
        CLIENT_DOMAINS.addAll(domains);
    }

    public static void clearClient() {
        DATA.clear();
    }

    public static void addBlockModel(ResourceLocation loc, JsonElement obj) {
        ResourceLocation l = GTDynamicResourcePack.getModelLocation(loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, obj);
        }
        DATA.put(l, obj.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addBlockModel(ResourceLocation loc, Supplier<JsonElement> obj) {
        GTDynamicResourcePack.addBlockModel(loc, obj.get());
    }

    public static void addItemModel(ResourceLocation loc, JsonElement obj) {
        ResourceLocation l = GTDynamicResourcePack.getItemModelLocation(loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, obj);
        }
        DATA.put(l, obj.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addItemModel(ResourceLocation loc, Supplier<JsonElement> obj) {
        GTDynamicResourcePack.addItemModel(loc, obj.get());
    }

    public static void addBlockState(ResourceLocation loc, JsonElement stateJson) {
        ResourceLocation l = GTDynamicResourcePack.getBlockStateLocation(loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, stateJson);
        }
        DATA.put(l, stateJson.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addBlockState(ResourceLocation loc, Supplier<JsonElement> generator) {
        GTDynamicResourcePack.addBlockState(loc, generator.get());
    }

    public static void addBlockTexture(ResourceLocation loc, byte[] data) {
        ResourceLocation l = GTDynamicResourcePack.getTextureLocation("block", loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicResourcePack.writeByteArray(l, null, parent, data);
        }
        DATA.put(l, data);
    }

    public static void addItemTexture(ResourceLocation loc, byte[] data) {
        ResourceLocation l = GTDynamicResourcePack.getTextureLocation("item", loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicResourcePack.writeByteArray(l, null, parent, data);
        }
        DATA.put(l, data);
    }

    @ApiStatus.Internal
    public static void writeByteArray(ResourceLocation id, @Nullable String subdir, Path parent, byte[] data) {
        try {
            Path file = subdir != null ? parent.resolve(id.m_135827_()).resolve(subdir).resolve(id.m_135815_() + ".png") : parent.resolve(id.m_135827_()).resolve(id.m_135815_());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (type == PackType.CLIENT_RESOURCES && DATA.containsKey(location)) {
            return () -> new ByteArrayInputStream((byte[])DATA.get(location));
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (packType == PackType.CLIENT_RESOURCES) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String finalPath = path;
            DATA.keySet().stream().filter(Objects::nonNull).filter(loc -> loc.m_135815_().startsWith(finalPath)).forEach(id -> {
                IoSupplier<InputStream> resource = this.m_214146_(packType, (ResourceLocation)id);
                if (resource != null) {
                    resourceOutput.accept(id, resource);
                }
            });
        }
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? CLIENT_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        if (metaReader == PackMetadataSection.f_243696_) {
            return (T)new PackMetadataSection((Component)Component.m_237113_((String)"GTCEu dynamic assets"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
        }
        return null;
    }

    public String m_5542_() {
        return this.name;
    }

    public void close() {
    }

    public static ResourceLocation getBlockStateLocation(ResourceLocation blockId) {
        return new ResourceLocation(blockId.m_135827_(), String.join((CharSequence)"", "blockstates/", blockId.m_135815_(), ".json"));
    }

    public static ResourceLocation getModelLocation(ResourceLocation blockId) {
        return new ResourceLocation(blockId.m_135827_(), String.join((CharSequence)"", "models/", blockId.m_135815_(), ".json"));
    }

    public static ResourceLocation getItemModelLocation(ResourceLocation itemId) {
        return new ResourceLocation(itemId.m_135827_(), String.join((CharSequence)"", "models/item/", itemId.m_135815_(), ".json"));
    }

    public static ResourceLocation getTextureLocation(@Nullable String path, ResourceLocation tagId) {
        if (path == null) {
            return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", "textures/", tagId.m_135815_(), ".png"));
        }
        return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", "textures/", path, "/", tagId.m_135815_(), ".png"));
    }

    static {
        CLIENT_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gtceu", "minecraft", "forge", "c"}));
    }
}

