/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.journeymap;

import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.ButtonState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import journeymap.client.api.model.IFullscreen;
import journeymap.client.io.ThemeLoader;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Fullscreen.class}, remap=false)
public abstract class FullscreenMixin
extends JmUI
implements IFullscreen {
    @Shadow(remap=false)
    private ThemeToolbar mapTypeToolbar;
    @Unique
    private Map<String, ThemeToggle> gtceu$buttons;
    @Unique
    private ThemeToolbar gtceu$overlayToolbar;

    public FullscreenMixin(String title) {
        super(title);
    }

    @Inject(method={"initButtons"}, at={@At(value="FIELD", target="Ljourneymap/client/ui/fullscreen/Fullscreen;mapTypeToolbar:Ljourneymap/client/ui/theme/ThemeToolbar;", opcode=181, shift=At.Shift.AFTER)}, remap=false)
    private void gtceu$injectInitButtons(CallbackInfo ci) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.journeyMapIntegration) {
            return;
        }
        Theme theme = ThemeLoader.getCurrentTheme();
        this.gtceu$buttons = new LinkedHashMap<String, ThemeToggle>();
        for (ButtonState.Button button : ButtonState.getAllButtons()) {
            ThemeToggle mapButton = (ThemeToggle)this.m_142416_((GuiEventListener)new ThemeToggle(theme, "gtceu.button." + button.name, button.name, b -> ButtonState.toggleButton(button)));
            mapButton.setToggled(Boolean.valueOf(ButtonState.isEnabled(button)), false);
            mapButton.setEnabled(true);
            mapButton.addToggleListener((onOffButton, b) -> {
                ButtonState.toggleButton(button);
                return true;
            });
            this.gtceu$buttons.put(button.name, mapButton);
        }
        ArrayList<ThemeToggle> allButtons = new ArrayList<ThemeToggle>(this.gtceu$buttons.values());
        Collections.reverse(allButtons);
        if (ConfigHolder.INSTANCE.compat.minimap.rightToolbar) {
            this.gtceu$overlayToolbar = new ThemeToolbar(theme, (Button[])allButtons.toArray(Button[]::new));
            this.gtceu$overlayToolbar.setLayout(ButtonList.Layout.Vertical, ButtonList.Direction.RightToLeft);
            this.gtceu$overlayToolbar.addAllButtons((JmUI)((Fullscreen)this));
        } else {
            this.mapTypeToolbar.reverse();
            this.mapTypeToolbar.reverse().addAll(0, allButtons);
        }
    }

    @Inject(method={"layoutButtons"}, at={@At(value="TAIL")}, remap=false)
    private void gtceu$injectLayoutButtons(CallbackInfo ci) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.journeyMapIntegration) {
            return;
        }
        for (String buttonName : this.gtceu$buttons.keySet()) {
            this.gtceu$buttons.get(buttonName).setToggled(Boolean.valueOf(ButtonState.isEnabled(buttonName)), false);
        }
        if (ConfigHolder.INSTANCE.compat.minimap.rightToolbar) {
            this.gtceu$overlayToolbar.layoutCenteredVertical(this.f_96543_ - this.gtceu$overlayToolbar.getHMargin(), this.f_96544_ / 2, false, this.mapTypeToolbar.getToolbarSpec().padding);
        }
    }
}

