/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcFurnaceLogic
implements GTRecipeType.ICustomRecipeLogic {
    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        IGTTool tool;
        IItemHandlerModifiable[] itemInputs = (IItemHandlerModifiable[])Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP), ArrayList::new).stream().filter(IItemHandlerModifiable.class::isInstance).map(IItemHandlerModifiable.class::cast).toArray(IItemHandlerModifiable[]::new);
        CombinedInvWrapper inputs = new CombinedInvWrapper(itemInputs);
        ItemStack stack = inputs.getStackInSlot(0);
        TurbineRotorBehaviour turbineBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        if (turbineBehaviour != null) {
            float durability = 1.0f - (float)turbineBehaviour.getPartDamage(stack) / (float)turbineBehaviour.getPartMaxDurability(stack);
            return this.applyDurabilityRecipe("rotor_decomp", stack, turbineBehaviour.getPartMaterial(stack), (float)(TagPrefix.turbineBlade.materialAmount() * 8L) / 3628800.0f, durability, GTValues.VH[4], 1);
        }
        Item item = stack.m_41720_();
        if (item instanceof IGTTool && !(tool = (IGTTool)item).isElectric()) {
            float durability = (float)(tool.getTotalMaxDurability(stack) - stack.m_41773_() + 1) / (float)(tool.getTotalMaxDurability(stack) + 1);
            return this.applyDurabilityRecipe("tool_decomp", stack, tool.getMaterial(), tool.getToolType().materialAmount / 3628800L, durability, GTValues.VH[1], 2);
        }
        return null;
    }

    @Nullable
    public GTRecipe applyDurabilityRecipe(String id, ItemStack inputStack, @NotNull Material mat, float fullAmount, float durability, long voltage, int durationFactor) {
        if (!mat.hasProperty(PropertyKey.INGOT)) {
            return null;
        }
        IngotProperty material = mat.getProperty(PropertyKey.INGOT);
        Material materialArc = material.getArcSmeltingInto();
        float outputAmount = durability * fullAmount;
        int dustAmount = (int)outputAmount;
        int leftover = (int)((outputAmount - (float)dustAmount) * 9.0f);
        if (dustAmount == 0 && leftover == 0) {
            return null;
        }
        GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder(id + "/" + mat.getName(), new Object[0]).inputItems(inputStack).inputFluids(GTMaterials.Oxygen.getFluid((int)((float)materialArc.getMass() * outputAmount) * durationFactor)).EUt(voltage).duration((int)((float)materialArc.getMass() * outputAmount) * durationFactor);
        if (dustAmount > 0) {
            builder.outputItems(TagPrefix.ingot, materialArc, dustAmount);
        }
        if (leftover > 0) {
            builder.outputItems(TagPrefix.nugget, materialArc, leftover);
        }
        return builder.buildRawRecipe();
    }

    @Override
    public void buildRepresentativeRecipes() {
        ItemStack stack = GTItems.TURBINE_ROTOR.asStack();
        stack.m_41714_((Component)Component.m_237115_((String)"gtceu.auto_decomp.rotor"));
        float durability = 0.69f;
        TurbineRotorBehaviour.getBehaviour(stack).setPartMaterial(stack, GTMaterials.Iron);
        TurbineRotorBehaviour.getBehaviour(stack).setPartDamage(stack, 8928);
        TurbineRotorBehaviour turbineBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        GTRecipe rotorRecipe = this.applyDurabilityRecipe("rotor_decomp", stack, turbineBehaviour.getPartMaterial(stack), (float)(TagPrefix.turbineBlade.materialAmount() * 8L) / 3628800.0f, durability, GTValues.VH[4], 1);
        rotorRecipe.setId(rotorRecipe.m_6423_().m_246208_("/"));
        stack = ((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)GTMaterials.Iron, (Object)GTToolType.PICKAXE)).asStack();
        stack.m_41714_((Component)Component.m_237115_((String)"gtceu.auto_decomp.tool"));
        stack.m_41721_(79);
        GTRecipe pickaxeRecipe = this.applyDurabilityRecipe("tool_decomp", stack, GTMaterials.Iron, GTToolType.PICKAXE.materialAmount / 3628800L, durability, GTValues.VH[1], 2);
        pickaxeRecipe.setId(pickaxeRecipe.m_6423_().m_246208_("/"));
        GTRecipeTypes.ARC_FURNACE_RECIPES.addToMainCategory(pickaxeRecipe);
        GTRecipeTypes.ARC_FURNACE_RECIPES.addToMainCategory(rotorRecipe);
        GTRecipeType.ICustomRecipeLogic.super.buildRepresentativeRecipes();
    }
}

